# coding: utf-8

from __future__ import annotations

from datetime import date, datetime  # noqa: F401

import re  # noqa: F401
from typing import Any, Dict, List, Optional, Union, Literal  # noqa: F401

from pydantic import AnyUrl, BaseModel, EmailStr, validator, Field, Extra  # noqa: F401


class RevokeRequest(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.

    RevokeRequest - a model defined in OpenAPI
        cred_ex_id: Credential exchange identifier [Optional].
        cred_rev_id: Credential revocation identifier [Optional].
        publish: (True) publish revocation to ledger immediately, or (default, False) mark it pending [Optional].
        rev_reg_id: Revocation registry identifier [Optional].
    """

    cred_ex_id: Optional[str] = None
    cred_rev_id: Optional[str] = None
    publish: Optional[bool] = None
    rev_reg_id: Optional[str] = None

    def __init__(
        self,
        *,
        cred_ex_id: Optional[str] = None,
        cred_rev_id: Optional[str] = None,
        publish: Optional[bool] = None,
        rev_reg_id: Optional[str] = None,
        **kwargs,
    ):
        super().__init__(
            cred_ex_id=cred_ex_id,
            cred_rev_id=cred_rev_id,
            publish=publish,
            rev_reg_id=rev_reg_id,
            **kwargs,
        )

    @validator("cred_ex_id")
    def cred_ex_id_pattern(cls, value):
        # Property is optional
        if value is None:
            return

        pattern = r"[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-4[a-fA-F0-9]{3}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}"
        if not re.match(pattern, value):
            raise ValueError(
                f"Value of cred_ex_id does not match regex pattern ('{pattern}')"
            )
        return value

    @validator("cred_rev_id")
    def cred_rev_id_pattern(cls, value):
        # Property is optional
        if value is None:
            return

        pattern = r"^[1-9][0-9]*$"
        if not re.match(pattern, value):
            raise ValueError(
                f"Value of cred_rev_id does not match regex pattern ('{pattern}')"
            )
        return value

    @validator("rev_reg_id")
    def rev_reg_id_pattern(cls, value):
        # Property is optional
        if value is None:
            return

        pattern = r"^([123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz]{21,22}):4:([123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz]{21,22}):3:CL:(([1-9][0-9]*)|([123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz]{21,22}:2:.+:[0-9.]+))(:.+)?:CL_ACCUM:(.+$)"
        if not re.match(pattern, value):
            raise ValueError(
                f"Value of rev_reg_id does not match regex pattern ('{pattern}')"
            )
        return value

    class Config:
        allow_population_by_field_name = True


RevokeRequest.update_forward_refs()
