# coding: utf-8

from __future__ import annotations

from datetime import date, datetime  # noqa: F401

import re  # noqa: F401
from typing import Any, Dict, List, Optional, Union, Literal  # noqa: F401

from pydantic import AnyUrl, BaseModel, EmailStr, validator, Field, Extra  # noqa: F401
from aries_cloudcontroller.model.indy_rev_reg_def import IndyRevRegDef
from aries_cloudcontroller.model.indy_rev_reg_entry import IndyRevRegEntry


class IssuerRevRegRecord(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.

    IssuerRevRegRecord - a model defined in OpenAPI
        created_at: Time of record creation [Optional].
        cred_def_id: Credential definition identifier [Optional].
        error_msg: Error message [Optional].
        issuer_did: Issuer DID [Optional].
        max_cred_num: Maximum number of credentials for revocation registry [Optional].
        pending_pub: Credential revocation identifier for credential revoked and pending publication to ledger [Optional].
        record_id: Issuer revocation registry record identifier [Optional].
        revoc_def_type: Revocation registry type (specify CL_ACCUM) [Optional].
        revoc_reg_def: Revocation registry definition [Optional].
        revoc_reg_entry: Revocation registry entry [Optional].
        revoc_reg_id: Revocation registry identifier [Optional].
        state: Issue revocation registry record state [Optional].
        tag: Tag within issuer revocation registry identifier [Optional].
        tails_hash: Tails hash [Optional].
        tails_local_path: Local path to tails file [Optional].
        tails_public_uri: Public URI for tails file [Optional].
        updated_at: Time of last record update [Optional].
    """

    created_at: Optional[str] = None
    cred_def_id: Optional[str] = None
    error_msg: Optional[str] = None
    issuer_did: Optional[str] = None
    max_cred_num: Optional[int] = None
    pending_pub: Optional[List[str]] = None
    record_id: Optional[str] = None
    revoc_def_type: Optional[Literal["CL_ACCUM"]] = None
    revoc_reg_def: Optional[IndyRevRegDef] = None
    revoc_reg_entry: Optional[IndyRevRegEntry] = None
    revoc_reg_id: Optional[str] = None
    state: Optional[str] = None
    tag: Optional[str] = None
    tails_hash: Optional[str] = None
    tails_local_path: Optional[str] = None
    tails_public_uri: Optional[str] = None
    updated_at: Optional[str] = None

    def __init__(
        self,
        *,
        created_at: Optional[str] = None,
        cred_def_id: Optional[str] = None,
        error_msg: Optional[str] = None,
        issuer_did: Optional[str] = None,
        max_cred_num: Optional[int] = None,
        pending_pub: Optional[List[str]] = None,
        record_id: Optional[str] = None,
        revoc_def_type: Optional[Literal["CL_ACCUM"]] = None,
        revoc_reg_def: Optional[IndyRevRegDef] = None,
        revoc_reg_entry: Optional[IndyRevRegEntry] = None,
        revoc_reg_id: Optional[str] = None,
        state: Optional[str] = None,
        tag: Optional[str] = None,
        tails_hash: Optional[str] = None,
        tails_local_path: Optional[str] = None,
        tails_public_uri: Optional[str] = None,
        updated_at: Optional[str] = None,
        **kwargs,
    ):
        super().__init__(
            created_at=created_at,
            cred_def_id=cred_def_id,
            error_msg=error_msg,
            issuer_did=issuer_did,
            max_cred_num=max_cred_num,
            pending_pub=pending_pub,
            record_id=record_id,
            revoc_def_type=revoc_def_type,
            revoc_reg_def=revoc_reg_def,
            revoc_reg_entry=revoc_reg_entry,
            revoc_reg_id=revoc_reg_id,
            state=state,
            tag=tag,
            tails_hash=tails_hash,
            tails_local_path=tails_local_path,
            tails_public_uri=tails_public_uri,
            updated_at=updated_at,
            **kwargs,
        )

    @validator("created_at")
    def created_at_pattern(cls, value):
        # Property is optional
        if value is None:
            return

        pattern = r"^\d{4}-\d\d-\d\d[T ]\d\d:\d\d(?:\:(?:\d\d(?:\.\d{1,6})?))?(?:[+-]\d\d:?\d\d|Z|)$"
        if not re.match(pattern, value):
            raise ValueError(
                f"Value of created_at does not match regex pattern ('{pattern}')"
            )
        return value

    @validator("cred_def_id")
    def cred_def_id_pattern(cls, value):
        # Property is optional
        if value is None:
            return

        pattern = r"^([123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz]{21,22}):3:CL:(([1-9][0-9]*)|([123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz]{21,22}:2:.+:[0-9.]+)):(.+)?$"
        if not re.match(pattern, value):
            raise ValueError(
                f"Value of cred_def_id does not match regex pattern ('{pattern}')"
            )
        return value

    @validator("issuer_did")
    def issuer_did_pattern(cls, value):
        # Property is optional
        if value is None:
            return

        pattern = r"^(did:sov:)?[123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz]{21,22}$"
        if not re.match(pattern, value):
            raise ValueError(
                f"Value of issuer_did does not match regex pattern ('{pattern}')"
            )
        return value

    @validator("revoc_reg_id")
    def revoc_reg_id_pattern(cls, value):
        # Property is optional
        if value is None:
            return

        pattern = r"^([123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz]{21,22}):4:([123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz]{21,22}):3:CL:(([1-9][0-9]*)|([123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz]{21,22}:2:.+:[0-9.]+))(:.+)?:CL_ACCUM:(.+$)"
        if not re.match(pattern, value):
            raise ValueError(
                f"Value of revoc_reg_id does not match regex pattern ('{pattern}')"
            )
        return value

    @validator("tails_hash")
    def tails_hash_pattern(cls, value):
        # Property is optional
        if value is None:
            return

        pattern = (
            r"^[123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz]{43,44}$"
        )
        if not re.match(pattern, value):
            raise ValueError(
                f"Value of tails_hash does not match regex pattern ('{pattern}')"
            )
        return value

    @validator("updated_at")
    def updated_at_pattern(cls, value):
        # Property is optional
        if value is None:
            return

        pattern = r"^\d{4}-\d\d-\d\d[T ]\d\d:\d\d(?:\:(?:\d\d(?:\.\d{1,6})?))?(?:[+-]\d\d:?\d\d|Z|)$"
        if not re.match(pattern, value):
            raise ValueError(
                f"Value of updated_at does not match regex pattern ('{pattern}')"
            )
        return value

    class Config:
        allow_population_by_field_name = True


IssuerRevRegRecord.update_forward_refs()
