# coding: utf-8

from __future__ import annotations

from datetime import date, datetime  # noqa: F401

import re  # noqa: F401
from typing import Any, Dict, List, Optional, Union, Literal  # noqa: F401

from pydantic import AnyUrl, BaseModel, EmailStr, validator, Field, Extra  # noqa: F401


class IssuerCredRevRecord(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.

    IssuerCredRevRecord - a model defined in OpenAPI
        created_at: Time of record creation [Optional].
        cred_def_id: Credential definition identifier [Optional].
        cred_ex_id: Credential exchange record identifier at credential issue [Optional].
        cred_rev_id: Credential revocation identifier [Optional].
        record_id: Issuer credential revocation record identifier [Optional].
        rev_reg_id: Revocation registry identifier [Optional].
        state: Issue credential revocation record state [Optional].
        updated_at: Time of last record update [Optional].
    """

    created_at: Optional[str] = None
    cred_def_id: Optional[str] = None
    cred_ex_id: Optional[str] = None
    cred_rev_id: Optional[str] = None
    record_id: Optional[str] = None
    rev_reg_id: Optional[str] = None
    state: Optional[str] = None
    updated_at: Optional[str] = None

    def __init__(
        self,
        *,
        created_at: Optional[str] = None,
        cred_def_id: Optional[str] = None,
        cred_ex_id: Optional[str] = None,
        cred_rev_id: Optional[str] = None,
        record_id: Optional[str] = None,
        rev_reg_id: Optional[str] = None,
        state: Optional[str] = None,
        updated_at: Optional[str] = None,
        **kwargs,
    ):
        super().__init__(
            created_at=created_at,
            cred_def_id=cred_def_id,
            cred_ex_id=cred_ex_id,
            cred_rev_id=cred_rev_id,
            record_id=record_id,
            rev_reg_id=rev_reg_id,
            state=state,
            updated_at=updated_at,
            **kwargs,
        )

    @validator("created_at")
    def created_at_pattern(cls, value):
        # Property is optional
        if value is None:
            return

        pattern = r"^\d{4}-\d\d-\d\d[T ]\d\d:\d\d(?:\:(?:\d\d(?:\.\d{1,6})?))?(?:[+-]\d\d:?\d\d|Z|)$"
        if not re.match(pattern, value):
            raise ValueError(
                f"Value of created_at does not match regex pattern ('{pattern}')"
            )
        return value

    @validator("cred_def_id")
    def cred_def_id_pattern(cls, value):
        # Property is optional
        if value is None:
            return

        pattern = r"^([123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz]{21,22}):3:CL:(([1-9][0-9]*)|([123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz]{21,22}:2:.+:[0-9.]+)):(.+)?$"
        if not re.match(pattern, value):
            raise ValueError(
                f"Value of cred_def_id does not match regex pattern ('{pattern}')"
            )
        return value

    @validator("cred_rev_id")
    def cred_rev_id_pattern(cls, value):
        # Property is optional
        if value is None:
            return

        pattern = r"^[1-9][0-9]*$"
        if not re.match(pattern, value):
            raise ValueError(
                f"Value of cred_rev_id does not match regex pattern ('{pattern}')"
            )
        return value

    @validator("rev_reg_id")
    def rev_reg_id_pattern(cls, value):
        # Property is optional
        if value is None:
            return

        pattern = r"^([123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz]{21,22}):4:([123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz]{21,22}):3:CL:(([1-9][0-9]*)|([123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz]{21,22}:2:.+:[0-9.]+))(:.+)?:CL_ACCUM:(.+$)"
        if not re.match(pattern, value):
            raise ValueError(
                f"Value of rev_reg_id does not match regex pattern ('{pattern}')"
            )
        return value

    @validator("updated_at")
    def updated_at_pattern(cls, value):
        # Property is optional
        if value is None:
            return

        pattern = r"^\d{4}-\d\d-\d\d[T ]\d\d:\d\d(?:\:(?:\d\d(?:\.\d{1,6})?))?(?:[+-]\d\d:?\d\d|Z|)$"
        if not re.match(pattern, value):
            raise ValueError(
                f"Value of updated_at does not match regex pattern ('{pattern}')"
            )
        return value

    class Config:
        allow_population_by_field_name = True


IssuerCredRevRecord.update_forward_refs()
