# coding: utf-8

from __future__ import annotations

from datetime import date, datetime  # noqa: F401

import re  # noqa: F401
from typing import Any, Dict, List, Optional, Union, Literal  # noqa: F401

from pydantic import AnyUrl, BaseModel, EmailStr, validator, Field, Extra  # noqa: F401
from aries_cloudcontroller.model.indy_rev_reg_entry_value import IndyRevRegEntryValue


class IndyRevRegEntry(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.

    IndyRevRegEntry - a model defined in OpenAPI
        value: Revocation registry entry value [Optional].
        ver: Version of revocation registry entry [Optional].
    """

    value: Optional[IndyRevRegEntryValue] = None
    ver: Optional[str] = None

    def __init__(
        self,
        *,
        value: Optional[IndyRevRegEntryValue] = None,
        ver: Optional[str] = None,
        **kwargs,
    ):
        super().__init__(
            value=value,
            ver=ver,
            **kwargs,
        )

    @validator("ver")
    def ver_pattern(cls, value):
        # Property is optional
        if value is None:
            return

        pattern = r"^[0-9.]+$"
        if not re.match(pattern, value):
            raise ValueError(f"Value of ver does not match regex pattern ('{pattern}')")
        return value

    class Config:
        allow_population_by_field_name = True


IndyRevRegEntry.update_forward_refs()
