# coding: utf-8

from __future__ import annotations

from datetime import date, datetime  # noqa: F401

import re  # noqa: F401
from typing import Any, Dict, List, Optional, Union, Literal  # noqa: F401

from pydantic import AnyUrl, BaseModel, EmailStr, validator, Field, Extra  # noqa: F401
from aries_cloudcontroller.model.indy_rev_reg_def_value import IndyRevRegDefValue


class IndyRevRegDef(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.

    IndyRevRegDef - a model defined in OpenAPI
        cred_def_id: Credential definition identifier [Optional].
        id: Indy revocation registry identifier [Optional].
        revoc_def_type: Revocation registry type (specify CL_ACCUM) [Optional].
        tag: Revocation registry tag [Optional].
        value: Revocation registry definition value [Optional].
        ver: Version of revocation registry definition [Optional].
    """

    cred_def_id: Optional[str] = Field(None, alias="credDefId")
    id: Optional[str] = None
    revoc_def_type: Optional[Literal["CL_ACCUM"]] = Field(None, alias="revocDefType")
    tag: Optional[str] = None
    value: Optional[IndyRevRegDefValue] = None
    ver: Optional[str] = None

    def __init__(
        self,
        *,
        cred_def_id: Optional[str] = None,
        id: Optional[str] = None,
        revoc_def_type: Optional[Literal["CL_ACCUM"]] = None,
        tag: Optional[str] = None,
        value: Optional[IndyRevRegDefValue] = None,
        ver: Optional[str] = None,
        **kwargs,
    ):
        super().__init__(
            cred_def_id=cred_def_id,
            id=id,
            revoc_def_type=revoc_def_type,
            tag=tag,
            value=value,
            ver=ver,
            **kwargs,
        )

    @validator("cred_def_id")
    def cred_def_id_pattern(cls, value):
        # Property is optional
        if value is None:
            return

        pattern = r"^([123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz]{21,22}):3:CL:(([1-9][0-9]*)|([123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz]{21,22}:2:.+:[0-9.]+)):(.+)?$"
        if not re.match(pattern, value):
            raise ValueError(
                f"Value of cred_def_id does not match regex pattern ('{pattern}')"
            )
        return value

    @validator("id")
    def id_pattern(cls, value):
        # Property is optional
        if value is None:
            return

        pattern = r"^([123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz]{21,22}):4:([123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz]{21,22}):3:CL:(([1-9][0-9]*)|([123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz]{21,22}:2:.+:[0-9.]+))(:.+)?:CL_ACCUM:(.+$)"
        if not re.match(pattern, value):
            raise ValueError(f"Value of id does not match regex pattern ('{pattern}')")
        return value

    @validator("ver")
    def ver_pattern(cls, value):
        # Property is optional
        if value is None:
            return

        pattern = r"^[0-9.]+$"
        if not re.match(pattern, value):
            raise ValueError(f"Value of ver does not match regex pattern ('{pattern}')")
        return value

    class Config:
        allow_population_by_field_name = True


IndyRevRegDef.update_forward_refs()
