# coding: utf-8

from __future__ import annotations

from datetime import date, datetime  # noqa: F401

import re  # noqa: F401
from typing import Any, Dict, List, Optional, Union, Literal  # noqa: F401

from pydantic import AnyUrl, BaseModel, EmailStr, validator, Field, Extra  # noqa: F401
from aries_cloudcontroller.model.indy_attr_value import IndyAttrValue


class IndyCredential(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.

    IndyCredential - a model defined in OpenAPI
        cred_def_id: Credential definition identifier.
        schema_id: Schema identifier.
        signature: Credential signature.
        signature_correctness_proof: Credential signature correctness proof.
        values: Credential attributes.
        rev_reg: Revocation registry state [Optional].
        rev_reg_id: Revocation registry identifier [Optional].
        witness: Witness for revocation proof [Optional].
    """

    cred_def_id: str
    schema_id: str
    signature: Dict[str, Any]
    signature_correctness_proof: Dict[str, Any]
    values: Dict[str, IndyAttrValue]
    rev_reg: Optional[Dict[str, Any]] = None
    rev_reg_id: Optional[str] = None
    witness: Optional[Dict[str, Any]] = None

    def __init__(
        self,
        *,
        cred_def_id: str = None,
        schema_id: str = None,
        signature: Dict[str, Any] = None,
        signature_correctness_proof: Dict[str, Any] = None,
        values: Dict[str, IndyAttrValue] = None,
        rev_reg: Optional[Dict[str, Any]] = None,
        rev_reg_id: Optional[str] = None,
        witness: Optional[Dict[str, Any]] = None,
        **kwargs,
    ):
        super().__init__(
            cred_def_id=cred_def_id,
            rev_reg=rev_reg,
            rev_reg_id=rev_reg_id,
            schema_id=schema_id,
            signature=signature,
            signature_correctness_proof=signature_correctness_proof,
            values=values,
            witness=witness,
            **kwargs,
        )

    @validator("cred_def_id")
    def cred_def_id_pattern(cls, value):

        pattern = r"^([123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz]{21,22}):3:CL:(([1-9][0-9]*)|([123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz]{21,22}:2:.+:[0-9.]+)):(.+)?$"
        if not re.match(pattern, value):
            raise ValueError(
                f"Value of cred_def_id does not match regex pattern ('{pattern}')"
            )
        return value

    @validator("rev_reg_id")
    def rev_reg_id_pattern(cls, value):
        # Property is optional
        if value is None:
            return

        pattern = r"^([123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz]{21,22}):4:([123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz]{21,22}):3:CL:(([1-9][0-9]*)|([123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz]{21,22}:2:.+:[0-9.]+))(:.+)?:CL_ACCUM:(.+$)"
        if not re.match(pattern, value):
            raise ValueError(
                f"Value of rev_reg_id does not match regex pattern ('{pattern}')"
            )
        return value

    @validator("schema_id")
    def schema_id_pattern(cls, value):

        pattern = r"^[123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz]{21,22}:2:.+:[0-9.]+$"
        if not re.match(pattern, value):
            raise ValueError(
                f"Value of schema_id does not match regex pattern ('{pattern}')"
            )
        return value

    class Config:
        allow_population_by_field_name = True


IndyCredential.update_forward_refs()
