# coding: utf-8

from __future__ import annotations

from datetime import date, datetime  # noqa: F401

import re  # noqa: F401
from typing import Any, Dict, List, Optional, Union, Literal  # noqa: F401

from pydantic import AnyUrl, BaseModel, EmailStr, validator, Field, Extra  # noqa: F401


class IndyCredRequest(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.

    IndyCredRequest - a model defined in OpenAPI
        blinded_ms: Blinded master secret.
        blinded_ms_correctness_proof: Blinded master secret correctness proof.
        cred_def_id: Credential definition identifier.
        nonce: Nonce in credential request.
        prover_did: Prover DID [Optional].
    """

    blinded_ms: Dict[str, Any]
    blinded_ms_correctness_proof: Dict[str, Any]
    cred_def_id: str
    nonce: str
    prover_did: Optional[str] = None

    def __init__(
        self,
        *,
        blinded_ms: Dict[str, Any] = None,
        blinded_ms_correctness_proof: Dict[str, Any] = None,
        cred_def_id: str = None,
        nonce: str = None,
        prover_did: Optional[str] = None,
        **kwargs,
    ):
        super().__init__(
            blinded_ms=blinded_ms,
            blinded_ms_correctness_proof=blinded_ms_correctness_proof,
            cred_def_id=cred_def_id,
            nonce=nonce,
            prover_did=prover_did,
            **kwargs,
        )

    @validator("cred_def_id")
    def cred_def_id_pattern(cls, value):

        pattern = r"^([123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz]{21,22}):3:CL:(([1-9][0-9]*)|([123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz]{21,22}:2:.+:[0-9.]+)):(.+)?$"
        if not re.match(pattern, value):
            raise ValueError(
                f"Value of cred_def_id does not match regex pattern ('{pattern}')"
            )
        return value

    @validator("nonce")
    def nonce_pattern(cls, value):

        pattern = r"^[0-9]*$"
        if not re.match(pattern, value):
            raise ValueError(
                f"Value of nonce does not match regex pattern ('{pattern}')"
            )
        return value

    @validator("prover_did")
    def prover_did_pattern(cls, value):
        # Property is optional
        if value is None:
            return

        pattern = r"^(did:sov:)?[123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz]{21,22}$"
        if not re.match(pattern, value):
            raise ValueError(
                f"Value of prover_did does not match regex pattern ('{pattern}')"
            )
        return value

    class Config:
        allow_population_by_field_name = True


IndyCredRequest.update_forward_refs()
