# coding: utf-8

from __future__ import annotations

from datetime import date, datetime  # noqa: F401

import re  # noqa: F401
from typing import Any, Dict, List, Optional, Union, Literal  # noqa: F401

from pydantic import AnyUrl, BaseModel, EmailStr, validator, Field, Extra  # noqa: F401
from aries_cloudcontroller.model.cred_def_value import CredDefValue


class CredentialDefinition(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.

    CredentialDefinition - a model defined in OpenAPI
        id: Credential definition identifier [Optional].
        schema_id: Schema identifier within credential definition identifier [Optional].
        tag: Tag within credential definition identifier [Optional].
        type: Signature type: CL for Camenisch-Lysyanskaya [Optional].
        value: Credential definition primary and revocation values [Optional].
        ver: Node protocol version [Optional].
    """

    id: Optional[str] = None
    schema_id: Optional[str] = Field(None, alias="schemaId")
    tag: Optional[str] = None
    type: Optional[Literal["CL"]] = None
    value: Optional[CredDefValue] = None
    ver: Optional[str] = None

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        schema_id: Optional[str] = None,
        tag: Optional[str] = None,
        type: Optional[Literal["CL"]] = None,
        value: Optional[CredDefValue] = None,
        ver: Optional[str] = None,
        **kwargs,
    ):
        super().__init__(
            id=id,
            schema_id=schema_id,
            tag=tag,
            type=type,
            value=value,
            ver=ver,
            **kwargs,
        )

    @validator("id")
    def id_pattern(cls, value):
        # Property is optional
        if value is None:
            return

        pattern = r"^([123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz]{21,22}):3:CL:(([1-9][0-9]*)|([123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz]{21,22}:2:.+:[0-9.]+)):(.+)?$"
        if not re.match(pattern, value):
            raise ValueError(f"Value of id does not match regex pattern ('{pattern}')")
        return value

    @validator("ver")
    def ver_pattern(cls, value):
        # Property is optional
        if value is None:
            return

        pattern = r"^[0-9.]+$"
        if not re.match(pattern, value):
            raise ValueError(f"Value of ver does not match regex pattern ('{pattern}')")
        return value

    class Config:
        allow_population_by_field_name = True


CredentialDefinition.update_forward_refs()
