# coding: utf-8

from __future__ import annotations

from datetime import date, datetime  # noqa: F401

import re  # noqa: F401
from typing import Any, Dict, List, Optional, Union, Literal  # noqa: F401

from pydantic import AnyUrl, BaseModel, EmailStr, validator, Field, Extra  # noqa: F401


class CreateWalletResponse(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.

    CreateWalletResponse - a model defined in OpenAPI
        key_management_mode: Mode regarding management of wallet key.
        wallet_id: Wallet record ID.
        created_at: Time of record creation [Optional].
        settings: Settings for this wallet. [Optional].
        state: Current record state [Optional].
        token: Authorization token to authenticate wallet requests [Optional].
        updated_at: Time of last record update [Optional].
    """

    key_management_mode: Literal["managed", "unmanaged"]
    wallet_id: str
    created_at: Optional[str] = None
    settings: Optional[Dict[str, Any]] = None
    state: Optional[str] = None
    token: Optional[str] = None
    updated_at: Optional[str] = None

    def __init__(
        self,
        *,
        key_management_mode: Literal["managed", "unmanaged"] = None,
        wallet_id: str = None,
        created_at: Optional[str] = None,
        settings: Optional[Dict[str, Any]] = None,
        state: Optional[str] = None,
        token: Optional[str] = None,
        updated_at: Optional[str] = None,
        **kwargs,
    ):
        super().__init__(
            created_at=created_at,
            key_management_mode=key_management_mode,
            settings=settings,
            state=state,
            token=token,
            updated_at=updated_at,
            wallet_id=wallet_id,
            **kwargs,
        )

    @validator("created_at")
    def created_at_pattern(cls, value):
        # Property is optional
        if value is None:
            return

        pattern = r"^\d{4}-\d\d-\d\d[T ]\d\d:\d\d(?:\:(?:\d\d(?:\.\d{1,6})?))?(?:[+-]\d\d:?\d\d|Z|)$"
        if not re.match(pattern, value):
            raise ValueError(
                f"Value of created_at does not match regex pattern ('{pattern}')"
            )
        return value

    @validator("updated_at")
    def updated_at_pattern(cls, value):
        # Property is optional
        if value is None:
            return

        pattern = r"^\d{4}-\d\d-\d\d[T ]\d\d:\d\d(?:\:(?:\d\d(?:\.\d{1,6})?))?(?:[+-]\d\d:?\d\d|Z|)$"
        if not re.match(pattern, value):
            raise ValueError(
                f"Value of updated_at does not match regex pattern ('{pattern}')"
            )
        return value

    class Config:
        allow_population_by_field_name = True


CreateWalletResponse.update_forward_refs()
