# coding: utf-8

from __future__ import annotations

from datetime import date, datetime  # noqa: F401

import re  # noqa: F401
from typing import Any, Dict, List, Optional, Union, Literal  # noqa: F401

from pydantic import AnyUrl, BaseModel, EmailStr, validator, Field, Extra  # noqa: F401


class CreateWalletRequest(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.

    CreateWalletRequest - a model defined in OpenAPI
        image_url: Image url for this wallet. This image url is publicized            (self-attested) to other agents as part of forming a connection. [Optional].
        key_management_mode: Key management method to use for this wallet. [Optional].
        label: Label for this wallet. This label is publicized            (self-attested) to other agents as part of forming a connection. [Optional].
        wallet_dispatch_type: Webhook target dispatch type for this wallet.             default - Dispatch only to webhooks associated with this wallet.             base - Dispatch only to webhooks associated with the base wallet.             both - Dispatch to both webhook targets. [Optional].
        wallet_key: Master key used for key derivation. [Optional].
        wallet_name: Wallet name [Optional].
        wallet_type: Type of the wallet to create [Optional].
        wallet_webhook_urls: List of Webhook URLs associated with this subwallet [Optional].
    """

    image_url: Optional[str] = None
    key_management_mode: Optional[Literal["managed"]] = None
    label: Optional[str] = None
    wallet_dispatch_type: Optional[Literal["default", "both", "base"]] = None
    wallet_key: Optional[str] = None
    wallet_name: Optional[str] = None
    wallet_type: Optional[Literal["askar", "in_memory", "indy"]] = None
    wallet_webhook_urls: Optional[List[str]] = None

    def __init__(
        self,
        *,
        image_url: Optional[str] = None,
        key_management_mode: Optional[Literal["managed"]] = None,
        label: Optional[str] = None,
        wallet_dispatch_type: Optional[Literal["default", "both", "base"]] = None,
        wallet_key: Optional[str] = None,
        wallet_name: Optional[str] = None,
        wallet_type: Optional[Literal["askar", "in_memory", "indy"]] = None,
        wallet_webhook_urls: Optional[List[str]] = None,
        **kwargs,
    ):
        super().__init__(
            image_url=image_url,
            key_management_mode=key_management_mode,
            label=label,
            wallet_dispatch_type=wallet_dispatch_type,
            wallet_key=wallet_key,
            wallet_name=wallet_name,
            wallet_type=wallet_type,
            wallet_webhook_urls=wallet_webhook_urls,
            **kwargs,
        )

    class Config:
        allow_population_by_field_name = True


CreateWalletRequest.update_forward_refs()
