# Alexflipnote.py
 An easy to use Python Wrapper for the AlexFlipnote API

# Requirements
- Python 3.6 or above
- aiohttp (python3 -m pip install -U aiohttp)
- url_regex (python3 -m pip install -U url_regex)

# installation

### Using pip (recommended):
- pip install alexflipnote.py

# Endpoints

|Name | Required param(s) | Optional param(s) | Accepted values
|---|---|--------|---| 
| achievement() | text | icon, return_bytes | str, int, boolean |
| amiajoke() | image | return_bytes | str, boolean |
| bad() | image | return_bytes | str, boolean |
| birb | none | none | none |
| calling() | text | return_bytes | str, boolean |
| captcha() | text | return_bytes | str, boolean |
| cats | none | none | none |
| challenge() | text | icon, return_bytes | str, int, boolean |
| colour() | none | colour | str |
| github_colours() | none | none | none |
| colour_image() | none | colour, return_bytes | str, boolean |
| colour_image_gradient() | none | colour, return_bytes | str, boolean |
| colourify() | image | c, b, return_bytes | str, str, str boolean |
| didyoumean() | top, bottom | return_bytes | str, str, boolean |
| dogs | none | none | none |
| drake() | top, bottom | return_bytes | str, str, boolean |
| facts() | text | return_bytes | str, boolean |
| filter() | name, image | return_bytes | valid_filter, str, boolean |
| floor() | text, image | return_bytes | str, str, boolean |
| fml | none | none | none |
| jokeoverhead() | image | return_bytes | str, boolean |
| pornhub() | text, text2 | return_bytes | str, str, boolean |
| sadcat | none | none | none |
| salty() | image | return_bytes | str, boolean |
| scroll() | text | return_bytes | str, boolean |
| ship() | user, user2 | return_bytes | str, str, boolean |
| steam() | profile | none | str |
| supreme() | text | dark, light, return_bytes | str, boolean |
| trash() | face, trash | return_bytes | str, boolean |

## What is return_bytes?
 You can set this to True (Defaults to False) to let the
 api return an io.BytesIO object, which can be passed it 
 to discord.File().
 
 **Here is an example of return_bytes in a discord.py bot:**
 ```py
import alexflipnote

@bot.command()
async def colourimage(ctx, colour):
    api = alexflipnote.Client()
    colour_image = api.colour_image(colour, return_bytes=True)
    await ctx.send(content="Images for {colour}",
                   file = discord.File(
                        colour_image,
                        filename="Colour.png"
                        )
                   )
 ```
# Examples

#### Get a random cat pic:

```py
import alexflipnote

afa = alexflipnote.Client()

print(await afa.cats)
>>> https://api.alexflipnote.dev/cats/grRlHyi-AL8_cats.jpg
``` 

#### Get supreme logo:

```py
import alexflipnote

afa = alexflipnote.Client()

print(await afa.supreme("#some text, yes", dark=True)) # making it dark, there is also light = True.
>>> https://api.alexflipnote.dev/supreme?text=%23some%20text,%20yes&dark=true
``` 

#### Color Command in a discord.py Bot:

```py
import alexflipnote
from discord.ext import commands

bot = commands.Bot(command_prefix="!")
alex_api = alexflipnote.Client()

# source: https://github.com/AlexFlipnote/discord_bot.py/blob/6d1adc72e9c19bb4ca90718e5f6d335faf842dd9/cogs/fun.py#L114-L147
@bot.command(aliases=['color'])
async def colourinfo(ctx, colour: str)):
    """ View the colour HEX details """
    async with ctx.channel.typing():
        if not permissions.can_embed(ctx):
            return await ctx.send("I can't embed in this channel ;-;")

        if colour[:1] == "#":
            colour = colour[1:]

        try:
            if color.lower() == "random":
                get_colour = await alex_api.colour() # random color
            get_colour = await alex_api.colour(colour)
        except ap.BadRequest as e: # if not valid HEX
            return await ctx.send(e)
        except aiohttp.ClientConnectorError:
            return await ctx.send("The API seems to be down...")
        except aiohttp.ContentTypeError:
            return await ctx.send("The API returned an error or didn't return JSON...")

        embed = discord.Embed(colour=get_colour.int)
        embed.set_thumbnail(url=get_colour.image)
        embed.set_image(url=get_colour.image_gradient)

        embed.add_field(name="HEX", value=get_colour.hex, inline=True)
        embed.add_field(name="RGB", value=get_colour.rgb, inline=True)
        embed.add_field(name="Int", value=get_colour.int, inline=True)
        embed.add_field(name="Brightness", value=get_colour.brightness, inline=True)

        await ctx.send(embed=embed, content=f"{ctx.invoked_with.title()} name: **{get_colour.name}**")
```

# Made by

This wrapper is made Soheab_#6240, contact me for anything related to this wrapper.

You could join my discord server here: https://discord.gg/yCzcfju or 
AlexFlipnote's server (recommended): https://discord.gg/alexflipnote .

Please report any bugs in the servers above or dm. Suggestions are also welcome.

