import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::GreengrassV2::ComponentVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html
 * @external
 */
export interface CfnComponentVersionProps {
    /**
     * `AWS::GreengrassV2::ComponentVersion.InlineRecipe`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html#cfn-greengrassv2-componentversion-inlinerecipe
     * @external
     */
    readonly inlineRecipe?: string;
    /**
     * `AWS::GreengrassV2::ComponentVersion.LambdaFunction`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html#cfn-greengrassv2-componentversion-lambdafunction
     * @external
     */
    readonly lambdaFunction?: CfnComponentVersion.LambdaFunctionRecipeSourceProperty | cdk.IResolvable;
    /**
     * `AWS::GreengrassV2::ComponentVersion.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html#cfn-greengrassv2-componentversion-tags
     * @external
     */
    readonly tags?: {
        [key: string]: (string);
    };
}
/**
 * A CloudFormation `AWS::GreengrassV2::ComponentVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html
 * @external
 * @cloudformationResource AWS::GreengrassV2::ComponentVersion
 */
export declare class CfnComponentVersion extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::GreengrassV2::ComponentVersion";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnComponentVersion;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute ComponentName
     */
    readonly attrComponentName: string;
    /**
     * @external
     * @cloudformationAttribute ComponentVersion
     */
    readonly attrComponentVersion: string;
    /**
     * `AWS::GreengrassV2::ComponentVersion.InlineRecipe`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html#cfn-greengrassv2-componentversion-inlinerecipe
     * @external
     */
    inlineRecipe: string | undefined;
    /**
     * `AWS::GreengrassV2::ComponentVersion.LambdaFunction`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html#cfn-greengrassv2-componentversion-lambdafunction
     * @external
     */
    lambdaFunction: CfnComponentVersion.LambdaFunctionRecipeSourceProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::GreengrassV2::ComponentVersion.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html#cfn-greengrassv2-componentversion-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::GreengrassV2::ComponentVersion`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnComponentVersionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::GreengrassV2::ComponentVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html
 * @external
 * @cloudformationResource AWS::GreengrassV2::ComponentVersion
 */
export declare namespace CfnComponentVersion {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-componentdependencyrequirement.html
     * @external
     */
    interface ComponentDependencyRequirementProperty {
        /**
         * `CfnComponentVersion.ComponentDependencyRequirementProperty.DependencyType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-componentdependencyrequirement.html#cfn-greengrassv2-componentversion-componentdependencyrequirement-dependencytype
         * @external
         */
        readonly dependencyType?: string;
        /**
         * `CfnComponentVersion.ComponentDependencyRequirementProperty.VersionRequirement`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-componentdependencyrequirement.html#cfn-greengrassv2-componentversion-componentdependencyrequirement-versionrequirement
         * @external
         */
        readonly versionRequirement?: string;
    }
}
/**
 * A CloudFormation `AWS::GreengrassV2::ComponentVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html
 * @external
 * @cloudformationResource AWS::GreengrassV2::ComponentVersion
 */
export declare namespace CfnComponentVersion {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-componentplatform.html
     * @external
     */
    interface ComponentPlatformProperty {
        /**
         * `CfnComponentVersion.ComponentPlatformProperty.Attributes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-componentplatform.html#cfn-greengrassv2-componentversion-componentplatform-attributes
         * @external
         */
        readonly attributes?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnComponentVersion.ComponentPlatformProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-componentplatform.html#cfn-greengrassv2-componentversion-componentplatform-name
         * @external
         */
        readonly name?: string;
    }
}
/**
 * A CloudFormation `AWS::GreengrassV2::ComponentVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html
 * @external
 * @cloudformationResource AWS::GreengrassV2::ComponentVersion
 */
export declare namespace CfnComponentVersion {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdacontainerparams.html
     * @external
     */
    interface LambdaContainerParamsProperty {
        /**
         * `CfnComponentVersion.LambdaContainerParamsProperty.Devices`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdacontainerparams.html#cfn-greengrassv2-componentversion-lambdacontainerparams-devices
         * @external
         */
        readonly devices?: Array<CfnComponentVersion.LambdaDeviceMountProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnComponentVersion.LambdaContainerParamsProperty.MemorySizeInKB`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdacontainerparams.html#cfn-greengrassv2-componentversion-lambdacontainerparams-memorysizeinkb
         * @external
         */
        readonly memorySizeInKb?: number;
        /**
         * `CfnComponentVersion.LambdaContainerParamsProperty.MountROSysfs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdacontainerparams.html#cfn-greengrassv2-componentversion-lambdacontainerparams-mountrosysfs
         * @external
         */
        readonly mountRoSysfs?: boolean | cdk.IResolvable;
        /**
         * `CfnComponentVersion.LambdaContainerParamsProperty.Volumes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdacontainerparams.html#cfn-greengrassv2-componentversion-lambdacontainerparams-volumes
         * @external
         */
        readonly volumes?: Array<CfnComponentVersion.LambdaVolumeMountProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::GreengrassV2::ComponentVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html
 * @external
 * @cloudformationResource AWS::GreengrassV2::ComponentVersion
 */
export declare namespace CfnComponentVersion {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdadevicemount.html
     * @external
     */
    interface LambdaDeviceMountProperty {
        /**
         * `CfnComponentVersion.LambdaDeviceMountProperty.AddGroupOwner`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdadevicemount.html#cfn-greengrassv2-componentversion-lambdadevicemount-addgroupowner
         * @external
         */
        readonly addGroupOwner?: boolean | cdk.IResolvable;
        /**
         * `CfnComponentVersion.LambdaDeviceMountProperty.Path`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdadevicemount.html#cfn-greengrassv2-componentversion-lambdadevicemount-path
         * @external
         */
        readonly path?: string;
        /**
         * `CfnComponentVersion.LambdaDeviceMountProperty.Permission`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdadevicemount.html#cfn-greengrassv2-componentversion-lambdadevicemount-permission
         * @external
         */
        readonly permission?: string;
    }
}
/**
 * A CloudFormation `AWS::GreengrassV2::ComponentVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html
 * @external
 * @cloudformationResource AWS::GreengrassV2::ComponentVersion
 */
export declare namespace CfnComponentVersion {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaeventsource.html
     * @external
     */
    interface LambdaEventSourceProperty {
        /**
         * `CfnComponentVersion.LambdaEventSourceProperty.Topic`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaeventsource.html#cfn-greengrassv2-componentversion-lambdaeventsource-topic
         * @external
         */
        readonly topic?: string;
        /**
         * `CfnComponentVersion.LambdaEventSourceProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaeventsource.html#cfn-greengrassv2-componentversion-lambdaeventsource-type
         * @external
         */
        readonly type?: string;
    }
}
/**
 * A CloudFormation `AWS::GreengrassV2::ComponentVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html
 * @external
 * @cloudformationResource AWS::GreengrassV2::ComponentVersion
 */
export declare namespace CfnComponentVersion {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html
     * @external
     */
    interface LambdaExecutionParametersProperty {
        /**
         * `CfnComponentVersion.LambdaExecutionParametersProperty.EnvironmentVariables`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html#cfn-greengrassv2-componentversion-lambdaexecutionparameters-environmentvariables
         * @external
         */
        readonly environmentVariables?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnComponentVersion.LambdaExecutionParametersProperty.EventSources`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html#cfn-greengrassv2-componentversion-lambdaexecutionparameters-eventsources
         * @external
         */
        readonly eventSources?: Array<CfnComponentVersion.LambdaEventSourceProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnComponentVersion.LambdaExecutionParametersProperty.ExecArgs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html#cfn-greengrassv2-componentversion-lambdaexecutionparameters-execargs
         * @external
         */
        readonly execArgs?: string[];
        /**
         * `CfnComponentVersion.LambdaExecutionParametersProperty.InputPayloadEncodingType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html#cfn-greengrassv2-componentversion-lambdaexecutionparameters-inputpayloadencodingtype
         * @external
         */
        readonly inputPayloadEncodingType?: string;
        /**
         * `CfnComponentVersion.LambdaExecutionParametersProperty.LinuxProcessParams`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html#cfn-greengrassv2-componentversion-lambdaexecutionparameters-linuxprocessparams
         * @external
         */
        readonly linuxProcessParams?: CfnComponentVersion.LambdaLinuxProcessParamsProperty | cdk.IResolvable;
        /**
         * `CfnComponentVersion.LambdaExecutionParametersProperty.MaxIdleTimeInSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html#cfn-greengrassv2-componentversion-lambdaexecutionparameters-maxidletimeinseconds
         * @external
         */
        readonly maxIdleTimeInSeconds?: number;
        /**
         * `CfnComponentVersion.LambdaExecutionParametersProperty.MaxInstancesCount`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html#cfn-greengrassv2-componentversion-lambdaexecutionparameters-maxinstancescount
         * @external
         */
        readonly maxInstancesCount?: number;
        /**
         * `CfnComponentVersion.LambdaExecutionParametersProperty.MaxQueueSize`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html#cfn-greengrassv2-componentversion-lambdaexecutionparameters-maxqueuesize
         * @external
         */
        readonly maxQueueSize?: number;
        /**
         * `CfnComponentVersion.LambdaExecutionParametersProperty.Pinned`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html#cfn-greengrassv2-componentversion-lambdaexecutionparameters-pinned
         * @external
         */
        readonly pinned?: boolean | cdk.IResolvable;
        /**
         * `CfnComponentVersion.LambdaExecutionParametersProperty.StatusTimeoutInSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html#cfn-greengrassv2-componentversion-lambdaexecutionparameters-statustimeoutinseconds
         * @external
         */
        readonly statusTimeoutInSeconds?: number;
        /**
         * `CfnComponentVersion.LambdaExecutionParametersProperty.TimeoutInSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html#cfn-greengrassv2-componentversion-lambdaexecutionparameters-timeoutinseconds
         * @external
         */
        readonly timeoutInSeconds?: number;
    }
}
/**
 * A CloudFormation `AWS::GreengrassV2::ComponentVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html
 * @external
 * @cloudformationResource AWS::GreengrassV2::ComponentVersion
 */
export declare namespace CfnComponentVersion {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdafunctionrecipesource.html
     * @external
     */
    interface LambdaFunctionRecipeSourceProperty {
        /**
         * `CfnComponentVersion.LambdaFunctionRecipeSourceProperty.ComponentDependencies`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdafunctionrecipesource.html#cfn-greengrassv2-componentversion-lambdafunctionrecipesource-componentdependencies
         * @external
         */
        readonly componentDependencies?: {
            [key: string]: (CfnComponentVersion.ComponentDependencyRequirementProperty | cdk.IResolvable);
        } | cdk.IResolvable;
        /**
         * `CfnComponentVersion.LambdaFunctionRecipeSourceProperty.ComponentLambdaParameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdafunctionrecipesource.html#cfn-greengrassv2-componentversion-lambdafunctionrecipesource-componentlambdaparameters
         * @external
         */
        readonly componentLambdaParameters?: CfnComponentVersion.LambdaExecutionParametersProperty | cdk.IResolvable;
        /**
         * `CfnComponentVersion.LambdaFunctionRecipeSourceProperty.ComponentName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdafunctionrecipesource.html#cfn-greengrassv2-componentversion-lambdafunctionrecipesource-componentname
         * @external
         */
        readonly componentName?: string;
        /**
         * `CfnComponentVersion.LambdaFunctionRecipeSourceProperty.ComponentPlatforms`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdafunctionrecipesource.html#cfn-greengrassv2-componentversion-lambdafunctionrecipesource-componentplatforms
         * @external
         */
        readonly componentPlatforms?: Array<CfnComponentVersion.ComponentPlatformProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnComponentVersion.LambdaFunctionRecipeSourceProperty.ComponentVersion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdafunctionrecipesource.html#cfn-greengrassv2-componentversion-lambdafunctionrecipesource-componentversion
         * @external
         */
        readonly componentVersion?: string;
        /**
         * `CfnComponentVersion.LambdaFunctionRecipeSourceProperty.LambdaArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdafunctionrecipesource.html#cfn-greengrassv2-componentversion-lambdafunctionrecipesource-lambdaarn
         * @external
         */
        readonly lambdaArn?: string;
    }
}
/**
 * A CloudFormation `AWS::GreengrassV2::ComponentVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html
 * @external
 * @cloudformationResource AWS::GreengrassV2::ComponentVersion
 */
export declare namespace CfnComponentVersion {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdalinuxprocessparams.html
     * @external
     */
    interface LambdaLinuxProcessParamsProperty {
        /**
         * `CfnComponentVersion.LambdaLinuxProcessParamsProperty.ContainerParams`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdalinuxprocessparams.html#cfn-greengrassv2-componentversion-lambdalinuxprocessparams-containerparams
         * @external
         */
        readonly containerParams?: CfnComponentVersion.LambdaContainerParamsProperty | cdk.IResolvable;
        /**
         * `CfnComponentVersion.LambdaLinuxProcessParamsProperty.IsolationMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdalinuxprocessparams.html#cfn-greengrassv2-componentversion-lambdalinuxprocessparams-isolationmode
         * @external
         */
        readonly isolationMode?: string;
    }
}
/**
 * A CloudFormation `AWS::GreengrassV2::ComponentVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html
 * @external
 * @cloudformationResource AWS::GreengrassV2::ComponentVersion
 */
export declare namespace CfnComponentVersion {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdavolumemount.html
     * @external
     */
    interface LambdaVolumeMountProperty {
        /**
         * `CfnComponentVersion.LambdaVolumeMountProperty.AddGroupOwner`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdavolumemount.html#cfn-greengrassv2-componentversion-lambdavolumemount-addgroupowner
         * @external
         */
        readonly addGroupOwner?: boolean | cdk.IResolvable;
        /**
         * `CfnComponentVersion.LambdaVolumeMountProperty.DestinationPath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdavolumemount.html#cfn-greengrassv2-componentversion-lambdavolumemount-destinationpath
         * @external
         */
        readonly destinationPath?: string;
        /**
         * `CfnComponentVersion.LambdaVolumeMountProperty.Permission`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdavolumemount.html#cfn-greengrassv2-componentversion-lambdavolumemount-permission
         * @external
         */
        readonly permission?: string;
        /**
         * `CfnComponentVersion.LambdaVolumeMountProperty.SourcePath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdavolumemount.html#cfn-greengrassv2-componentversion-lambdavolumemount-sourcepath
         * @external
         */
        readonly sourcePath?: string;
    }
}
