# coding: utf-8

"""
    ARLAS Subscriptions Manager API

    Manage ARLAS subscriptions on ARLAS collections' events.

    OpenAPI spec version: 12.0.0
    Contact: contact@gisaia.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class AdminApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete(self, id, **kwargs):
        """
        Delete a subscription
        Mark a subscription as deleted.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: Subscription ID to delete (required)
        :param bool pretty: Pretty print
        :return: UserSubscriptionWithLinks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_with_http_info(id, **kwargs)
        else:
            (data) = self.delete_with_http_info(id, **kwargs)
            return data

    def delete_with_http_info(self, id, **kwargs):
        """
        Delete a subscription
        Mark a subscription as deleted.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_with_http_info(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: Subscription ID to delete (required)
        :param bool pretty: Pretty print
        :return: UserSubscriptionWithLinks
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/admin/subscriptions/{id}', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='UserSubscriptionWithLinks',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get(self, id, **kwargs):
        """
        Find subscription by ID
        Return a single subscription. Only creator can access their subscriptions.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID of subscription to return (required)
        :param bool deleted: Filter subscriptions whether they are deleted or not.
        :param bool pretty: Pretty print
        :return: UserSubscriptionWithLinks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_with_http_info(id, **kwargs)
        else:
            (data) = self.get_with_http_info(id, **kwargs)
            return data

    def get_with_http_info(self, id, **kwargs):
        """
        Find subscription by ID
        Return a single subscription. Only creator can access their subscriptions.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_with_http_info(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID of subscription to return (required)
        :param bool deleted: Filter subscriptions whether they are deleted or not.
        :param bool pretty: Pretty print
        :return: UserSubscriptionWithLinks
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'deleted', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []
        if 'deleted' in params:
            query_params.append(('deleted', params['deleted']))
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/admin/subscriptions/{id}', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='UserSubscriptionWithLinks',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_all(self, **kwargs):
        """
        List all available subscriptions
        Return the list of all registered subscriptions from the latest created to the earliest.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_all(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int before: Retrieve subscriptions created before given timestamp.
        :param int after: Retrieve subscriptions created after given timestamp.
        :param bool active: Filter subscriptions whether they are active or not (returns all if missing, 'active' if 'true', 'not active' if 'false').
        :param bool started: Filter subscriptions whether they are started or not (returns all if missing, 'started' if 'true', 'not started' if 'false').
        :param bool expired: Filter subscriptions whether they are expired or not (returns all if missing, 'expired' if 'true', 'not expired' if 'false').
        :param str created_by: Filter subscriptions by creator's identifier
        :param bool deleted: Filter subscriptions whether they are deleted or not.
        :param bool created_by_admin: Filter subscriptions whether they have been created by admin or not (returns all if missing, 'created_by_admin' if 'true', 'not created_by_admin' if 'false').
        :param bool pretty: Pretty print
        :param int page: Page ID
        :param int size: Page Size
        :return: SubscriptionListResource
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_all_with_http_info(**kwargs)
        else:
            (data) = self.get_all_with_http_info(**kwargs)
            return data

    def get_all_with_http_info(self, **kwargs):
        """
        List all available subscriptions
        Return the list of all registered subscriptions from the latest created to the earliest.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_all_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int before: Retrieve subscriptions created before given timestamp.
        :param int after: Retrieve subscriptions created after given timestamp.
        :param bool active: Filter subscriptions whether they are active or not (returns all if missing, 'active' if 'true', 'not active' if 'false').
        :param bool started: Filter subscriptions whether they are started or not (returns all if missing, 'started' if 'true', 'not started' if 'false').
        :param bool expired: Filter subscriptions whether they are expired or not (returns all if missing, 'expired' if 'true', 'not expired' if 'false').
        :param str created_by: Filter subscriptions by creator's identifier
        :param bool deleted: Filter subscriptions whether they are deleted or not.
        :param bool created_by_admin: Filter subscriptions whether they have been created by admin or not (returns all if missing, 'created_by_admin' if 'true', 'not created_by_admin' if 'false').
        :param bool pretty: Pretty print
        :param int page: Page ID
        :param int size: Page Size
        :return: SubscriptionListResource
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['before', 'after', 'active', 'started', 'expired', 'created_by', 'deleted', 'created_by_admin', 'pretty', 'page', 'size']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all" % key
                )
            params[key] = val
        del params['kwargs']

        if 'page' in params and params['page'] < 1:
            raise ValueError("Invalid value for parameter `page` when calling `get_all`, must be a value greater than or equal to `1`")
        if 'size' in params and params['size'] < 1:
            raise ValueError("Invalid value for parameter `size` when calling `get_all`, must be a value greater than or equal to `1`")

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'before' in params:
            query_params.append(('before', params['before']))
        if 'after' in params:
            query_params.append(('after', params['after']))
        if 'active' in params:
            query_params.append(('active', params['active']))
        if 'started' in params:
            query_params.append(('started', params['started']))
        if 'expired' in params:
            query_params.append(('expired', params['expired']))
        if 'created_by' in params:
            query_params.append(('created-by', params['created_by']))
        if 'deleted' in params:
            query_params.append(('deleted', params['deleted']))
        if 'created_by_admin' in params:
            query_params.append(('created-by-admin', params['created_by_admin']))
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))
        if 'page' in params:
            query_params.append(('page', params['page']))
        if 'size' in params:
            query_params.append(('size', params['size']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/admin/subscriptions', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='SubscriptionListResource',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def post(self, subscription, **kwargs):
        """
        Register a new subscription
        Register a subscription for further notification.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post(subscription, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param UserSubscription subscription: Subscription description (required)
        :param bool pretty: Pretty print
        :return: UserSubscriptionWithLinks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.post_with_http_info(subscription, **kwargs)
        else:
            (data) = self.post_with_http_info(subscription, **kwargs)
            return data

    def post_with_http_info(self, subscription, **kwargs):
        """
        Register a new subscription
        Register a subscription for further notification.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_with_http_info(subscription, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param UserSubscription subscription: Subscription description (required)
        :param bool pretty: Pretty print
        :return: UserSubscriptionWithLinks
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['subscription', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'subscription' is set
        if ('subscription' not in params) or (params['subscription'] is None):
            raise ValueError("Missing the required parameter `subscription` when calling `post`")


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'subscription' in params:
            body_params = params['subscription']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/admin/subscriptions', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='UserSubscriptionWithLinks',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def put(self, id, subscription, **kwargs):
        """
        Update an existing subscription
        Update an existing subscription. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put(id, subscription, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID of subscription to return (required)
        :param UserSubscription subscription: Subscription description (required)
        :param bool pretty: Pretty print
        :return: UserSubscriptionWithLinks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.put_with_http_info(id, subscription, **kwargs)
        else:
            (data) = self.put_with_http_info(id, subscription, **kwargs)
            return data

    def put_with_http_info(self, id, subscription, **kwargs):
        """
        Update an existing subscription
        Update an existing subscription. 
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_with_http_info(id, subscription, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: ID of subscription to return (required)
        :param UserSubscription subscription: Subscription description (required)
        :param bool pretty: Pretty print
        :return: UserSubscriptionWithLinks
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'subscription', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `put`")
        # verify the required parameter 'subscription' is set
        if ('subscription' not in params) or (params['subscription'] is None):
            raise ValueError("Missing the required parameter `subscription` when calling `put`")


        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = []
        if 'pretty' in params:
            query_params.append(('pretty', params['pretty']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'subscription' in params:
            body_params = params['subscription']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json;charset=utf-8'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json;charset=utf-8'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api('/admin/subscriptions/{id}', 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='UserSubscriptionWithLinks',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
