"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const kms = require("@aws-cdk/aws-kms");
const s3 = require("@aws-cdk/aws-s3");
// Setup
const app = new core_1.App();
const stack = new core_1.Stack(app, 'test-s3-sqs-deploy-queue');
stack.templateOptions.description = 'Integration Test for aws-s3-sqs with standard Queue';
// For S3 to SQS bucket notification a customer managed CMK must be used:
const encryptionKeyProps = {
    enableKeyRotation: true
};
const kmsKey = new kms.Key(stack, 'ImportedEncryptionKey', encryptionKeyProps);
// Configure notification filter
const filter = {
    prefix: 'the/place',
    suffix: '*.mp3'
};
// Define construct properties so that a new queue myQueue is created
const props = {
    queueProps: {
        queueName: `myQueue`,
        encryptionMasterKey: kmsKey
    },
    deadLetterQueueProps: {
        queueName: `myDLQueue`
    },
    s3EventTypes: [s3.EventType.OBJECT_REMOVED],
    s3EventFilters: [filter],
    bucketProps: {
        removalPolicy: core_1.RemovalPolicy.DESTROY,
    }
};
new lib_1.S3ToSqs(stack, 'test-s3-sqs', props);
// Synth
app.synth();
//# sourceMappingURL=data:application/json;base64,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