"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Type = exports.Directive = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const graphqlapi_1 = require("./graphqlapi");
/**
 * (experimental) Directives for types.
 *
 * i.e. @aws_iam or @aws_subscribe
 *
 * @experimental
 */
class Directive {
    constructor(statement, options) {
        this.statement = statement;
        this.mode = options === null || options === void 0 ? void 0 : options.mode;
        this.mutationFields = options === null || options === void 0 ? void 0 : options.mutationFields;
    }
    /**
     * (experimental) Add the @aws_iam directive.
     *
     * @experimental
     */
    static iam() {
        return new Directive('@aws_iam', { mode: graphqlapi_1.AuthorizationType.IAM });
    }
    /**
     * (experimental) Add the @aws_oidc directive.
     *
     * @experimental
     */
    static oidc() {
        return new Directive('@aws_oidc', { mode: graphqlapi_1.AuthorizationType.OIDC });
    }
    /**
     * (experimental) Add the @aws_api_key directive.
     *
     * @experimental
     */
    static apiKey() {
        return new Directive('@aws_api_key', { mode: graphqlapi_1.AuthorizationType.API_KEY });
    }
    /**
     * (experimental) Add the @aws_auth or @aws_cognito_user_pools directive.
     *
     * @param groups the groups to allow access to.
     * @experimental
     */
    static cognito(...groups) {
        if (groups.length === 0) {
            throw new Error(`Cognito authorization requires at least one Cognito group to be supplied. Received: ${groups.length}`);
        }
        // this function creates the cognito groups as a string (i.e. ["group1", "group2", "group3"])
        const stringify = (array) => {
            return array.reduce((acc, element) => `${acc}"${element}", `, '').slice(0, -2);
        };
        return new Directive(`@aws_auth(cognito_groups: [${stringify(groups)}])`, { mode: graphqlapi_1.AuthorizationType.USER_POOL });
    }
    /**
     * (experimental) Add the @aws_subscribe directive.
     *
     * Only use for top level Subscription type.
     *
     * @param mutations the mutation fields to link to.
     * @experimental
     */
    static subscribe(...mutations) {
        if (mutations.length === 0) {
            throw new Error(`Subscribe directive requires at least one mutation field to be supplied. Received: ${mutations.length}`);
        }
        // this function creates the subscribe directive as a string (i.e. ["mutation_field_1", "mutation_field_2"])
        const stringify = (array) => {
            return array.reduce((acc, mutation) => `${acc}"${mutation}", `, '').slice(0, -2);
        };
        return new Directive(`@aws_subscribe(mutations: [${stringify(mutations)}])`, { mutationFields: mutations });
    }
    /**
     * (experimental) Add a custom directive.
     *
     * @param statement - the directive statement to append.
     * @experimental
     */
    static custom(statement) {
        return new Directive(statement);
    }
    /**
     * Method called when the stringifying Directive for schema generation
     *
     * @param modes the authorization modes
     *
     * @internal
     */
    _bindToAuthModes(modes) {
        this.modes = modes;
        return this;
    }
    /**
     * (experimental) Generate the directive statement.
     *
     * @experimental
     */
    toString() {
        if (this.modes && this.mode && !this.modes.some((mode) => mode === this.mode)) {
            throw new Error(`No Authorization Type ${this.mode} declared in GraphQL Api.`);
        }
        if (this.mode === graphqlapi_1.AuthorizationType.USER_POOL && this.modes && this.modes.length > 1) {
            this.statement = this.statement.replace('@aws_auth', '@aws_cognito_user_pools');
        }
        return this.statement;
    }
}
exports.Directive = Directive;
_a = JSII_RTTI_SYMBOL_1;
Directive[_a] = { fqn: "@aws-cdk/aws-appsync-alpha.Directive", version: "2.5.0-alpha.0" };
/**
 * (experimental) Enum containing the Types that can be used to define ObjectTypes.
 *
 * @experimental
 */
var Type;
(function (Type) {
    Type["ID"] = "ID";
    Type["STRING"] = "String";
    Type["INT"] = "Int";
    Type["FLOAT"] = "Float";
    Type["BOOLEAN"] = "Boolean";
    Type["AWS_DATE"] = "AWSDate";
    Type["AWS_TIME"] = "AWSTime";
    Type["AWS_DATE_TIME"] = "AWSDateTime";
    Type["AWS_TIMESTAMP"] = "AWSTimestamp";
    Type["AWS_EMAIL"] = "AWSEmail";
    Type["AWS_JSON"] = "AWSJSON";
    Type["AWS_URL"] = "AWSURL";
    Type["AWS_PHONE"] = "AWSPhone";
    Type["AWS_IP_ADDRESS"] = "AWSIPAddress";
    Type["INTERMEDIATE"] = "INTERMEDIATE";
})(Type = exports.Type || (exports.Type = {}));
//# sourceMappingURL=data:application/json;base64,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