import { IUserPool } from 'aws-cdk-lib/aws-cognito';
import { IRole, Grant, IGrantable } from 'aws-cdk-lib/aws-iam';
import { IFunction } from 'aws-cdk-lib/aws-lambda';
import { CfnResource, Duration, Expiration, IResolvable } from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { IGraphqlApi, GraphqlApiBase } from './graphqlapi-base';
import { Schema } from './schema';
import { IIntermediateType } from './schema-base';
import { ResolvableField } from './schema-field';
import { ObjectType } from './schema-intermediate';
/**
 * (experimental) enum with all possible values for AppSync authorization type.
 *
 * @experimental
 */
export declare enum AuthorizationType {
    /**
     * (experimental) API Key authorization type.
     *
     * @experimental
     */
    API_KEY = "API_KEY",
    /**
     * (experimental) AWS IAM authorization type.
     *
     * Can be used with Cognito Identity Pool federated credentials
     *
     * @experimental
     */
    IAM = "AWS_IAM",
    /**
     * (experimental) Cognito User Pool authorization type.
     *
     * @experimental
     */
    USER_POOL = "AMAZON_COGNITO_USER_POOLS",
    /**
     * (experimental) OpenID Connect authorization type.
     *
     * @experimental
     */
    OIDC = "OPENID_CONNECT",
    /**
     * (experimental) Lambda authorization type.
     *
     * @experimental
     */
    LAMBDA = "AWS_LAMBDA"
}
/**
 * (experimental) Interface to specify default or additional authorization(s).
 *
 * @experimental
 */
export interface AuthorizationMode {
    /**
     * (experimental) One of possible four values AppSync supports.
     *
     * @default - `AuthorizationType.API_KEY`
     * @see https://docs.aws.amazon.com/appsync/latest/devguide/security.html
     * @experimental
     */
    readonly authorizationType: AuthorizationType;
    /**
     * (experimental) If authorizationType is `AuthorizationType.USER_POOL`, this option is required.
     *
     * @default - none
     * @experimental
     */
    readonly userPoolConfig?: UserPoolConfig;
    /**
     * (experimental) If authorizationType is `AuthorizationType.API_KEY`, this option can be configured.
     *
     * @default - name: 'DefaultAPIKey' | description: 'Default API Key created by CDK'
     * @experimental
     */
    readonly apiKeyConfig?: ApiKeyConfig;
    /**
     * (experimental) If authorizationType is `AuthorizationType.OIDC`, this option is required.
     *
     * @default - none
     * @experimental
     */
    readonly openIdConnectConfig?: OpenIdConnectConfig;
    /**
     * (experimental) If authorizationType is `AuthorizationType.LAMBDA`, this option is required.
     *
     * @default - none
     * @experimental
     */
    readonly lambdaAuthorizerConfig?: LambdaAuthorizerConfig;
}
/**
 * (experimental) enum with all possible values for Cognito user-pool default actions.
 *
 * @experimental
 */
export declare enum UserPoolDefaultAction {
    /**
     * (experimental) ALLOW access to API.
     *
     * @experimental
     */
    ALLOW = "ALLOW",
    /**
     * (experimental) DENY access to API.
     *
     * @experimental
     */
    DENY = "DENY"
}
/**
 * (experimental) Configuration for Cognito user-pools in AppSync.
 *
 * @experimental
 */
export interface UserPoolConfig {
    /**
     * (experimental) The Cognito user pool to use as identity source.
     *
     * @experimental
     */
    readonly userPool: IUserPool;
    /**
     * (experimental) the optional app id regex.
     *
     * @default -  None
     * @experimental
     */
    readonly appIdClientRegex?: string;
    /**
     * (experimental) Default auth action.
     *
     * @default ALLOW
     * @experimental
     */
    readonly defaultAction?: UserPoolDefaultAction;
}
/**
 * (experimental) Configuration for API Key authorization in AppSync.
 *
 * @experimental
 */
export interface ApiKeyConfig {
    /**
     * (experimental) Unique name of the API Key.
     *
     * @default - 'DefaultAPIKey'
     * @experimental
     */
    readonly name?: string;
    /**
     * (experimental) Description of API key.
     *
     * @default - 'Default API Key created by CDK'
     * @experimental
     */
    readonly description?: string;
    /**
     * (experimental) The time from creation time after which the API key expires.
     *
     * It must be a minimum of 1 day and a maximum of 365 days from date of creation.
     * Rounded down to the nearest hour.
     *
     * @default - 7 days rounded down to nearest hour
     * @experimental
     */
    readonly expires?: Expiration;
}
/**
 * (experimental) Configuration for OpenID Connect authorization in AppSync.
 *
 * @experimental
 */
export interface OpenIdConnectConfig {
    /**
     * (experimental) The number of milliseconds an OIDC token is valid after being authenticated by OIDC provider.
     *
     * `auth_time` claim in OIDC token is required for this validation to work.
     *
     * @default - no validation
     * @experimental
     */
    readonly tokenExpiryFromAuth?: number;
    /**
     * (experimental) The number of milliseconds an OIDC token is valid after being issued to a user.
     *
     * This validation uses `iat` claim of OIDC token.
     *
     * @default - no validation
     * @experimental
     */
    readonly tokenExpiryFromIssue?: number;
    /**
     * (experimental) The client identifier of the Relying party at the OpenID identity provider.
     *
     * A regular expression can be specified so AppSync can validate against multiple client identifiers at a time.
     *
     * @default - * (All)
     * @experimental
     * @example
     *
     * - 'ABCD|CDEF' // where ABCD and CDEF are two different clientId
     */
    readonly clientId?: string;
    /**
     * (experimental) The issuer for the OIDC configuration.
     *
     * The issuer returned by discovery must exactly match the value of `iss` in the OIDC token.
     *
     * @experimental
     */
    readonly oidcProvider: string;
}
/**
 * (experimental) Configuration for Lambda authorization in AppSync.
 *
 * Note that you can only have a single AWS Lambda function configured to authorize your API.
 *
 * @experimental
 */
export interface LambdaAuthorizerConfig {
    /**
     * (experimental) The authorizer lambda function.
     *
     * Note: This Lambda function must have the following resource-based policy assigned to it.
     * When configuring Lambda authorizers in the console, this is done for you.
     * To do so with the AWS CLI, run the following:
     *
     * `aws lambda add-permission --function-name "arn:aws:lambda:us-east-2:111122223333:function:my-function" --statement-id "appsync" --principal appsync.amazonaws.com --action lambda:InvokeFunction`
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appsync-graphqlapi-lambdaauthorizerconfig.html
     * @experimental
     */
    readonly handler: IFunction;
    /**
     * (experimental) How long the results are cached.
     *
     * Disable caching by setting this to 0.
     *
     * @default Duration.minutes(5)
     * @experimental
     */
    readonly resultsCacheTtl?: Duration;
    /**
     * (experimental) A regular expression for validation of tokens before the Lambda function is called.
     *
     * @default - no regex filter will be applied.
     * @experimental
     */
    readonly validationRegex?: string;
}
/**
 * (experimental) Configuration of the API authorization modes.
 *
 * @experimental
 */
export interface AuthorizationConfig {
    /**
     * (experimental) Optional authorization configuration.
     *
     * @default - API Key authorization
     * @experimental
     */
    readonly defaultAuthorization?: AuthorizationMode;
    /**
     * (experimental) Additional authorization modes.
     *
     * @default - No other modes
     * @experimental
     */
    readonly additionalAuthorizationModes?: AuthorizationMode[];
}
/**
 * (experimental) log-level for fields in AppSync.
 *
 * @experimental
 */
export declare enum FieldLogLevel {
    /**
     * (experimental) No logging.
     *
     * @experimental
     */
    NONE = "NONE",
    /**
     * (experimental) Error logging.
     *
     * @experimental
     */
    ERROR = "ERROR",
    /**
     * (experimental) All logging.
     *
     * @experimental
     */
    ALL = "ALL"
}
/**
 * (experimental) Logging configuration for AppSync.
 *
 * @experimental
 */
export interface LogConfig {
    /**
     * (experimental) exclude verbose content.
     *
     * @default false
     * @experimental
     */
    readonly excludeVerboseContent?: boolean | IResolvable;
    /**
     * (experimental) log level for fields.
     *
     * @default - Use AppSync default
     * @experimental
     */
    readonly fieldLogLevel?: FieldLogLevel;
    /**
     * (experimental) The role for CloudWatch Logs.
     *
     * @default - None
     * @experimental
     */
    readonly role?: IRole;
}
/**
 * (experimental) Properties for an AppSync GraphQL API.
 *
 * @experimental
 */
export interface GraphqlApiProps {
    /**
     * (experimental) the name of the GraphQL API.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) Optional authorization configuration.
     *
     * @default - API Key authorization
     * @experimental
     */
    readonly authorizationConfig?: AuthorizationConfig;
    /**
     * (experimental) Logging configuration for this api.
     *
     * @default - None
     * @experimental
     */
    readonly logConfig?: LogConfig;
    /**
     * (experimental) GraphQL schema definition. Specify how you want to define your schema.
     *
     * Schema.fromFile(filePath: string) allows schema definition through schema.graphql file
     *
     * @default - schema will be generated code-first (i.e. addType, addObjectType, etc.)
     * @experimental
     */
    readonly schema?: Schema;
    /**
     * (experimental) A flag indicating whether or not X-Ray tracing is enabled for the GraphQL API.
     *
     * @default - false
     * @experimental
     */
    readonly xrayEnabled?: boolean;
}
/**
 * (experimental) A class used to generate resource arns for AppSync.
 *
 * @experimental
 */
export declare class IamResource {
    /**
     * (experimental) Generate the resource names given custom arns.
     *
     * @param arns The custom arns that need to be permissioned.
     * @experimental
     */
    static custom(...arns: string[]): IamResource;
    /**
     * (experimental) Generate the resource names given a type and fields.
     *
     * @param type The type that needs to be allowed.
     * @param fields The fields that need to be allowed, if empty grant permissions to ALL fields.
     * @experimental
     */
    static ofType(type: string, ...fields: string[]): IamResource;
    /**
     * (experimental) Generate the resource names that accepts all types: `*`.
     *
     * @experimental
     */
    static all(): IamResource;
    private arns;
    private constructor();
    /**
     * (experimental) Return the Resource ARN.
     *
     * @param api The GraphQL API to give permissions.
     * @experimental
     */
    resourceArns(api: GraphqlApi): string[];
}
/**
 * (experimental) Attributes for GraphQL imports.
 *
 * @experimental
 */
export interface GraphqlApiAttributes {
    /**
     * (experimental) an unique AWS AppSync GraphQL API identifier i.e. 'lxz775lwdrgcndgz3nurvac7oa'.
     *
     * @experimental
     */
    readonly graphqlApiId: string;
    /**
     * (experimental) the arn for the GraphQL Api.
     *
     * @default - autogenerated arn
     * @experimental
     */
    readonly graphqlApiArn?: string;
}
/**
 * (experimental) An AppSync GraphQL API.
 *
 * @experimental
 * @resource AWS::AppSync::GraphQLApi
 */
export declare class GraphqlApi extends GraphqlApiBase {
    /**
     * (experimental) Import a GraphQL API through this function.
     *
     * @param scope scope.
     * @param id id.
     * @param attrs GraphQL API Attributes of an API.
     * @experimental
     */
    static fromGraphqlApiAttributes(scope: Construct, id: string, attrs: GraphqlApiAttributes): IGraphqlApi;
    /**
     * (experimental) an unique AWS AppSync GraphQL API identifier i.e. 'lxz775lwdrgcndgz3nurvac7oa'.
     *
     * @experimental
     */
    readonly apiId: string;
    /**
     * (experimental) the ARN of the API.
     *
     * @experimental
     */
    readonly arn: string;
    /**
     * (experimental) the URL of the endpoint created by AppSync.
     *
     * @experimental
     * @attribute GraphQlUrl
     */
    readonly graphqlUrl: string;
    /**
     * (experimental) the name of the API.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) the schema attached to this api.
     *
     * @experimental
     */
    readonly schema: Schema;
    /**
     * (experimental) The Authorization Types for this GraphQL Api.
     *
     * @experimental
     */
    readonly modes: AuthorizationType[];
    /**
     * (experimental) the configured API key, if present.
     *
     * @default - no api key
     * @experimental
     */
    readonly apiKey?: string;
    private schemaResource;
    private api;
    private apiKeyResource?;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: GraphqlApiProps);
    /**
     * (experimental) Adds an IAM policy statement associated with this GraphQLApi to an IAM principal's policy.
     *
     * @param grantee The principal.
     * @param resources The set of resources to allow (i.e. ...:[region]:[accountId]:apis/GraphQLId/...).
     * @param actions The actions that should be granted to the principal (i.e. appsync:graphql ).
     * @experimental
     */
    grant(grantee: IGrantable, resources: IamResource, ...actions: string[]): Grant;
    /**
     * (experimental) Adds an IAM policy statement for Mutation access to this GraphQLApi to an IAM principal's policy.
     *
     * @param grantee The principal.
     * @param fields The fields to grant access to that are Mutations (leave blank for all).
     * @experimental
     */
    grantMutation(grantee: IGrantable, ...fields: string[]): Grant;
    /**
     * (experimental) Adds an IAM policy statement for Query access to this GraphQLApi to an IAM principal's policy.
     *
     * @param grantee The principal.
     * @param fields The fields to grant access to that are Queries (leave blank for all).
     * @experimental
     */
    grantQuery(grantee: IGrantable, ...fields: string[]): Grant;
    /**
     * (experimental) Adds an IAM policy statement for Subscription access to this GraphQLApi to an IAM principal's policy.
     *
     * @param grantee The principal.
     * @param fields The fields to grant access to that are Subscriptions (leave blank for all).
     * @experimental
     */
    grantSubscription(grantee: IGrantable, ...fields: string[]): Grant;
    private validateAuthorizationProps;
    /**
     * (experimental) Add schema dependency to a given construct.
     *
     * @param construct the dependee.
     * @experimental
     */
    addSchemaDependency(construct: CfnResource): boolean;
    private setupLogConfig;
    private setupOpenIdConnectConfig;
    private setupUserPoolConfig;
    private setupLambdaAuthorizerConfig;
    private setupAdditionalAuthorizationModes;
    private createAPIKey;
    /**
     * (experimental) Escape hatch to append to Schema as desired.
     *
     * Will always result
     * in a newline.
     *
     * @param addition the addition to add to schema.
     * @param delimiter the delimiter between schema and addition.
     * @default - ''
     * @experimental
     */
    addToSchema(addition: string, delimiter?: string): void;
    /**
     * (experimental) Add type to the schema.
     *
     * @param type the intermediate type to add to the schema.
     * @experimental
     */
    addType(type: IIntermediateType): IIntermediateType;
    /**
     * (experimental) Add a query field to the schema's Query. CDK will create an Object Type called 'Query'. For example,.
     *
     * type Query {
     *    fieldName: Field.returnType
     * }
     *
     * @param fieldName the name of the query.
     * @param field the resolvable field to for this query.
     * @experimental
     */
    addQuery(fieldName: string, field: ResolvableField): ObjectType;
    /**
     * (experimental) Add a mutation field to the schema's Mutation. CDK will create an Object Type called 'Mutation'. For example,.
     *
     * type Mutation {
     *    fieldName: Field.returnType
     * }
     *
     * @param fieldName the name of the Mutation.
     * @param field the resolvable field to for this Mutation.
     * @experimental
     */
    addMutation(fieldName: string, field: ResolvableField): ObjectType;
    /**
     * (experimental) Add a subscription field to the schema's Subscription. CDK will create an Object Type called 'Subscription'. For example,.
     *
     * type Subscription {
     *    fieldName: Field.returnType
     * }
     *
     * @param fieldName the name of the Subscription.
     * @param field the resolvable field to for this Subscription.
     * @experimental
     */
    addSubscription(fieldName: string, field: ResolvableField): ObjectType;
}
