import { Duration } from 'aws-cdk-lib';
/**
 * (experimental) CachingConfig for AppSync resolvers.
 *
 * @experimental
 */
export interface CachingConfig {
    /**
     * (experimental) The caching keys for a resolver that has caching enabled.
     *
     * Valid values are entries from the $context.arguments, $context.source, and $context.identity maps.
     *
     * @default - No caching keys
     * @experimental
     */
    readonly cachingKeys?: string[];
    /**
     * (experimental) The TTL in seconds for a resolver that has caching enabled.
     *
     * Valid values are between 1 and 3600 seconds.
     *
     * @experimental
     */
    readonly ttl: Duration;
}
