"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PartnerProcessor = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const aws_s3_1 = require("aws-cdk-lib/aws-s3");
const constructs_1 = require("constructs");
const Util_1 = require("./Util");
/**
 * CDK wrapper for the GitHub Eventbridge processor.
 * @see https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-saas-furls.html#furls-connection-github
 */
class PartnerProcessor extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.partnerEventsFunction = new aws_lambda_1.Function(this, `${props.eventbridgePartner}EventsFunction`, {
            code: aws_lambda_1.Code.fromBucket(aws_s3_1.Bucket.fromBucketName(this, 'AWSFunctionBucket', `eventbridge-inbound-webhook-templates-prod-${aws_cdk_lib_1.Stack.of(this).region}`), `lambda-templates/${props.eventbridgePartner}-lambdasrc.zip`),
            handler: 'app.lambda_handler',
            runtime: aws_lambda_1.Runtime.PYTHON_3_7,
            memorySize: 128,
            timeout: aws_cdk_lib_1.Duration.seconds(100),
            reservedConcurrentExecutions: 10,
            environment: {
                GITHUB_WEBHOOK_SECRET_ARN: props.webhookSecret.secretArn,
                EVENT_BUS_NAME: props.eventBus.eventBusName,
            },
        });
        this.invocationAlarm = new Util_1.InvocationAlarm(this, `${props.eventbridgePartner}InvocationAlarm`, {
            threshold: props.lambdaInvocationAlarmThreshold,
            eventFunction: this.partnerEventsFunction,
        });
        const fURL = this.partnerEventsFunction.addFunctionUrl({ authType: aws_lambda_1.FunctionUrlAuthType.NONE });
        props.webhookSecret.grantRead(this.partnerEventsFunction);
        props.eventBus.grantPutEventsTo(this.partnerEventsFunction);
        new aws_cdk_lib_1.CfnOutput(this, `${props.eventbridgePartner}FunctionUrl`, { value: fURL.url });
    }
}
exports.PartnerProcessor = PartnerProcessor;
_a = JSII_RTTI_SYMBOL_1;
PartnerProcessor[_a] = { fqn: "cdk-eventbridge-partner-processors.PartnerProcessor", version: "0.0.14" };
//# sourceMappingURL=data:application/json;base64,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