# This file is autogenerated by `applaudgen` from `app_store_connect_api.json`.
# Do not modify this file -- YOUR CHANGES WILL BE ERASED!

from pydantic import BaseModel, AnyUrl, EmailStr, Field
from deprecated import deprecated
from .enums import *
from typing import Optional, Literal
import re
import datetime

def _camelcase(string):
    """ Convert string into camel case.

    Args:
        string: String to convert.

    Returns:
        string: Camel case string.

    """

    string = re.sub(r"^[\-_\.]", '', str(string))
    if not string:
        return string
    return (str(string[0]).lower()
            + re.sub(r"[\-_\.\s]([a-z])",
                    lambda matched: str(matched.group(1)).upper(),
                    string[1:]))

class ApplaudModel(BaseModel):
    class Config:
        alias_generator = _camelcase
        underscore_attrs_are_private = True
        allow_population_by_field_name = True

class ResourceLinks(ApplaudModel):
    self: str

class PagingInformation(ApplaudModel):
    class Paging(ApplaudModel):
        total: int
        limit: int

    paging: Paging

class HttpHeader(ApplaudModel):
    name: Optional[str]
    value: Optional[str]

class ImageAsset(ApplaudModel):
    template_url: Optional[str]
    width: Optional[int]
    height: Optional[int]

class AppMediaStateError(ApplaudModel):
    code: Optional[str]
    description: Optional[str]

class AppMediaAssetState(ApplaudModel):
    class State(StringEnum):
        AWAITING_UPLOAD = 'AWAITING_UPLOAD'
        UPLOAD_COMPLETE = 'UPLOAD_COMPLETE'
        COMPLETE = 'COMPLETE'
        FAILED = 'FAILED'

    errors: Optional[list[AppMediaStateError]]
    warnings: Optional[list[AppMediaStateError]]
    state: Optional[State]

class UploadOperation(ApplaudModel):
    method: Optional[str]
    url: Optional[str]
    length: Optional[int]
    offset: Optional[int]
    request_headers: Optional[list[HttpHeader]]

class Device(ApplaudModel):
    class Attributes(ApplaudModel):
        name: Optional[str]
        platform: Optional[BundleIdPlatform]
        udid: Optional[str]
        device_class: Optional[DeviceClass]
        status: Optional[DeviceStatus]
        model: Optional[str]
        added_date: Optional[datetime.datetime]

    links: ResourceLinks
    id: str
    type: Literal["devices"] = "devices"
    attributes: Optional[Attributes]

class FileLocation(ApplaudModel):
    path: Optional[str]
    line_number: Optional[int]

class ScmProviderType(ApplaudModel):
    class Kind(StringEnum):
        BITBUCKET_CLOUD = 'BITBUCKET_CLOUD'
        BITBUCKET_SERVER = 'BITBUCKET_SERVER'
        GITHUB_CLOUD = 'GITHUB_CLOUD'
        GITHUB_ENTERPRISE = 'GITHUB_ENTERPRISE'
        GITLAB_CLOUD = 'GITLAB_CLOUD'
        GITLAB_SELF_MANAGED = 'GITLAB_SELF_MANAGED'

    kind: Optional[Kind]
    display_name: Optional[str]
    is_on_premise: Optional[bool]

class CiTagPatterns(ApplaudModel):
    class Pattern(ApplaudModel):
        pattern: Optional[str]
        is_prefix: Optional[bool]

    is_all_match: Optional[bool]
    patterns: Optional[list[Pattern]]

class CiBranchPatterns(ApplaudModel):
    class Pattern(ApplaudModel):
        pattern: Optional[str]
        is_prefix: Optional[bool]

    is_all_match: Optional[bool]
    patterns: Optional[list[Pattern]]

class CiStartConditionFileMatcher(ApplaudModel):
    directory: Optional[str]
    file_extension: Optional[str]
    file_name: Optional[str]

class CiFilesAndFoldersRule(ApplaudModel):
    class Mode(StringEnum):
        START_IF_ANY_FILE_MATCHES = 'START_IF_ANY_FILE_MATCHES'
        DO_NOT_START_IF_ALL_FILES_MATCH = 'DO_NOT_START_IF_ALL_FILES_MATCH'

    mode: Optional[Mode]
    matchers: Optional[list[CiStartConditionFileMatcher]]

class CiTestDestination(ApplaudModel):
    device_type_name: Optional[str]
    device_type_identifier: Optional[str]
    runtime_name: Optional[str]
    runtime_identifier: Optional[str]
    kind: Optional[CiTestDestinationKind]

class CiAction(ApplaudModel):
    class TestConfiguration(ApplaudModel):
        class Kind(StringEnum):
            USE_SCHEME_SETTINGS = 'USE_SCHEME_SETTINGS'
            SPECIFIC_TEST_PLANS = 'SPECIFIC_TEST_PLANS'

        kind: Optional[Kind]
        test_plan_name: Optional[str]
        test_destinations: Optional[list[CiTestDestination]]

    class Destination(StringEnum):
        ANY_IOS_DEVICE = 'ANY_IOS_DEVICE'
        ANY_IOS_SIMULATOR = 'ANY_IOS_SIMULATOR'
        ANY_TVOS_DEVICE = 'ANY_TVOS_DEVICE'
        ANY_TVOS_SIMULATOR = 'ANY_TVOS_SIMULATOR'
        ANY_WATCHOS_DEVICE = 'ANY_WATCHOS_DEVICE'
        ANY_WATCHOS_SIMULATOR = 'ANY_WATCHOS_SIMULATOR'
        ANY_MAC = 'ANY_MAC'
        ANY_MAC_CATALYST = 'ANY_MAC_CATALYST'

    class Platform(StringEnum):
        MACOS = 'MACOS'
        IOS = 'IOS'
        TVOS = 'TVOS'
        WATCHOS = 'WATCHOS'

    name: Optional[str]
    action_type: Optional[CiActionType]
    destination: Optional[Destination]
    build_distribution_audience: Optional[BuildAudienceType]
    test_configuration: Optional[TestConfiguration]
    scheme: Optional[str]
    platform: Optional[Platform]
    is_required_to_pass: Optional[bool]

class CiGitUser(ApplaudModel):
    display_name: Optional[str]
    avatar_url: Optional[AnyUrl]

class CiIssueCounts(ApplaudModel):
    analyzer_warnings: Optional[int]
    errors: Optional[int]
    test_failures: Optional[int]
    warnings: Optional[int]

class CapabilityOption(ApplaudModel):
    class Key(StringEnum):
        XCODE_5 = 'XCODE_5'
        XCODE_6 = 'XCODE_6'
        COMPLETE_PROTECTION = 'COMPLETE_PROTECTION'
        PROTECTED_UNLESS_OPEN = 'PROTECTED_UNLESS_OPEN'
        PROTECTED_UNTIL_FIRST_USER_AUTH = 'PROTECTED_UNTIL_FIRST_USER_AUTH'
        PRIMARY_APP_CONSENT = 'PRIMARY_APP_CONSENT'

    key: Optional[Key]
    name: Optional[str]
    description: Optional[str]
    enabled_by_default: Optional[bool]
    enabled: Optional[bool]
    supports_wildcard: Optional[bool]

class CapabilitySetting(ApplaudModel):
    class Key(StringEnum):
        ICLOUD_VERSION = 'ICLOUD_VERSION'
        DATA_PROTECTION_PERMISSION_LEVEL = 'DATA_PROTECTION_PERMISSION_LEVEL'
        APPLE_ID_AUTH_APP_CONSENT = 'APPLE_ID_AUTH_APP_CONSENT'

    class AllowedInstances(StringEnum):
        ENTRY = 'ENTRY'
        SINGLE = 'SINGLE'
        MULTIPLE = 'MULTIPLE'

    key: Optional[Key]
    name: Optional[str]
    description: Optional[str]
    enabled_by_default: Optional[bool]
    visible: Optional[bool]
    allowed_instances: Optional[AllowedInstances]
    min_instances: Optional[int]
    options: Optional[list[CapabilityOption]]

class CiBranchStartCondition(ApplaudModel):
    source: Optional[CiBranchPatterns]
    files_and_folders_rule: Optional[CiFilesAndFoldersRule]
    auto_cancel: Optional[bool]

class CiTagStartCondition(ApplaudModel):
    source: Optional[CiTagPatterns]
    files_and_folders_rule: Optional[CiFilesAndFoldersRule]
    auto_cancel: Optional[bool]

class CiPullRequestStartCondition(ApplaudModel):
    source: Optional[CiBranchPatterns]
    destination: Optional[CiBranchPatterns]
    files_and_folders_rule: Optional[CiFilesAndFoldersRule]
    auto_cancel: Optional[bool]

class CiScheduledStartCondition(ApplaudModel):
    class Schedule(ApplaudModel):
        class Frequency(StringEnum):
            WEEKLY = 'WEEKLY'
            DAILY = 'DAILY'
            HOURLY = 'HOURLY'

        frequency: Optional[Frequency]
        days: Optional[list[str]]
        hour: Optional[int]
        minute: Optional[int]
        timezone: Optional[str]

    source: Optional[CiBranchPatterns]
    schedule: Optional[Schedule]

class AgeRatingDeclaration(ApplaudModel):
    class Attributes(ApplaudModel):
        alcohol_tobacco_or_drug_use_or_references: Optional[AgeRatingDeclarationLevel]
        contests: Optional[AgeRatingDeclarationLevel]
        gambling_and_contests: Optional[bool] = Field(None, deprecated=True)
        gambling: Optional[bool]
        gambling_simulated: Optional[AgeRatingDeclarationLevel]
        kids_age_band: Optional[KidsAgeBand]
        medical_or_treatment_information: Optional[AgeRatingDeclarationLevel]
        profanity_or_crude_humor: Optional[AgeRatingDeclarationLevel]
        sexual_content_graphic_and_nudity: Optional[AgeRatingDeclarationLevel]
        sexual_content_or_nudity: Optional[AgeRatingDeclarationLevel]
        seventeen_plus: Optional[bool]
        horror_or_fear_themes: Optional[AgeRatingDeclarationLevel]
        mature_or_suggestive_themes: Optional[AgeRatingDeclarationLevel]
        unrestricted_web_access: Optional[bool]
        violence_cartoon_or_fantasy: Optional[AgeRatingDeclarationLevel]
        violence_realistic_prolonged_graphic_or_sadistic: Optional[AgeRatingDeclarationLevel]
        violence_realistic: Optional[AgeRatingDeclarationLevel]

    links: ResourceLinks
    id: str
    type: Literal["ageRatingDeclarations"] = "ageRatingDeclarations"
    attributes: Optional[Attributes]

class AppCategory(ApplaudModel):
    class Attributes(ApplaudModel):
        platforms: Optional[list[Platform]]

    class Relationships(ApplaudModel):
        class Subcategories(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appCategories"] = "appCategories"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        class Parent(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appCategories"] = "appCategories"

            links: Optional[Links]
            data: Optional[Data]

        subcategories: Optional[Subcategories]
        parent: Optional[Parent]

    links: ResourceLinks
    id: str
    type: Literal["appCategories"] = "appCategories"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class AppClipAdvancedExperienceImage(ApplaudModel):
    class Attributes(ApplaudModel):
        file_size: Optional[int]
        file_name: Optional[str]
        source_file_checksum: Optional[str]
        image_asset: Optional[ImageAsset]
        upload_operations: Optional[list[UploadOperation]]
        asset_delivery_state: Optional[AppMediaAssetState]

    links: ResourceLinks
    id: str
    type: Literal["appClipAdvancedExperienceImages"] = "appClipAdvancedExperienceImages"
    attributes: Optional[Attributes]

class AppClipAdvancedExperienceLocalization(ApplaudModel):
    class Attributes(ApplaudModel):
        language: Optional[AppClipAdvancedExperienceLanguage]
        title: Optional[str]
        subtitle: Optional[str]

    links: ResourceLinks
    id: str
    type: Literal["appClipAdvancedExperienceLocalizations"] = "appClipAdvancedExperienceLocalizations"
    attributes: Optional[Attributes]

class AppClipAdvancedExperienceLocalizationInlineCreate(ApplaudModel):
    class Attributes(ApplaudModel):
        language: Optional[AppClipAdvancedExperienceLanguage]
        title: Optional[str]
        subtitle: Optional[str]

    type: Literal["appClipAdvancedExperienceLocalizations"] = "appClipAdvancedExperienceLocalizations"
    id: Optional[str]
    attributes: Optional[Attributes]

class AppClipAdvancedExperience(ApplaudModel):
    class Attributes(ApplaudModel):
        class Place(ApplaudModel):
            class MainAddress(ApplaudModel):
                class StructuredAddress(ApplaudModel):
                    street_address: Optional[list[str]]
                    floor: Optional[str]
                    neighborhood: Optional[str]
                    locality: Optional[str]
                    state_province: Optional[str]
                    postal_code: Optional[str]
                    country_code: Optional[str]

                full_address: Optional[str]
                structured_address: Optional[StructuredAddress]

            class DisplayPoint(ApplaudModel):
                class Coordinates(ApplaudModel):
                    latitude: Optional[float]
                    longitude: Optional[float]

                coordinates: Optional[Coordinates]
                source: Optional[AppClipAdvancedExperiencePlaceSource]

            class PhoneNumber(ApplaudModel):
                number: Optional[str]
                type: Optional[AppClipAdvancedExperiencePlacePhoneNumberType]
                intent: Optional[str]

            place_id: Optional[str]
            names: Optional[list[str]]
            main_address: Optional[MainAddress]
            display_point: Optional[DisplayPoint]
            map_action: Optional[AppClipAdvancedExperiencePlaceMapAction]
            relationship: Optional[AppClipAdvancedExperiencePlaceRelationship]
            phone_number: Optional[PhoneNumber]
            home_page: Optional[str]
            categories: Optional[list[str]]

        link: Optional[AnyUrl]
        version: Optional[int]
        status: Optional[AppClipAdvancedExperienceStatus]
        action: Optional[AppClipAction]
        is_powered_by: Optional[bool]
        place: Optional[Place]
        place_status: Optional[AppClipAdvancedExperiencePlaceStatus]
        business_category: Optional[AppClipAdvancedExperienceBusinessCategory]
        default_language: Optional[AppClipAdvancedExperienceLanguage]

    class Relationships(ApplaudModel):
        class AppClip(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appClips"] = "appClips"

            links: Optional[Links]
            data: Optional[Data]

        class HeaderImage(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appClipAdvancedExperienceImages"] = "appClipAdvancedExperienceImages"

            links: Optional[Links]
            data: Optional[Data]

        class Localizations(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appClipAdvancedExperienceLocalizations"] = "appClipAdvancedExperienceLocalizations"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        app_clip: Optional[AppClip]
        header_image: Optional[HeaderImage]
        localizations: Optional[Localizations]

    links: ResourceLinks
    id: str
    type: Literal["appClipAdvancedExperiences"] = "appClipAdvancedExperiences"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class AppClipAppStoreReviewDetail(ApplaudModel):
    class Attributes(ApplaudModel):
        invocation_urls: Optional[list[str]]

    class Relationships(ApplaudModel):
        class AppClipDefaultExperience(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appClipDefaultExperiences"] = "appClipDefaultExperiences"

            links: Optional[Links]
            data: Optional[Data]

        app_clip_default_experience: Optional[AppClipDefaultExperience]

    links: ResourceLinks
    id: str
    type: Literal["appClipAppStoreReviewDetails"] = "appClipAppStoreReviewDetails"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class AppClipDefaultExperienceLocalization(ApplaudModel):
    class Attributes(ApplaudModel):
        locale: Optional[str]
        subtitle: Optional[str]

    class Relationships(ApplaudModel):
        class AppClipDefaultExperience(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appClipDefaultExperiences"] = "appClipDefaultExperiences"

            links: Optional[Links]
            data: Optional[Data]

        class AppClipHeaderImage(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appClipHeaderImages"] = "appClipHeaderImages"

            links: Optional[Links]
            data: Optional[Data]

        app_clip_default_experience: Optional[AppClipDefaultExperience]
        app_clip_header_image: Optional[AppClipHeaderImage]

    links: ResourceLinks
    id: str
    type: Literal["appClipDefaultExperienceLocalizations"] = "appClipDefaultExperienceLocalizations"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class AppClipDefaultExperience(ApplaudModel):
    class Attributes(ApplaudModel):
        action: Optional[AppClipAction]

    class Relationships(ApplaudModel):
        class AppClip(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appClips"] = "appClips"

            links: Optional[Links]
            data: Optional[Data]

        class ReleaseWithAppStoreVersion(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appStoreVersions"] = "appStoreVersions"

            links: Optional[Links]
            data: Optional[Data]

        class AppClipDefaultExperienceLocalizations(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appClipDefaultExperienceLocalizations"] = "appClipDefaultExperienceLocalizations"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        class AppClipAppStoreReviewDetail(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appClipAppStoreReviewDetails"] = "appClipAppStoreReviewDetails"

            links: Optional[Links]
            data: Optional[Data]

        app_clip: Optional[AppClip]
        release_with_app_store_version: Optional[ReleaseWithAppStoreVersion]
        app_clip_default_experience_localizations: Optional[AppClipDefaultExperienceLocalizations]
        app_clip_app_store_review_detail: Optional[AppClipAppStoreReviewDetail]

    links: ResourceLinks
    id: str
    type: Literal["appClipDefaultExperiences"] = "appClipDefaultExperiences"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class AppClipDomainStatus(ApplaudModel):
    class Attributes(ApplaudModel):
        class Domain(ApplaudModel):
            domain: Optional[str]
            is_valid: Optional[bool]
            last_updated_date: Optional[datetime.datetime]
            error_code: Optional[AppClipDomainErrorCode]

        domains: Optional[list[Domain]]
        last_updated_date: Optional[datetime.datetime]

    links: ResourceLinks
    id: str
    type: Literal["appClipDomainStatuses"] = "appClipDomainStatuses"
    attributes: Optional[Attributes]

class AppClipHeaderImage(ApplaudModel):
    class Attributes(ApplaudModel):
        file_size: Optional[int]
        file_name: Optional[str]
        source_file_checksum: Optional[str]
        image_asset: Optional[ImageAsset]
        upload_operations: Optional[list[UploadOperation]]
        asset_delivery_state: Optional[AppMediaAssetState]

    class Relationships(ApplaudModel):
        class AppClipDefaultExperienceLocalization(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appClipDefaultExperienceLocalizations"] = "appClipDefaultExperienceLocalizations"

            links: Optional[Links]
            data: Optional[Data]

        app_clip_default_experience_localization: Optional[AppClipDefaultExperienceLocalization]

    links: ResourceLinks
    id: str
    type: Literal["appClipHeaderImages"] = "appClipHeaderImages"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class AppClip(ApplaudModel):
    class Attributes(ApplaudModel):
        bundle_id: Optional[str]

    class Relationships(ApplaudModel):
        class App(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["apps"] = "apps"

            links: Optional[Links]
            data: Optional[Data]

        class AppClipDefaultExperiences(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appClipDefaultExperiences"] = "appClipDefaultExperiences"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        app: Optional[App]
        app_clip_default_experiences: Optional[AppClipDefaultExperiences]

    links: ResourceLinks
    id: str
    type: Literal["appClips"] = "appClips"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class AppEncryptionDeclaration(ApplaudModel):
    class Attributes(ApplaudModel):
        uses_encryption: Optional[bool]
        exempt: Optional[bool]
        contains_proprietary_cryptography: Optional[bool]
        contains_third_party_cryptography: Optional[bool]
        available_on_french_store: Optional[bool]
        platform: Optional[Platform]
        uploaded_date: Optional[datetime.datetime]
        document_url: Optional[str]
        document_name: Optional[str]
        document_type: Optional[str]
        app_encryption_declaration_state: Optional[AppEncryptionDeclarationState]
        code_value: Optional[str]

    class Relationships(ApplaudModel):
        class App(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["apps"] = "apps"

            links: Optional[Links]
            data: Optional[Data]

        app: Optional[App]

    links: ResourceLinks
    id: str
    type: Literal["appEncryptionDeclarations"] = "appEncryptionDeclarations"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class AppInfoLocalization(ApplaudModel):
    class Attributes(ApplaudModel):
        locale: Optional[str]
        name: Optional[str]
        subtitle: Optional[str]
        privacy_policy_url: Optional[str]
        privacy_choices_url: Optional[str]
        privacy_policy_text: Optional[str]

    class Relationships(ApplaudModel):
        class AppInfo(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appInfos"] = "appInfos"

            links: Optional[Links]
            data: Optional[Data]

        app_info: Optional[AppInfo]

    links: ResourceLinks
    id: str
    type: Literal["appInfoLocalizations"] = "appInfoLocalizations"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class AppInfo(ApplaudModel):
    class Attributes(ApplaudModel):
        app_store_state: Optional[AppStoreVersionState]
        app_store_age_rating: Optional[AppStoreAgeRating]
        brazil_age_rating: Optional[BrazilAgeRating]
        kids_age_band: Optional[KidsAgeBand]

    class Relationships(ApplaudModel):
        class App(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["apps"] = "apps"

            links: Optional[Links]
            data: Optional[Data]

        class AgeRatingDeclaration(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["ageRatingDeclarations"] = "ageRatingDeclarations"

            links: Optional[Links]
            data: Optional[Data]

        class AppInfoLocalizations(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appInfoLocalizations"] = "appInfoLocalizations"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        class PrimaryCategory(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appCategories"] = "appCategories"

            links: Optional[Links]
            data: Optional[Data]

        class PrimarySubcategoryOne(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appCategories"] = "appCategories"

            links: Optional[Links]
            data: Optional[Data]

        class PrimarySubcategoryTwo(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appCategories"] = "appCategories"

            links: Optional[Links]
            data: Optional[Data]

        class SecondaryCategory(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appCategories"] = "appCategories"

            links: Optional[Links]
            data: Optional[Data]

        class SecondarySubcategoryOne(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appCategories"] = "appCategories"

            links: Optional[Links]
            data: Optional[Data]

        class SecondarySubcategoryTwo(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appCategories"] = "appCategories"

            links: Optional[Links]
            data: Optional[Data]

        app: Optional[App]
        age_rating_declaration: Optional[AgeRatingDeclaration]
        app_info_localizations: Optional[AppInfoLocalizations]
        primary_category: Optional[PrimaryCategory]
        primary_subcategory_one: Optional[PrimarySubcategoryOne]
        primary_subcategory_two: Optional[PrimarySubcategoryTwo]
        secondary_category: Optional[SecondaryCategory]
        secondary_subcategory_one: Optional[SecondarySubcategoryOne]
        secondary_subcategory_two: Optional[SecondarySubcategoryTwo]

    links: ResourceLinks
    id: str
    type: Literal["appInfos"] = "appInfos"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class AppPreOrder(ApplaudModel):
    class Attributes(ApplaudModel):
        pre_order_available_date: Optional[datetime.date]
        app_release_date: Optional[datetime.date]

    class Relationships(ApplaudModel):
        class App(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["apps"] = "apps"

            links: Optional[Links]
            data: Optional[Data]

        app: Optional[App]

    links: ResourceLinks
    id: str
    type: Literal["appPreOrders"] = "appPreOrders"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class AppPreviewSet(ApplaudModel):
    class Attributes(ApplaudModel):
        preview_type: Optional[PreviewType]

    class Relationships(ApplaudModel):
        class AppStoreVersionLocalization(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appStoreVersionLocalizations"] = "appStoreVersionLocalizations"

            links: Optional[Links]
            data: Optional[Data]

        class AppPreviews(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appPreviews"] = "appPreviews"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        app_store_version_localization: Optional[AppStoreVersionLocalization]
        app_previews: Optional[AppPreviews]

    links: ResourceLinks
    id: str
    type: Literal["appPreviewSets"] = "appPreviewSets"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class AppPreview(ApplaudModel):
    class Attributes(ApplaudModel):
        file_size: Optional[int]
        file_name: Optional[str]
        source_file_checksum: Optional[str]
        preview_frame_time_code: Optional[str]
        mime_type: Optional[str]
        video_url: Optional[str]
        preview_image: Optional[ImageAsset]
        upload_operations: Optional[list[UploadOperation]]
        asset_delivery_state: Optional[AppMediaAssetState]

    class Relationships(ApplaudModel):
        class AppPreviewSet(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appPreviewSets"] = "appPreviewSets"

            links: Optional[Links]
            data: Optional[Data]

        app_preview_set: Optional[AppPreviewSet]

    links: ResourceLinks
    id: str
    type: Literal["appPreviews"] = "appPreviews"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class AppPricePoint(ApplaudModel):
    class Attributes(ApplaudModel):
        customer_price: Optional[str]
        proceeds: Optional[str]

    class Relationships(ApplaudModel):
        class PriceTier(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appPriceTiers"] = "appPriceTiers"

            links: Optional[Links]
            data: Optional[Data]

        class Territory(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["territories"] = "territories"

            links: Optional[Links]
            data: Optional[Data]

        price_tier: Optional[PriceTier]
        territory: Optional[Territory]

    links: ResourceLinks
    id: str
    type: Literal["appPricePoints"] = "appPricePoints"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class AppPriceTier(ApplaudModel):
    class Relationships(ApplaudModel):
        class PricePoints(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appPricePoints"] = "appPricePoints"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        price_points: Optional[PricePoints]

    links: ResourceLinks
    id: str
    type: Literal["appPriceTiers"] = "appPriceTiers"
    relationships: Optional[Relationships]

class AppPrice(ApplaudModel):
    class Relationships(ApplaudModel):
        class App(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["apps"] = "apps"

            links: Optional[Links]
            data: Optional[Data]

        class PriceTier(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appPriceTiers"] = "appPriceTiers"

            links: Optional[Links]
            data: Optional[Data]

        app: Optional[App]
        price_tier: Optional[PriceTier]

    links: ResourceLinks
    id: str
    type: Literal["appPrices"] = "appPrices"
    relationships: Optional[Relationships]

class AppPriceInlineCreate(ApplaudModel):
    type: Literal["appPrices"] = "appPrices"
    id: Optional[str]

class AppScreenshotSet(ApplaudModel):
    class Attributes(ApplaudModel):
        screenshot_display_type: Optional[ScreenshotDisplayType]

    class Relationships(ApplaudModel):
        class AppStoreVersionLocalization(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appStoreVersionLocalizations"] = "appStoreVersionLocalizations"

            links: Optional[Links]
            data: Optional[Data]

        class AppScreenshots(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appScreenshots"] = "appScreenshots"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        app_store_version_localization: Optional[AppStoreVersionLocalization]
        app_screenshots: Optional[AppScreenshots]

    links: ResourceLinks
    id: str
    type: Literal["appScreenshotSets"] = "appScreenshotSets"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class AppScreenshot(ApplaudModel):
    class Attributes(ApplaudModel):
        file_size: Optional[int]
        file_name: Optional[str]
        source_file_checksum: Optional[str]
        image_asset: Optional[ImageAsset]
        asset_token: Optional[str]
        asset_type: Optional[str]
        upload_operations: Optional[list[UploadOperation]]
        asset_delivery_state: Optional[AppMediaAssetState]

    class Relationships(ApplaudModel):
        class AppScreenshotSet(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appScreenshotSets"] = "appScreenshotSets"

            links: Optional[Links]
            data: Optional[Data]

        app_screenshot_set: Optional[AppScreenshotSet]

    links: ResourceLinks
    id: str
    type: Literal["appScreenshots"] = "appScreenshots"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class AppStoreReviewAttachment(ApplaudModel):
    class Attributes(ApplaudModel):
        file_size: Optional[int]
        file_name: Optional[str]
        source_file_checksum: Optional[str]
        upload_operations: Optional[list[UploadOperation]]
        asset_delivery_state: Optional[AppMediaAssetState]

    class Relationships(ApplaudModel):
        class AppStoreReviewDetail(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appStoreReviewDetails"] = "appStoreReviewDetails"

            links: Optional[Links]
            data: Optional[Data]

        app_store_review_detail: Optional[AppStoreReviewDetail]

    links: ResourceLinks
    id: str
    type: Literal["appStoreReviewAttachments"] = "appStoreReviewAttachments"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class AppStoreReviewDetail(ApplaudModel):
    class Attributes(ApplaudModel):
        contact_first_name: Optional[str]
        contact_last_name: Optional[str]
        contact_phone: Optional[str]
        contact_email: Optional[str]
        demo_account_name: Optional[str]
        demo_account_password: Optional[str]
        demo_account_required: Optional[bool]
        notes: Optional[str]

    class Relationships(ApplaudModel):
        class AppStoreVersion(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appStoreVersions"] = "appStoreVersions"

            links: Optional[Links]
            data: Optional[Data]

        class AppStoreReviewAttachments(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appStoreReviewAttachments"] = "appStoreReviewAttachments"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        app_store_version: Optional[AppStoreVersion]
        app_store_review_attachments: Optional[AppStoreReviewAttachments]

    links: ResourceLinks
    id: str
    type: Literal["appStoreReviewDetails"] = "appStoreReviewDetails"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class AppStoreVersionLocalization(ApplaudModel):
    class Attributes(ApplaudModel):
        description: Optional[str]
        locale: Optional[str]
        keywords: Optional[str]
        marketing_url: Optional[AnyUrl]
        promotional_text: Optional[str]
        support_url: Optional[AnyUrl]
        whats_new: Optional[str]

    class Relationships(ApplaudModel):
        class AppStoreVersion(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appStoreVersions"] = "appStoreVersions"

            links: Optional[Links]
            data: Optional[Data]

        class AppScreenshotSets(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appScreenshotSets"] = "appScreenshotSets"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        class AppPreviewSets(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appPreviewSets"] = "appPreviewSets"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        app_store_version: Optional[AppStoreVersion]
        app_screenshot_sets: Optional[AppScreenshotSets]
        app_preview_sets: Optional[AppPreviewSets]

    links: ResourceLinks
    id: str
    type: Literal["appStoreVersionLocalizations"] = "appStoreVersionLocalizations"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class AppStoreVersionPhasedRelease(ApplaudModel):
    class Attributes(ApplaudModel):
        phased_release_state: Optional[PhasedReleaseState]
        start_date: Optional[datetime.datetime]
        total_pause_duration: Optional[int]
        current_day_number: Optional[int]

    links: ResourceLinks
    id: str
    type: Literal["appStoreVersionPhasedReleases"] = "appStoreVersionPhasedReleases"
    attributes: Optional[Attributes]

class AppStoreVersionSubmission(ApplaudModel):
    class Relationships(ApplaudModel):
        class AppStoreVersion(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appStoreVersions"] = "appStoreVersions"

            links: Optional[Links]
            data: Optional[Data]

        app_store_version: Optional[AppStoreVersion]

    links: ResourceLinks
    id: str
    type: Literal["appStoreVersionSubmissions"] = "appStoreVersionSubmissions"
    relationships: Optional[Relationships]

class AppStoreVersion(ApplaudModel):
    class Attributes(ApplaudModel):
        platform: Optional[Platform]
        version_string: Optional[str]
        app_store_state: Optional[AppStoreVersionState]
        copyright: Optional[str]
        release_type: Optional[AppStoreVersionReleaseType]
        earliest_release_date: Optional[datetime.datetime]
        uses_idfa: Optional[bool] = Field(None, deprecated=True)
        downloadable: Optional[bool]
        created_date: Optional[datetime.datetime]

    class Relationships(ApplaudModel):
        class App(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["apps"] = "apps"

            links: Optional[Links]
            data: Optional[Data]

        @deprecated
        class AgeRatingDeclaration(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["ageRatingDeclarations"] = "ageRatingDeclarations"

            links: Optional[Links]
            data: Optional[Data]

        class AppStoreVersionLocalizations(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appStoreVersionLocalizations"] = "appStoreVersionLocalizations"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        class Build(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["builds"] = "builds"

            links: Optional[Links]
            data: Optional[Data]

        class AppStoreVersionPhasedRelease(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appStoreVersionPhasedReleases"] = "appStoreVersionPhasedReleases"

            links: Optional[Links]
            data: Optional[Data]

        class RoutingAppCoverage(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["routingAppCoverages"] = "routingAppCoverages"

            links: Optional[Links]
            data: Optional[Data]

        class AppStoreReviewDetail(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appStoreReviewDetails"] = "appStoreReviewDetails"

            links: Optional[Links]
            data: Optional[Data]

        class AppStoreVersionSubmission(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appStoreVersionSubmissions"] = "appStoreVersionSubmissions"

            links: Optional[Links]
            data: Optional[Data]

        class IdfaDeclaration(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["idfaDeclarations"] = "idfaDeclarations"

            links: Optional[Links]
            data: Optional[Data]

        class AppClipDefaultExperience(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appClipDefaultExperiences"] = "appClipDefaultExperiences"

            links: Optional[Links]
            data: Optional[Data]

        app: Optional[App]
        age_rating_declaration: Optional[AgeRatingDeclaration] = Field(None, deprecated=True)
        app_store_version_localizations: Optional[AppStoreVersionLocalizations]
        build: Optional[Build]
        app_store_version_phased_release: Optional[AppStoreVersionPhasedRelease]
        routing_app_coverage: Optional[RoutingAppCoverage]
        app_store_review_detail: Optional[AppStoreReviewDetail]
        app_store_version_submission: Optional[AppStoreVersionSubmission]
        idfa_declaration: Optional[IdfaDeclaration]
        app_clip_default_experience: Optional[AppClipDefaultExperience]

    links: ResourceLinks
    id: str
    type: Literal["appStoreVersions"] = "appStoreVersions"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class App(ApplaudModel):
    class Attributes(ApplaudModel):
        name: Optional[str]
        bundle_id: Optional[str]
        sku: Optional[str]
        primary_locale: Optional[str]
        is_or_ever_was_made_for_kids: Optional[bool]
        available_in_new_territories: Optional[bool]
        content_rights_declaration: Optional[AppContentRightsDeclaration]

    class Relationships(ApplaudModel):
        class CiProduct(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["ciProducts"] = "ciProducts"

            links: Optional[Links]
            data: Optional[Data]

        class BetaGroups(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["betaGroups"] = "betaGroups"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        class AppStoreVersions(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appStoreVersions"] = "appStoreVersions"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        class PreReleaseVersions(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["preReleaseVersions"] = "preReleaseVersions"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        class BetaAppLocalizations(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["betaAppLocalizations"] = "betaAppLocalizations"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        class Builds(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["builds"] = "builds"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        class BetaLicenseAgreement(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["betaLicenseAgreements"] = "betaLicenseAgreements"

            links: Optional[Links]
            data: Optional[Data]

        class BetaAppReviewDetail(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["betaAppReviewDetails"] = "betaAppReviewDetails"

            links: Optional[Links]
            data: Optional[Data]

        class AppInfos(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appInfos"] = "appInfos"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        class AppClips(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appClips"] = "appClips"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        class EndUserLicenseAgreement(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["endUserLicenseAgreements"] = "endUserLicenseAgreements"

            links: Optional[Links]
            data: Optional[Data]

        class PreOrder(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appPreOrders"] = "appPreOrders"

            links: Optional[Links]
            data: Optional[Data]

        class Prices(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appPrices"] = "appPrices"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        class AvailableTerritories(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["territories"] = "territories"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        class InAppPurchases(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["inAppPurchases"] = "inAppPurchases"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        class GameCenterEnabledVersions(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["gameCenterEnabledVersions"] = "gameCenterEnabledVersions"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        ci_product: Optional[CiProduct]
        beta_groups: Optional[BetaGroups]
        app_store_versions: Optional[AppStoreVersions]
        pre_release_versions: Optional[PreReleaseVersions]
        beta_app_localizations: Optional[BetaAppLocalizations]
        builds: Optional[Builds]
        beta_license_agreement: Optional[BetaLicenseAgreement]
        beta_app_review_detail: Optional[BetaAppReviewDetail]
        app_infos: Optional[AppInfos]
        app_clips: Optional[AppClips]
        end_user_license_agreement: Optional[EndUserLicenseAgreement]
        pre_order: Optional[PreOrder]
        prices: Optional[Prices]
        available_territories: Optional[AvailableTerritories]
        in_app_purchases: Optional[InAppPurchases]
        game_center_enabled_versions: Optional[GameCenterEnabledVersions]

    links: ResourceLinks
    id: str
    type: Literal["apps"] = "apps"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class BetaAppClipInvocationLocalization(ApplaudModel):
    class Attributes(ApplaudModel):
        title: Optional[str]
        locale: Optional[str]

    links: ResourceLinks
    id: str
    type: Literal["betaAppClipInvocationLocalizations"] = "betaAppClipInvocationLocalizations"
    attributes: Optional[Attributes]

class BetaAppClipInvocationLocalizationInlineCreate(ApplaudModel):
    class Attributes(ApplaudModel):
        locale: str
        title: str

    class Relationships(ApplaudModel):
        class BetaAppClipInvocation(ApplaudModel):
            class Data(ApplaudModel):
                id: str
                type: Literal["betaAppClipInvocations"] = "betaAppClipInvocations"

            data: Optional[Data]

        beta_app_clip_invocation: Optional[BetaAppClipInvocation]

    attributes: Attributes
    type: Literal["betaAppClipInvocationLocalizations"] = "betaAppClipInvocationLocalizations"
    id: Optional[str]
    relationships: Optional[Relationships]

class BetaAppClipInvocation(ApplaudModel):
    class Attributes(ApplaudModel):
        url: Optional[AnyUrl]

    class Relationships(ApplaudModel):
        class BetaAppClipInvocationLocalizations(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["betaAppClipInvocationLocalizations"] = "betaAppClipInvocationLocalizations"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        beta_app_clip_invocation_localizations: Optional[BetaAppClipInvocationLocalizations]

    links: ResourceLinks
    id: str
    type: Literal["betaAppClipInvocations"] = "betaAppClipInvocations"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class BetaAppLocalization(ApplaudModel):
    class Attributes(ApplaudModel):
        feedback_email: Optional[str]
        marketing_url: Optional[str]
        privacy_policy_url: Optional[str]
        tv_os_privacy_policy: Optional[str]
        description: Optional[str]
        locale: Optional[str]

    class Relationships(ApplaudModel):
        class App(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["apps"] = "apps"

            links: Optional[Links]
            data: Optional[Data]

        app: Optional[App]

    links: ResourceLinks
    id: str
    type: Literal["betaAppLocalizations"] = "betaAppLocalizations"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class BetaAppReviewDetail(ApplaudModel):
    class Attributes(ApplaudModel):
        contact_first_name: Optional[str]
        contact_last_name: Optional[str]
        contact_phone: Optional[str]
        contact_email: Optional[str]
        demo_account_name: Optional[str]
        demo_account_password: Optional[str]
        demo_account_required: Optional[bool]
        notes: Optional[str]

    class Relationships(ApplaudModel):
        class App(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["apps"] = "apps"

            links: Optional[Links]
            data: Optional[Data]

        app: Optional[App]

    links: ResourceLinks
    id: str
    type: Literal["betaAppReviewDetails"] = "betaAppReviewDetails"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class BetaAppReviewSubmission(ApplaudModel):
    class Attributes(ApplaudModel):
        beta_review_state: Optional[BetaReviewState]
        submitted_date: Optional[datetime.datetime]

    class Relationships(ApplaudModel):
        class Build(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["builds"] = "builds"

            links: Optional[Links]
            data: Optional[Data]

        build: Optional[Build]

    links: ResourceLinks
    id: str
    type: Literal["betaAppReviewSubmissions"] = "betaAppReviewSubmissions"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class BetaBuildLocalization(ApplaudModel):
    class Attributes(ApplaudModel):
        whats_new: Optional[str]
        locale: Optional[str]

    class Relationships(ApplaudModel):
        class Build(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["builds"] = "builds"

            links: Optional[Links]
            data: Optional[Data]

        build: Optional[Build]

    links: ResourceLinks
    id: str
    type: Literal["betaBuildLocalizations"] = "betaBuildLocalizations"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class BetaGroup(ApplaudModel):
    class Attributes(ApplaudModel):
        name: Optional[str]
        created_date: Optional[datetime.datetime]
        is_internal_group: Optional[bool]
        has_access_to_all_builds: Optional[bool]
        public_link_enabled: Optional[bool]
        public_link_id: Optional[str]
        public_link_limit_enabled: Optional[bool]
        public_link_limit: Optional[int]
        public_link: Optional[str]
        feedback_enabled: Optional[bool]
        ios_builds_available_for_apple_silicon_mac: Optional[bool]

    class Relationships(ApplaudModel):
        class App(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["apps"] = "apps"

            links: Optional[Links]
            data: Optional[Data]

        class Builds(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["builds"] = "builds"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        class BetaTesters(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["betaTesters"] = "betaTesters"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        app: Optional[App]
        builds: Optional[Builds]
        beta_testers: Optional[BetaTesters]

    links: ResourceLinks
    id: str
    type: Literal["betaGroups"] = "betaGroups"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class BetaLicenseAgreement(ApplaudModel):
    class Attributes(ApplaudModel):
        agreement_text: Optional[str]

    class Relationships(ApplaudModel):
        class App(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["apps"] = "apps"

            links: Optional[Links]
            data: Optional[Data]

        app: Optional[App]

    links: ResourceLinks
    id: str
    type: Literal["betaLicenseAgreements"] = "betaLicenseAgreements"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class BetaTesterInvitation(ApplaudModel):
    links: ResourceLinks
    id: str
    type: Literal["betaTesterInvitations"] = "betaTesterInvitations"

class BetaTester(ApplaudModel):
    class Attributes(ApplaudModel):
        first_name: Optional[str]
        last_name: Optional[str]
        email: Optional[EmailStr]
        invite_type: Optional[BetaInviteType]

    class Relationships(ApplaudModel):
        class Apps(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["apps"] = "apps"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        class BetaGroups(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["betaGroups"] = "betaGroups"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        class Builds(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["builds"] = "builds"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        apps: Optional[Apps]
        beta_groups: Optional[BetaGroups]
        builds: Optional[Builds]

    links: ResourceLinks
    id: str
    type: Literal["betaTesters"] = "betaTesters"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class BuildBetaDetail(ApplaudModel):
    class Attributes(ApplaudModel):
        auto_notify_enabled: Optional[bool]
        internal_build_state: Optional[InternalBetaState]
        external_build_state: Optional[ExternalBetaState]

    class Relationships(ApplaudModel):
        class Build(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["builds"] = "builds"

            links: Optional[Links]
            data: Optional[Data]

        build: Optional[Build]

    links: ResourceLinks
    id: str
    type: Literal["buildBetaDetails"] = "buildBetaDetails"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class BuildBetaNotification(ApplaudModel):
    links: ResourceLinks
    id: str
    type: Literal["buildBetaNotifications"] = "buildBetaNotifications"

class BuildBundleFileSize(ApplaudModel):
    class Attributes(ApplaudModel):
        device_model: Optional[str]
        os_version: Optional[str]
        download_bytes: Optional[int]
        install_bytes: Optional[int]

    links: ResourceLinks
    id: str
    type: Literal["buildBundleFileSizes"] = "buildBundleFileSizes"
    attributes: Optional[Attributes]

class BuildBundle(ApplaudModel):
    class Attributes(ApplaudModel):
        bundle_id: Optional[str]
        bundle_type: Optional[BuildBundleType]
        sdk_build: Optional[str]
        platform_build: Optional[str]
        file_name: Optional[str]
        has_sirikit: Optional[bool]
        has_on_demand_resources: Optional[bool]
        has_prerendered_icon: Optional[bool]
        uses_location_services: Optional[bool]
        is_ios_build_mac_app_store_compatible: Optional[bool]
        includes_symbols: Optional[bool]
        d_sym_url: Optional[AnyUrl]
        supported_architectures: Optional[list[str]]
        required_capabilities: Optional[list[str]]
        device_protocols: Optional[list[str]]
        locales: Optional[list[str]]
        entitlements: Optional[dict[str, dict[str, str]]]

    class Relationships(ApplaudModel):
        class AppClipDomainCacheStatus(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appClipDomainStatuses"] = "appClipDomainStatuses"

            links: Optional[Links]
            data: Optional[Data]

        class AppClipDomainDebugStatus(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appClipDomainStatuses"] = "appClipDomainStatuses"

            links: Optional[Links]
            data: Optional[Data]

        class BetaAppClipInvocations(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["betaAppClipInvocations"] = "betaAppClipInvocations"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        class BuildBundleFileSizes(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["buildBundleFileSizes"] = "buildBundleFileSizes"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        app_clip_domain_cache_status: Optional[AppClipDomainCacheStatus]
        app_clip_domain_debug_status: Optional[AppClipDomainDebugStatus]
        beta_app_clip_invocations: Optional[BetaAppClipInvocations]
        build_bundle_file_sizes: Optional[BuildBundleFileSizes]

    links: ResourceLinks
    id: str
    type: Literal["buildBundles"] = "buildBundles"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class BuildIcon(ApplaudModel):
    class Attributes(ApplaudModel):
        icon_asset: Optional[ImageAsset]
        icon_type: Optional[IconAssetType]

    links: ResourceLinks
    id: str
    type: Literal["buildIcons"] = "buildIcons"
    attributes: Optional[Attributes]

class Build(ApplaudModel):
    class Attributes(ApplaudModel):
        version: Optional[str]
        uploaded_date: Optional[datetime.datetime]
        expiration_date: Optional[datetime.datetime]
        expired: Optional[bool]
        min_os_version: Optional[str]
        ls_minimum_system_version: Optional[str]
        computed_min_mac_os_version: Optional[str]
        icon_asset_token: Optional[ImageAsset]
        processing_state: Optional[BuildProcessingState]
        build_audience_type: Optional[BuildAudienceType]
        uses_non_exempt_encryption: Optional[bool]

    class Relationships(ApplaudModel):
        class PreReleaseVersion(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["preReleaseVersions"] = "preReleaseVersions"

            links: Optional[Links]
            data: Optional[Data]

        class IndividualTesters(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["betaTesters"] = "betaTesters"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        class BetaBuildLocalizations(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["betaBuildLocalizations"] = "betaBuildLocalizations"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        class AppEncryptionDeclaration(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appEncryptionDeclarations"] = "appEncryptionDeclarations"

            links: Optional[Links]
            data: Optional[Data]

        class BetaAppReviewSubmission(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["betaAppReviewSubmissions"] = "betaAppReviewSubmissions"

            links: Optional[Links]
            data: Optional[Data]

        class App(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["apps"] = "apps"

            links: Optional[Links]
            data: Optional[Data]

        class BuildBetaDetail(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["buildBetaDetails"] = "buildBetaDetails"

            links: Optional[Links]
            data: Optional[Data]

        class AppStoreVersion(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appStoreVersions"] = "appStoreVersions"

            links: Optional[Links]
            data: Optional[Data]

        class Icons(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["buildIcons"] = "buildIcons"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        class BuildBundles(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["buildBundles"] = "buildBundles"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        pre_release_version: Optional[PreReleaseVersion]
        individual_testers: Optional[IndividualTesters]
        beta_build_localizations: Optional[BetaBuildLocalizations]
        app_encryption_declaration: Optional[AppEncryptionDeclaration]
        beta_app_review_submission: Optional[BetaAppReviewSubmission]
        app: Optional[App]
        build_beta_detail: Optional[BuildBetaDetail]
        app_store_version: Optional[AppStoreVersion]
        icons: Optional[Icons]
        build_bundles: Optional[BuildBundles]

    links: ResourceLinks
    id: str
    type: Literal["builds"] = "builds"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class BundleIdCapability(ApplaudModel):
    class Attributes(ApplaudModel):
        capability_type: Optional[CapabilityType]
        settings: Optional[list[CapabilitySetting]]

    links: ResourceLinks
    id: str
    type: Literal["bundleIdCapabilities"] = "bundleIdCapabilities"
    attributes: Optional[Attributes]

class BundleId(ApplaudModel):
    class Attributes(ApplaudModel):
        name: Optional[str]
        platform: Optional[BundleIdPlatform]
        identifier: Optional[str]
        seed_id: Optional[str]

    class Relationships(ApplaudModel):
        class Profiles(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["profiles"] = "profiles"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        class BundleIdCapabilities(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["bundleIdCapabilities"] = "bundleIdCapabilities"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        class App(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["apps"] = "apps"

            links: Optional[Links]
            data: Optional[Data]

        profiles: Optional[Profiles]
        bundle_id_capabilities: Optional[BundleIdCapabilities]
        app: Optional[App]

    links: ResourceLinks
    id: str
    type: Literal["bundleIds"] = "bundleIds"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class Certificate(ApplaudModel):
    class Attributes(ApplaudModel):
        name: Optional[str]
        certificate_type: Optional[CertificateType]
        display_name: Optional[str]
        serial_number: Optional[str]
        platform: Optional[BundleIdPlatform]
        expiration_date: Optional[datetime.datetime]
        certificate_content: Optional[str]

    links: ResourceLinks
    id: str
    type: Literal["certificates"] = "certificates"
    attributes: Optional[Attributes]

class CiArtifact(ApplaudModel):
    class Attributes(ApplaudModel):
        file_type: Optional[CiArtifactFileType]
        file_name: Optional[str]
        file_size: Optional[int]
        download_url: Optional[AnyUrl]

    links: ResourceLinks
    id: str
    type: Literal["ciArtifacts"] = "ciArtifacts"
    attributes: Optional[Attributes]

class CiBuildAction(ApplaudModel):
    class Attributes(ApplaudModel):
        name: Optional[str]
        action_type: Optional[CiActionType]
        started_date: Optional[datetime.datetime]
        finished_date: Optional[datetime.datetime]
        issue_counts: Optional[CiIssueCounts]
        execution_progress: Optional[CiExecutionProgress]
        completion_status: Optional[CiCompletionStatus]
        is_required_to_pass: Optional[bool]

    class Relationships(ApplaudModel):
        class BuildRun(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["ciBuildRuns"] = "ciBuildRuns"

            links: Optional[Links]
            data: Optional[Data]

        build_run: Optional[BuildRun]

    links: ResourceLinks
    id: str
    type: Literal["ciBuildActions"] = "ciBuildActions"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class CiBuildRun(ApplaudModel):
    class Attributes(ApplaudModel):
        class SourceCommit(ApplaudModel):
            commit_sha: Optional[str]
            message: Optional[str]
            author: Optional[CiGitUser]
            committer: Optional[CiGitUser]
            web_url: Optional[AnyUrl]

        class DestinationCommit(ApplaudModel):
            commit_sha: Optional[str]
            message: Optional[str]
            author: Optional[CiGitUser]
            committer: Optional[CiGitUser]
            web_url: Optional[AnyUrl]

        number: Optional[int]
        created_date: Optional[datetime.datetime]
        started_date: Optional[datetime.datetime]
        finished_date: Optional[datetime.datetime]
        source_commit: Optional[SourceCommit]
        destination_commit: Optional[DestinationCommit]
        is_pull_request_build: Optional[bool]
        issue_counts: Optional[CiIssueCounts]
        execution_progress: Optional[CiExecutionProgress]
        completion_status: Optional[CiCompletionStatus]
        start_reason: Optional[CiBuildRunStartReason]
        cancel_reason: Optional[CiBuildRunCancelReason]

    class Relationships(ApplaudModel):
        class Builds(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["builds"] = "builds"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        class Workflow(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["ciWorkflows"] = "ciWorkflows"

            links: Optional[Links]
            data: Optional[Data]

        class Product(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["ciProducts"] = "ciProducts"

            links: Optional[Links]
            data: Optional[Data]

        class SourceBranchOrTag(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["scmGitReferences"] = "scmGitReferences"

            links: Optional[Links]
            data: Optional[Data]

        class DestinationBranch(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["scmGitReferences"] = "scmGitReferences"

            links: Optional[Links]
            data: Optional[Data]

        class PullRequest(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["scmPullRequests"] = "scmPullRequests"

            links: Optional[Links]
            data: Optional[Data]

        builds: Optional[Builds]
        workflow: Optional[Workflow]
        product: Optional[Product]
        source_branch_or_tag: Optional[SourceBranchOrTag]
        destination_branch: Optional[DestinationBranch]
        pull_request: Optional[PullRequest]

    links: ResourceLinks
    id: str
    type: Literal["ciBuildRuns"] = "ciBuildRuns"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class CiIssue(ApplaudModel):
    class Attributes(ApplaudModel):
        issue_type: Optional[CiIssueType]
        message: Optional[str]
        file_source: Optional[FileLocation]
        category: Optional[str]

    links: ResourceLinks
    id: str
    type: Literal["ciIssues"] = "ciIssues"
    attributes: Optional[Attributes]

class CiMacOsVersion(ApplaudModel):
    class Attributes(ApplaudModel):
        version: Optional[str]
        name: Optional[str]

    class Relationships(ApplaudModel):
        class XcodeVersions(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["ciXcodeVersions"] = "ciXcodeVersions"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        xcode_versions: Optional[XcodeVersions]

    links: ResourceLinks
    id: str
    type: Literal["ciMacOsVersions"] = "ciMacOsVersions"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class CiProduct(ApplaudModel):
    class Attributes(ApplaudModel):
        name: Optional[str]
        created_date: Optional[datetime.datetime]
        product_type: Optional[CiProductType]

    class Relationships(ApplaudModel):
        class App(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["apps"] = "apps"

            links: Optional[Links]
            data: Optional[Data]

        class BundleId(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["bundleIds"] = "bundleIds"

            links: Optional[Links]
            data: Optional[Data]

        class PrimaryRepositories(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["scmRepositories"] = "scmRepositories"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        app: Optional[App]
        bundle_id: Optional[BundleId]
        primary_repositories: Optional[PrimaryRepositories]

    links: ResourceLinks
    id: str
    type: Literal["ciProducts"] = "ciProducts"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class CiTestResult(ApplaudModel):
    class Attributes(ApplaudModel):
        class DestinationTestResult(ApplaudModel):
            uuid: Optional[str]
            device_name: Optional[str]
            os_version: Optional[str]
            status: Optional[CiTestStatus]
            duration: Optional[float]

        class_name: Optional[str]
        name: Optional[str]
        status: Optional[CiTestStatus]
        file_source: Optional[FileLocation]
        message: Optional[str]
        destination_test_results: Optional[list[DestinationTestResult]]

    links: ResourceLinks
    id: str
    type: Literal["ciTestResults"] = "ciTestResults"
    attributes: Optional[Attributes]

class CiWorkflow(ApplaudModel):
    class Attributes(ApplaudModel):
        name: Optional[str]
        description: Optional[str]
        branch_start_condition: Optional[CiBranchStartCondition]
        tag_start_condition: Optional[CiTagStartCondition]
        pull_request_start_condition: Optional[CiPullRequestStartCondition]
        scheduled_start_condition: Optional[CiScheduledStartCondition]
        actions: Optional[list[CiAction]]
        is_enabled: Optional[bool]
        is_locked_for_editing: Optional[bool]
        clean: Optional[bool]
        container_file_path: Optional[str]
        last_modified_date: Optional[datetime.datetime]

    class Relationships(ApplaudModel):
        class Product(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["ciProducts"] = "ciProducts"

            links: Optional[Links]
            data: Optional[Data]

        class Repository(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["scmRepositories"] = "scmRepositories"

            links: Optional[Links]
            data: Optional[Data]

        class XcodeVersion(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["ciXcodeVersions"] = "ciXcodeVersions"

            links: Optional[Links]
            data: Optional[Data]

        class MacOsVersion(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["ciMacOsVersions"] = "ciMacOsVersions"

            links: Optional[Links]
            data: Optional[Data]

        product: Optional[Product]
        repository: Optional[Repository]
        xcode_version: Optional[XcodeVersion]
        mac_os_version: Optional[MacOsVersion]

    links: ResourceLinks
    id: str
    type: Literal["ciWorkflows"] = "ciWorkflows"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class CiXcodeVersion(ApplaudModel):
    class Attributes(ApplaudModel):
        class TestDestination(ApplaudModel):
            class AvailableRuntime(ApplaudModel):
                runtime_name: Optional[str]
                runtime_identifier: Optional[str]

            device_type_name: Optional[str]
            device_type_identifier: Optional[str]
            available_runtimes: Optional[list[AvailableRuntime]]
            kind: Optional[CiTestDestinationKind]

        version: Optional[str]
        name: Optional[str]
        test_destinations: Optional[list[TestDestination]]

    class Relationships(ApplaudModel):
        class MacOsVersions(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["ciMacOsVersions"] = "ciMacOsVersions"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        mac_os_versions: Optional[MacOsVersions]

    links: ResourceLinks
    id: str
    type: Literal["ciXcodeVersions"] = "ciXcodeVersions"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class DiagnosticLog(ApplaudModel):
    links: ResourceLinks
    id: str
    type: Literal["diagnosticLogs"] = "diagnosticLogs"

class DiagnosticSignature(ApplaudModel):
    class Attributes(ApplaudModel):
        diagnostic_type: Literal[DiagnosticType.DISK_WRITES] = DiagnosticType.DISK_WRITES
        signature: Optional[str]
        weight: Optional[float]

    links: ResourceLinks
    id: str
    type: Literal["diagnosticSignatures"] = "diagnosticSignatures"
    attributes: Optional[Attributes]

class EndUserLicenseAgreement(ApplaudModel):
    class Attributes(ApplaudModel):
        agreement_text: Optional[str]

    class Relationships(ApplaudModel):
        class App(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["apps"] = "apps"

            links: Optional[Links]
            data: Optional[Data]

        class Territories(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["territories"] = "territories"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        app: Optional[App]
        territories: Optional[Territories]

    links: ResourceLinks
    id: str
    type: Literal["endUserLicenseAgreements"] = "endUserLicenseAgreements"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class GameCenterEnabledVersion(ApplaudModel):
    class Attributes(ApplaudModel):
        platform: Optional[Platform]
        version_string: Optional[str]
        icon_asset: Optional[ImageAsset]

    class Relationships(ApplaudModel):
        class CompatibleVersions(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["gameCenterEnabledVersions"] = "gameCenterEnabledVersions"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        class App(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["apps"] = "apps"

            links: Optional[Links]
            data: Optional[Data]

        compatible_versions: Optional[CompatibleVersions]
        app: Optional[App]

    links: ResourceLinks
    id: str
    type: Literal["gameCenterEnabledVersions"] = "gameCenterEnabledVersions"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

@deprecated
class IdfaDeclaration(ApplaudModel):
    class Attributes(ApplaudModel):
        serves_ads: Optional[bool]
        attributes_app_installation_to_previous_ad: Optional[bool]
        attributes_action_with_previous_ad: Optional[bool]
        honors_limited_ad_tracking: Optional[bool]

    class Relationships(ApplaudModel):
        class AppStoreVersion(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appStoreVersions"] = "appStoreVersions"

            links: Optional[Links]
            data: Optional[Data]

        app_store_version: Optional[AppStoreVersion]

    links: ResourceLinks
    id: str
    type: Literal["idfaDeclarations"] = "idfaDeclarations"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class InAppPurchase(ApplaudModel):
    class Attributes(ApplaudModel):
        reference_name: Optional[str]
        product_id: Optional[str]
        in_app_purchase_type: Optional[InAppPurchaseType]
        state: Optional[InAppPurchaseState]

    class Relationships(ApplaudModel):
        class Apps(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["apps"] = "apps"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        apps: Optional[Apps]

    links: ResourceLinks
    id: str
    type: Literal["inAppPurchases"] = "inAppPurchases"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class PerfPowerMetric(ApplaudModel):
    class Attributes(ApplaudModel):
        platform: Literal[PerfPowerMetricPlatform.IOS] = PerfPowerMetricPlatform.IOS
        metric_type: Optional[PerfPowerMetricType]
        device_type: Optional[str]

    links: ResourceLinks
    id: str
    type: Literal["perfPowerMetrics"] = "perfPowerMetrics"
    attributes: Optional[Attributes]

class PrereleaseVersion(ApplaudModel):
    class Attributes(ApplaudModel):
        version: Optional[str]
        platform: Optional[Platform]

    class Relationships(ApplaudModel):
        class Builds(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["builds"] = "builds"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        class App(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["apps"] = "apps"

            links: Optional[Links]
            data: Optional[Data]

        builds: Optional[Builds]
        app: Optional[App]

    links: ResourceLinks
    id: str
    type: Literal["preReleaseVersions"] = "preReleaseVersions"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class Profile(ApplaudModel):
    class Attributes(ApplaudModel):
        name: Optional[str]
        platform: Optional[BundleIdPlatform]
        profile_type: Optional[ProfileType]
        profile_state: Optional[ProfileState]
        profile_content: Optional[str]
        uuid: Optional[str]
        created_date: Optional[datetime.datetime]
        expiration_date: Optional[datetime.datetime]

    class Relationships(ApplaudModel):
        class BundleId(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["bundleIds"] = "bundleIds"

            links: Optional[Links]
            data: Optional[Data]

        class Devices(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["devices"] = "devices"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        class Certificates(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["certificates"] = "certificates"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        bundle_id: Optional[BundleId]
        devices: Optional[Devices]
        certificates: Optional[Certificates]

    links: ResourceLinks
    id: str
    type: Literal["profiles"] = "profiles"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class RoutingAppCoverage(ApplaudModel):
    class Attributes(ApplaudModel):
        file_size: Optional[int]
        file_name: Optional[str]
        source_file_checksum: Optional[str]
        upload_operations: Optional[list[UploadOperation]]
        asset_delivery_state: Optional[AppMediaAssetState]

    class Relationships(ApplaudModel):
        class AppStoreVersion(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["appStoreVersions"] = "appStoreVersions"

            links: Optional[Links]
            data: Optional[Data]

        app_store_version: Optional[AppStoreVersion]

    links: ResourceLinks
    id: str
    type: Literal["routingAppCoverages"] = "routingAppCoverages"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class ScmGitReference(ApplaudModel):
    class Attributes(ApplaudModel):
        name: Optional[str]
        canonical_name: Optional[str]
        is_deleted: Optional[bool]
        kind: Optional[CiGitRefKind]

    class Relationships(ApplaudModel):
        class Repository(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["scmRepositories"] = "scmRepositories"

            links: Optional[Links]
            data: Optional[Data]

        repository: Optional[Repository]

    links: ResourceLinks
    id: str
    type: Literal["scmGitReferences"] = "scmGitReferences"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class ScmProvider(ApplaudModel):
    class Attributes(ApplaudModel):
        scm_provider_type: Optional[ScmProviderType]
        url: Optional[AnyUrl]

    links: ResourceLinks
    id: str
    type: Literal["scmProviders"] = "scmProviders"
    attributes: Optional[Attributes]

class ScmRepository(ApplaudModel):
    class Attributes(ApplaudModel):
        last_accessed_date: Optional[datetime.datetime]
        http_clone_url: Optional[AnyUrl]
        ssh_clone_url: Optional[AnyUrl]
        owner_name: Optional[str]
        repository_name: Optional[str]

    class Relationships(ApplaudModel):
        class ScmProvider(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["scmProviders"] = "scmProviders"

            links: Optional[Links]
            data: Optional[Data]

        class DefaultBranch(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["scmGitReferences"] = "scmGitReferences"

            links: Optional[Links]
            data: Optional[Data]

        scm_provider: Optional[ScmProvider]
        default_branch: Optional[DefaultBranch]

    links: ResourceLinks
    id: str
    type: Literal["scmRepositories"] = "scmRepositories"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class Territory(ApplaudModel):
    class Attributes(ApplaudModel):
        currency: Optional[str]

    links: ResourceLinks
    id: str
    type: Literal["territories"] = "territories"
    attributes: Optional[Attributes]

class UserInvitation(ApplaudModel):
    class Attributes(ApplaudModel):
        email: Optional[EmailStr]
        first_name: Optional[str]
        last_name: Optional[str]
        expiration_date: Optional[datetime.datetime]
        roles: Optional[list[UserRole]]
        all_apps_visible: Optional[bool]
        provisioning_allowed: Optional[bool]

    class Relationships(ApplaudModel):
        class VisibleApps(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["apps"] = "apps"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        visible_apps: Optional[VisibleApps]

    links: ResourceLinks
    id: str
    type: Literal["userInvitations"] = "userInvitations"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class User(ApplaudModel):
    class Attributes(ApplaudModel):
        username: Optional[str]
        first_name: Optional[str]
        last_name: Optional[str]
        roles: Optional[list[UserRole]]
        all_apps_visible: Optional[bool]
        provisioning_allowed: Optional[bool]

    class Relationships(ApplaudModel):
        class VisibleApps(ApplaudModel):
            class Links(ApplaudModel):
                self: Optional[str]
                related: Optional[str]

            class Data(ApplaudModel):
                id: str
                type: Literal["apps"] = "apps"

            links: Optional[Links]
            meta: Optional[PagingInformation]
            data: Optional[list[Data]]

        visible_apps: Optional[VisibleApps]

    links: ResourceLinks
    id: str
    type: Literal["users"] = "users"
    attributes: Optional[Attributes]
    relationships: Optional[Relationships]

class ErrorSourceParameter(ApplaudModel):
    parameter: Optional[str]

class ErrorSourcePointer(ApplaudModel):
    pointer: Optional[str]

class PagedDocumentLinks(ApplaudModel):
    self: str
    first: Optional[str]
    next: Optional[str]

class DocumentLinks(ApplaudModel):
    self: str


