# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import functools
from typing import Any, AsyncIterable, Callable, Dict, Generic, Optional, TypeVar
import warnings

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._recommendations_operations import build_disable_all_for_hosting_environment_request, build_disable_all_for_web_app_request, build_disable_recommendation_for_hosting_environment_request, build_disable_recommendation_for_site_request, build_disable_recommendation_for_subscription_request, build_get_rule_details_by_hosting_environment_request, build_get_rule_details_by_web_app_request, build_list_history_for_hosting_environment_request, build_list_history_for_web_app_request, build_list_recommended_rules_for_hosting_environment_request, build_list_recommended_rules_for_web_app_request, build_list_request, build_reset_all_filters_for_hosting_environment_request, build_reset_all_filters_for_web_app_request, build_reset_all_filters_request
T = TypeVar('T')
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]

class RecommendationsOperations:
    """RecommendationsOperations async operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.mgmt.web.v2020_12_01.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = _models

    def __init__(self, client, config, serializer, deserializer) -> None:
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    @distributed_trace
    def list(
        self,
        featured: Optional[bool] = None,
        filter: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.RecommendationCollection"]:
        """List all recommendations for a subscription.

        Description for List all recommendations for a subscription.

        :param featured: Specify :code:`<code>true</code>` to return only the most critical
         recommendations. The default is :code:`<code>false</code>`, which returns all recommendations.
        :type featured: bool
        :param filter: Filter is specified by using OData syntax. Example: $filter=channel eq 'Api' or
         channel eq 'Notification' and startTime eq 2014-01-01T00:00:00Z and endTime eq
         2014-12-31T23:59:59Z and timeGrain eq duration'[PT1H|PT1M|P1D].
        :type filter: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either RecommendationCollection or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2020_12_01.models.RecommendationCollection]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.RecommendationCollection"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_request(
                    subscription_id=self._config.subscription_id,
                    featured=featured,
                    filter=filter,
                    template_url=self.list.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                
                request = build_list_request(
                    subscription_id=self._config.subscription_id,
                    featured=featured,
                    filter=filter,
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("RecommendationCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list.metadata = {'url': '/subscriptions/{subscriptionId}/providers/Microsoft.Web/recommendations'}  # type: ignore

    @distributed_trace_async
    async def reset_all_filters(
        self,
        **kwargs: Any
    ) -> None:
        """Reset all recommendation opt-out settings for a subscription.

        Description for Reset all recommendation opt-out settings for a subscription.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_reset_all_filters_request(
            subscription_id=self._config.subscription_id,
            template_url=self.reset_all_filters.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    reset_all_filters.metadata = {'url': '/subscriptions/{subscriptionId}/providers/Microsoft.Web/recommendations/reset'}  # type: ignore


    @distributed_trace_async
    async def disable_recommendation_for_subscription(
        self,
        name: str,
        **kwargs: Any
    ) -> None:
        """Disables the specified rule so it will not apply to a subscription in the future.

        Description for Disables the specified rule so it will not apply to a subscription in the
        future.

        :param name: Rule name.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_disable_recommendation_for_subscription_request(
            name=name,
            subscription_id=self._config.subscription_id,
            template_url=self.disable_recommendation_for_subscription.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    disable_recommendation_for_subscription.metadata = {'url': '/subscriptions/{subscriptionId}/providers/Microsoft.Web/recommendations/{name}/disable'}  # type: ignore


    @distributed_trace
    def list_history_for_hosting_environment(
        self,
        resource_group_name: str,
        hosting_environment_name: str,
        expired_only: Optional[bool] = None,
        filter: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.RecommendationCollection"]:
        """Get past recommendations for an app, optionally specified by the time range.

        Description for Get past recommendations for an app, optionally specified by the time range.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param hosting_environment_name: Name of the hosting environment.
        :type hosting_environment_name: str
        :param expired_only: Specify :code:`<code>false</code>` to return all recommendations. The
         default is :code:`<code>true</code>`, which returns only expired recommendations.
        :type expired_only: bool
        :param filter: Filter is specified by using OData syntax. Example: $filter=channel eq 'Api' or
         channel eq 'Notification' and startTime eq 2014-01-01T00:00:00Z and endTime eq
         2014-12-31T23:59:59Z and timeGrain eq duration'[PT1H|PT1M|P1D].
        :type filter: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either RecommendationCollection or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2020_12_01.models.RecommendationCollection]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.RecommendationCollection"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_history_for_hosting_environment_request(
                    resource_group_name=resource_group_name,
                    hosting_environment_name=hosting_environment_name,
                    subscription_id=self._config.subscription_id,
                    expired_only=expired_only,
                    filter=filter,
                    template_url=self.list_history_for_hosting_environment.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                
                request = build_list_history_for_hosting_environment_request(
                    resource_group_name=resource_group_name,
                    hosting_environment_name=hosting_environment_name,
                    subscription_id=self._config.subscription_id,
                    expired_only=expired_only,
                    filter=filter,
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("RecommendationCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_history_for_hosting_environment.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{hostingEnvironmentName}/recommendationHistory'}  # type: ignore

    @distributed_trace
    def list_recommended_rules_for_hosting_environment(
        self,
        resource_group_name: str,
        hosting_environment_name: str,
        featured: Optional[bool] = None,
        filter: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.RecommendationCollection"]:
        """Get all recommendations for a hosting environment.

        Description for Get all recommendations for a hosting environment.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param hosting_environment_name: Name of the app.
        :type hosting_environment_name: str
        :param featured: Specify :code:`<code>true</code>` to return only the most critical
         recommendations. The default is :code:`<code>false</code>`, which returns all recommendations.
        :type featured: bool
        :param filter: Return only channels specified in the filter. Filter is specified by using OData
         syntax. Example: $filter=channel eq 'Api' or channel eq 'Notification'.
        :type filter: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either RecommendationCollection or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2020_12_01.models.RecommendationCollection]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.RecommendationCollection"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_recommended_rules_for_hosting_environment_request(
                    resource_group_name=resource_group_name,
                    hosting_environment_name=hosting_environment_name,
                    subscription_id=self._config.subscription_id,
                    featured=featured,
                    filter=filter,
                    template_url=self.list_recommended_rules_for_hosting_environment.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                
                request = build_list_recommended_rules_for_hosting_environment_request(
                    resource_group_name=resource_group_name,
                    hosting_environment_name=hosting_environment_name,
                    subscription_id=self._config.subscription_id,
                    featured=featured,
                    filter=filter,
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("RecommendationCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_recommended_rules_for_hosting_environment.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{hostingEnvironmentName}/recommendations'}  # type: ignore

    @distributed_trace_async
    async def disable_all_for_hosting_environment(
        self,
        resource_group_name: str,
        environment_name: str,
        hosting_environment_name: str,
        **kwargs: Any
    ) -> None:
        """Disable all recommendations for an app.

        Description for Disable all recommendations for an app.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param environment_name: Name of the app.
        :type environment_name: str
        :param hosting_environment_name:
        :type hosting_environment_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_disable_all_for_hosting_environment_request(
            resource_group_name=resource_group_name,
            hosting_environment_name=hosting_environment_name,
            subscription_id=self._config.subscription_id,
            environment_name=environment_name,
            template_url=self.disable_all_for_hosting_environment.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    disable_all_for_hosting_environment.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{hostingEnvironmentName}/recommendations/disable'}  # type: ignore


    @distributed_trace_async
    async def reset_all_filters_for_hosting_environment(
        self,
        resource_group_name: str,
        environment_name: str,
        hosting_environment_name: str,
        **kwargs: Any
    ) -> None:
        """Reset all recommendation opt-out settings for an app.

        Description for Reset all recommendation opt-out settings for an app.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param environment_name: Name of the app.
        :type environment_name: str
        :param hosting_environment_name:
        :type hosting_environment_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_reset_all_filters_for_hosting_environment_request(
            resource_group_name=resource_group_name,
            hosting_environment_name=hosting_environment_name,
            subscription_id=self._config.subscription_id,
            environment_name=environment_name,
            template_url=self.reset_all_filters_for_hosting_environment.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    reset_all_filters_for_hosting_environment.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{hostingEnvironmentName}/recommendations/reset'}  # type: ignore


    @distributed_trace_async
    async def get_rule_details_by_hosting_environment(
        self,
        resource_group_name: str,
        hosting_environment_name: str,
        name: str,
        update_seen: Optional[bool] = None,
        recommendation_id: Optional[str] = None,
        **kwargs: Any
    ) -> "_models.RecommendationRule":
        """Get a recommendation rule for an app.

        Description for Get a recommendation rule for an app.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param hosting_environment_name: Name of the hosting environment.
        :type hosting_environment_name: str
        :param name: Name of the recommendation.
        :type name: str
        :param update_seen: Specify :code:`<code>true</code>` to update the last-seen timestamp of the
         recommendation object.
        :type update_seen: bool
        :param recommendation_id: The GUID of the recommendation object if you query an expired one.
         You don't need to specify it to query an active entry.
        :type recommendation_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RecommendationRule, or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_12_01.models.RecommendationRule
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.RecommendationRule"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_get_rule_details_by_hosting_environment_request(
            resource_group_name=resource_group_name,
            hosting_environment_name=hosting_environment_name,
            name=name,
            subscription_id=self._config.subscription_id,
            update_seen=update_seen,
            recommendation_id=recommendation_id,
            template_url=self.get_rule_details_by_hosting_environment.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('RecommendationRule', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_rule_details_by_hosting_environment.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{hostingEnvironmentName}/recommendations/{name}'}  # type: ignore


    @distributed_trace_async
    async def disable_recommendation_for_hosting_environment(
        self,
        resource_group_name: str,
        environment_name: str,
        name: str,
        hosting_environment_name: str,
        **kwargs: Any
    ) -> None:
        """Disables the specific rule for a web site permanently.

        Description for Disables the specific rule for a web site permanently.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param environment_name: Site name.
        :type environment_name: str
        :param name: Rule name.
        :type name: str
        :param hosting_environment_name:
        :type hosting_environment_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_disable_recommendation_for_hosting_environment_request(
            resource_group_name=resource_group_name,
            name=name,
            hosting_environment_name=hosting_environment_name,
            subscription_id=self._config.subscription_id,
            environment_name=environment_name,
            template_url=self.disable_recommendation_for_hosting_environment.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    disable_recommendation_for_hosting_environment.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{hostingEnvironmentName}/recommendations/{name}/disable'}  # type: ignore


    @distributed_trace
    def list_history_for_web_app(
        self,
        resource_group_name: str,
        site_name: str,
        expired_only: Optional[bool] = None,
        filter: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.RecommendationCollection"]:
        """Get past recommendations for an app, optionally specified by the time range.

        Description for Get past recommendations for an app, optionally specified by the time range.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Name of the app.
        :type site_name: str
        :param expired_only: Specify :code:`<code>false</code>` to return all recommendations. The
         default is :code:`<code>true</code>`, which returns only expired recommendations.
        :type expired_only: bool
        :param filter: Filter is specified by using OData syntax. Example: $filter=channel eq 'Api' or
         channel eq 'Notification' and startTime eq 2014-01-01T00:00:00Z and endTime eq
         2014-12-31T23:59:59Z and timeGrain eq duration'[PT1H|PT1M|P1D].
        :type filter: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either RecommendationCollection or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2020_12_01.models.RecommendationCollection]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.RecommendationCollection"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_history_for_web_app_request(
                    resource_group_name=resource_group_name,
                    site_name=site_name,
                    subscription_id=self._config.subscription_id,
                    expired_only=expired_only,
                    filter=filter,
                    template_url=self.list_history_for_web_app.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                
                request = build_list_history_for_web_app_request(
                    resource_group_name=resource_group_name,
                    site_name=site_name,
                    subscription_id=self._config.subscription_id,
                    expired_only=expired_only,
                    filter=filter,
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("RecommendationCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_history_for_web_app.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/recommendationHistory'}  # type: ignore

    @distributed_trace
    def list_recommended_rules_for_web_app(
        self,
        resource_group_name: str,
        site_name: str,
        featured: Optional[bool] = None,
        filter: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.RecommendationCollection"]:
        """Get all recommendations for an app.

        Description for Get all recommendations for an app.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Name of the app.
        :type site_name: str
        :param featured: Specify :code:`<code>true</code>` to return only the most critical
         recommendations. The default is :code:`<code>false</code>`, which returns all recommendations.
        :type featured: bool
        :param filter: Return only channels specified in the filter. Filter is specified by using OData
         syntax. Example: $filter=channel eq 'Api' or channel eq 'Notification'.
        :type filter: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either RecommendationCollection or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2020_12_01.models.RecommendationCollection]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.RecommendationCollection"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_recommended_rules_for_web_app_request(
                    resource_group_name=resource_group_name,
                    site_name=site_name,
                    subscription_id=self._config.subscription_id,
                    featured=featured,
                    filter=filter,
                    template_url=self.list_recommended_rules_for_web_app.metadata['url'],
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                
                request = build_list_recommended_rules_for_web_app_request(
                    resource_group_name=resource_group_name,
                    site_name=site_name,
                    subscription_id=self._config.subscription_id,
                    featured=featured,
                    filter=filter,
                    template_url=next_link,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("RecommendationCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_recommended_rules_for_web_app.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/recommendations'}  # type: ignore

    @distributed_trace_async
    async def disable_all_for_web_app(
        self,
        resource_group_name: str,
        site_name: str,
        **kwargs: Any
    ) -> None:
        """Disable all recommendations for an app.

        Description for Disable all recommendations for an app.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Name of the app.
        :type site_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_disable_all_for_web_app_request(
            resource_group_name=resource_group_name,
            site_name=site_name,
            subscription_id=self._config.subscription_id,
            template_url=self.disable_all_for_web_app.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    disable_all_for_web_app.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/recommendations/disable'}  # type: ignore


    @distributed_trace_async
    async def reset_all_filters_for_web_app(
        self,
        resource_group_name: str,
        site_name: str,
        **kwargs: Any
    ) -> None:
        """Reset all recommendation opt-out settings for an app.

        Description for Reset all recommendation opt-out settings for an app.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Name of the app.
        :type site_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_reset_all_filters_for_web_app_request(
            resource_group_name=resource_group_name,
            site_name=site_name,
            subscription_id=self._config.subscription_id,
            template_url=self.reset_all_filters_for_web_app.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    reset_all_filters_for_web_app.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/recommendations/reset'}  # type: ignore


    @distributed_trace_async
    async def get_rule_details_by_web_app(
        self,
        resource_group_name: str,
        site_name: str,
        name: str,
        update_seen: Optional[bool] = None,
        recommendation_id: Optional[str] = None,
        **kwargs: Any
    ) -> "_models.RecommendationRule":
        """Get a recommendation rule for an app.

        Description for Get a recommendation rule for an app.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Name of the app.
        :type site_name: str
        :param name: Name of the recommendation.
        :type name: str
        :param update_seen: Specify :code:`<code>true</code>` to update the last-seen timestamp of the
         recommendation object.
        :type update_seen: bool
        :param recommendation_id: The GUID of the recommendation object if you query an expired one.
         You don't need to specify it to query an active entry.
        :type recommendation_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RecommendationRule, or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2020_12_01.models.RecommendationRule
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.RecommendationRule"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_get_rule_details_by_web_app_request(
            resource_group_name=resource_group_name,
            site_name=site_name,
            name=name,
            subscription_id=self._config.subscription_id,
            update_seen=update_seen,
            recommendation_id=recommendation_id,
            template_url=self.get_rule_details_by_web_app.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('RecommendationRule', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_rule_details_by_web_app.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/recommendations/{name}'}  # type: ignore


    @distributed_trace_async
    async def disable_recommendation_for_site(
        self,
        resource_group_name: str,
        site_name: str,
        name: str,
        **kwargs: Any
    ) -> None:
        """Disables the specific rule for a web site permanently.

        Description for Disables the specific rule for a web site permanently.

        :param resource_group_name: Name of the resource group to which the resource belongs.
        :type resource_group_name: str
        :param site_name: Site name.
        :type site_name: str
        :param name: Rule name.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_disable_recommendation_for_site_request(
            resource_group_name=resource_group_name,
            site_name=site_name,
            name=name,
            subscription_id=self._config.subscription_id,
            template_url=self.disable_recommendation_for_site.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    disable_recommendation_for_site.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/recommendations/{name}/disable'}  # type: ignore

