"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnsDlq = void 0;
/**
 * An SNS dead letter queue destination configuration for a Lambda event source.
 */
class SnsDlq {
    /**
     *
     */
    constructor(topic) {
        this.topic = topic;
    }
    /**
     * Returns a destination configuration for the DLQ.
     */
    bind(_target, targetHandler) {
        this.topic.grantPublish(targetHandler);
        return {
            destination: this.topic.topicArn,
        };
    }
}
exports.SnsDlq = SnsDlq;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic25zLWRscS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInNucy1kbHEudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBTUEsTUFBYSxNQUFNOzs7O0lBQ2pCLFlBQTZCLEtBQWlCO1FBQWpCLFVBQUssR0FBTCxLQUFLLENBQVk7SUFDOUMsQ0FBQzs7OztJQUtNLElBQUksQ0FBQyxPQUE0QixFQUFFLGFBQXdCO1FBQ2hFLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWSxDQUFDLGFBQWEsQ0FBQyxDQUFDO1FBRXZDLE9BQU87WUFDTCxXQUFXLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxRQUFRO1NBQ2pDLENBQUM7SUFDSixDQUFDO0NBQ0Y7QUFkRCx3QkFjQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IERscURlc3RpbmF0aW9uQ29uZmlnLCBJRXZlbnRTb3VyY2VEbHEsIElFdmVudFNvdXJjZU1hcHBpbmcsIElGdW5jdGlvbiB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1sYW1iZGEnO1xuaW1wb3J0ICogYXMgc25zIGZyb20gJ0Bhd3MtY2RrL2F3cy1zbnMnO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBTbnNEbHEgaW1wbGVtZW50cyBJRXZlbnRTb3VyY2VEbHEge1xuICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IHRvcGljOiBzbnMuSVRvcGljKSB7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgYmluZChfdGFyZ2V0OiBJRXZlbnRTb3VyY2VNYXBwaW5nLCB0YXJnZXRIYW5kbGVyOiBJRnVuY3Rpb24pOiBEbHFEZXN0aW5hdGlvbkNvbmZpZyB7XG4gICAgdGhpcy50b3BpYy5ncmFudFB1Ymxpc2godGFyZ2V0SGFuZGxlcik7XG5cbiAgICByZXR1cm4ge1xuICAgICAgZGVzdGluYXRpb246IHRoaXMudG9waWMudG9waWNBcm4sXG4gICAgfTtcbiAgfVxufVxuIl19