# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['arcane']

package_data = \
{'': ['*']}

install_requires = \
['arcane-core==0.1.1', 'backoff==1.10.0', 'google-cloud-datastore==1.11.0']

setup_kwargs = {
    'name': 'arcane-datastore',
    'version': '0.2.1',
    'description': '',
    'long_description': "# Arcane Datastore\n\nThis package is base on [google-cloud-datastore](https://pypi.org/project/google-cloud-datastore/).\n\n## Get Started\n\n```sh\npip install arcane-datastore\n```\n\n## Example Usage\n\n```python\nfrom arcane import datastore\nclient = datastore.Client()\n\nentity = client.get_entity('kind-id-here', 1)\n```\n\nor\n\n```python\nfrom arcane import datastore\n\n# Import your configs\nfrom configure import Config\n\nclient = datastore.Client.from_service_account_json(Config.KEY, project=Config.GCP_PROJECT)\n\nentity = client.get_entity('kind-id-here', 1)\n```\n",
    'author': 'Arcane',
    'author_email': 'product@arcane.run',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
