"use strict";
const assert_1 = require("@aws-cdk/assert");
const s3 = require("@aws-cdk/aws-s3");
const cdk = require("@aws-cdk/core");
const sources = require("../lib");
const test_function_1 = require("./test-function");
module.exports = {
    'sufficiently complex example'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        const fn = new test_function_1.TestFunction(stack, 'Fn');
        const bucket = new s3.Bucket(stack, 'B');
        // WHEN
        fn.addEventSource(new sources.S3EventSource(bucket, {
            events: [s3.EventType.OBJECT_CREATED, s3.EventType.OBJECT_REMOVED],
            filters: [
                { prefix: 'prefix/' },
                { suffix: '.png' },
            ],
        }));
        // THEN
        assert_1.expect(stack).to(assert_1.haveResource('Custom::S3BucketNotifications', {
            'NotificationConfiguration': {
                'LambdaFunctionConfigurations': [
                    {
                        'Events': [
                            's3:ObjectCreated:*',
                        ],
                        'Filter': {
                            'Key': {
                                'FilterRules': [
                                    {
                                        'Name': 'prefix',
                                        'Value': 'prefix/',
                                    },
                                    {
                                        'Name': 'suffix',
                                        'Value': '.png',
                                    },
                                ],
                            },
                        },
                        'LambdaFunctionArn': {
                            'Fn::GetAtt': [
                                'Fn9270CBC0',
                                'Arn',
                            ],
                        },
                    },
                    {
                        'Events': [
                            's3:ObjectRemoved:*',
                        ],
                        'Filter': {
                            'Key': {
                                'FilterRules': [
                                    {
                                        'Name': 'prefix',
                                        'Value': 'prefix/',
                                    },
                                    {
                                        'Name': 'suffix',
                                        'Value': '.png',
                                    },
                                ],
                            },
                        },
                        'LambdaFunctionArn': {
                            'Fn::GetAtt': [
                                'Fn9270CBC0',
                                'Arn',
                            ],
                        },
                    },
                ],
            },
        }));
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVzdC5zMy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInRlc3QuczMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBLDRDQUF1RDtBQUN2RCxzQ0FBc0M7QUFDdEMscUNBQXFDO0FBRXJDLGtDQUFrQztBQUNsQyxtREFBK0M7QUFJL0MsaUJBQVM7SUFDUCw4QkFBOEIsQ0FBQyxJQUFVO1FBQ3ZDLFFBQVE7UUFDUixNQUFNLEtBQUssR0FBRyxJQUFJLEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQztRQUM5QixNQUFNLEVBQUUsR0FBRyxJQUFJLDRCQUFZLENBQUMsS0FBSyxFQUFFLElBQUksQ0FBQyxDQUFDO1FBQ3pDLE1BQU0sTUFBTSxHQUFHLElBQUksRUFBRSxDQUFDLE1BQU0sQ0FBQyxLQUFLLEVBQUUsR0FBRyxDQUFDLENBQUM7UUFFekMsT0FBTztRQUNQLEVBQUUsQ0FBQyxjQUFjLENBQUMsSUFBSSxPQUFPLENBQUMsYUFBYSxDQUFDLE1BQU0sRUFBRTtZQUNsRCxNQUFNLEVBQUUsQ0FBQyxFQUFFLENBQUMsU0FBUyxDQUFDLGNBQWMsRUFBRSxFQUFFLENBQUMsU0FBUyxDQUFDLGNBQWMsQ0FBQztZQUNsRSxPQUFPLEVBQUU7Z0JBQ1AsRUFBRSxNQUFNLEVBQUUsU0FBUyxFQUFFO2dCQUNyQixFQUFFLE1BQU0sRUFBRSxNQUFNLEVBQUU7YUFDbkI7U0FDRixDQUFDLENBQUMsQ0FBQztRQUVKLE9BQU87UUFDUCxlQUFNLENBQUMsS0FBSyxDQUFDLENBQUMsRUFBRSxDQUFDLHFCQUFZLENBQUMsK0JBQStCLEVBQUU7WUFDN0QsMkJBQTJCLEVBQUU7Z0JBQzNCLDhCQUE4QixFQUFFO29CQUM5Qjt3QkFDRSxRQUFRLEVBQUU7NEJBQ1Isb0JBQW9CO3lCQUNyQjt3QkFDRCxRQUFRLEVBQUU7NEJBQ1IsS0FBSyxFQUFFO2dDQUNMLGFBQWEsRUFBRTtvQ0FDYjt3Q0FDRSxNQUFNLEVBQUUsUUFBUTt3Q0FDaEIsT0FBTyxFQUFFLFNBQVM7cUNBQ25CO29DQUNEO3dDQUNFLE1BQU0sRUFBRSxRQUFRO3dDQUNoQixPQUFPLEVBQUUsTUFBTTtxQ0FDaEI7aUNBQ0Y7NkJBQ0Y7eUJBQ0Y7d0JBQ0QsbUJBQW1CLEVBQUU7NEJBQ25CLFlBQVksRUFBRTtnQ0FDWixZQUFZO2dDQUNaLEtBQUs7NkJBQ047eUJBQ0Y7cUJBQ0Y7b0JBQ0Q7d0JBQ0UsUUFBUSxFQUFFOzRCQUNSLG9CQUFvQjt5QkFDckI7d0JBQ0QsUUFBUSxFQUFFOzRCQUNSLEtBQUssRUFBRTtnQ0FDTCxhQUFhLEVBQUU7b0NBQ2I7d0NBQ0UsTUFBTSxFQUFFLFFBQVE7d0NBQ2hCLE9BQU8sRUFBRSxTQUFTO3FDQUNuQjtvQ0FDRDt3Q0FDRSxNQUFNLEVBQUUsUUFBUTt3Q0FDaEIsT0FBTyxFQUFFLE1BQU07cUNBQ2hCO2lDQUNGOzZCQUNGO3lCQUNGO3dCQUNELG1CQUFtQixFQUFFOzRCQUNuQixZQUFZLEVBQUU7Z0NBQ1osWUFBWTtnQ0FDWixLQUFLOzZCQUNOO3lCQUNGO3FCQUNGO2lCQUNGO2FBQ0Y7U0FDRixDQUFDLENBQUMsQ0FBQztRQUNKLElBQUksQ0FBQyxJQUFJLEVBQUUsQ0FBQztJQUNkLENBQUM7Q0FDRixDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgZXhwZWN0LCBoYXZlUmVzb3VyY2UgfSBmcm9tICdAYXdzLWNkay9hc3NlcnQnO1xuaW1wb3J0ICogYXMgczMgZnJvbSAnQGF3cy1jZGsvYXdzLXMzJztcbmltcG9ydCAqIGFzIGNkayBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IFRlc3QgfSBmcm9tICdub2RldW5pdCc7XG5pbXBvcnQgKiBhcyBzb3VyY2VzIGZyb20gJy4uL2xpYic7XG5pbXBvcnQgeyBUZXN0RnVuY3Rpb24gfSBmcm9tICcuL3Rlc3QtZnVuY3Rpb24nO1xuXG4vKiBlc2xpbnQtZGlzYWJsZSBxdW90ZS1wcm9wcyAqL1xuXG5leHBvcnQgPSB7XG4gICdzdWZmaWNpZW50bHkgY29tcGxleCBleGFtcGxlJyh0ZXN0OiBUZXN0KSB7XG4gICAgLy8gR0lWRU5cbiAgICBjb25zdCBzdGFjayA9IG5ldyBjZGsuU3RhY2soKTtcbiAgICBjb25zdCBmbiA9IG5ldyBUZXN0RnVuY3Rpb24oc3RhY2ssICdGbicpO1xuICAgIGNvbnN0IGJ1Y2tldCA9IG5ldyBzMy5CdWNrZXQoc3RhY2ssICdCJyk7XG5cbiAgICAvLyBXSEVOXG4gICAgZm4uYWRkRXZlbnRTb3VyY2UobmV3IHNvdXJjZXMuUzNFdmVudFNvdXJjZShidWNrZXQsIHtcbiAgICAgIGV2ZW50czogW3MzLkV2ZW50VHlwZS5PQkpFQ1RfQ1JFQVRFRCwgczMuRXZlbnRUeXBlLk9CSkVDVF9SRU1PVkVEXSxcbiAgICAgIGZpbHRlcnM6IFtcbiAgICAgICAgeyBwcmVmaXg6ICdwcmVmaXgvJyB9LFxuICAgICAgICB7IHN1ZmZpeDogJy5wbmcnIH0sXG4gICAgICBdLFxuICAgIH0pKTtcblxuICAgIC8vIFRIRU5cbiAgICBleHBlY3Qoc3RhY2spLnRvKGhhdmVSZXNvdXJjZSgnQ3VzdG9tOjpTM0J1Y2tldE5vdGlmaWNhdGlvbnMnLCB7XG4gICAgICAnTm90aWZpY2F0aW9uQ29uZmlndXJhdGlvbic6IHtcbiAgICAgICAgJ0xhbWJkYUZ1bmN0aW9uQ29uZmlndXJhdGlvbnMnOiBbXG4gICAgICAgICAge1xuICAgICAgICAgICAgJ0V2ZW50cyc6IFtcbiAgICAgICAgICAgICAgJ3MzOk9iamVjdENyZWF0ZWQ6KicsXG4gICAgICAgICAgICBdLFxuICAgICAgICAgICAgJ0ZpbHRlcic6IHtcbiAgICAgICAgICAgICAgJ0tleSc6IHtcbiAgICAgICAgICAgICAgICAnRmlsdGVyUnVsZXMnOiBbXG4gICAgICAgICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgICAgICdOYW1lJzogJ3ByZWZpeCcsXG4gICAgICAgICAgICAgICAgICAgICdWYWx1ZSc6ICdwcmVmaXgvJyxcbiAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICB7XG4gICAgICAgICAgICAgICAgICAgICdOYW1lJzogJ3N1ZmZpeCcsXG4gICAgICAgICAgICAgICAgICAgICdWYWx1ZSc6ICcucG5nJyxcbiAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgXSxcbiAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAnTGFtYmRhRnVuY3Rpb25Bcm4nOiB7XG4gICAgICAgICAgICAgICdGbjo6R2V0QXR0JzogW1xuICAgICAgICAgICAgICAgICdGbjkyNzBDQkMwJyxcbiAgICAgICAgICAgICAgICAnQXJuJyxcbiAgICAgICAgICAgICAgXSxcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgfSxcbiAgICAgICAgICB7XG4gICAgICAgICAgICAnRXZlbnRzJzogW1xuICAgICAgICAgICAgICAnczM6T2JqZWN0UmVtb3ZlZDoqJyxcbiAgICAgICAgICAgIF0sXG4gICAgICAgICAgICAnRmlsdGVyJzoge1xuICAgICAgICAgICAgICAnS2V5Jzoge1xuICAgICAgICAgICAgICAgICdGaWx0ZXJSdWxlcyc6IFtcbiAgICAgICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICAgICAgJ05hbWUnOiAncHJlZml4JyxcbiAgICAgICAgICAgICAgICAgICAgJ1ZhbHVlJzogJ3ByZWZpeC8nLFxuICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICAgICAgJ05hbWUnOiAnc3VmZml4JyxcbiAgICAgICAgICAgICAgICAgICAgJ1ZhbHVlJzogJy5wbmcnLFxuICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICBdLFxuICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICdMYW1iZGFGdW5jdGlvbkFybic6IHtcbiAgICAgICAgICAgICAgJ0ZuOjpHZXRBdHQnOiBbXG4gICAgICAgICAgICAgICAgJ0ZuOTI3MENCQzAnLFxuICAgICAgICAgICAgICAgICdBcm4nLFxuICAgICAgICAgICAgICBdLFxuICAgICAgICAgICAgfSxcbiAgICAgICAgICB9LFxuICAgICAgICBdLFxuICAgICAgfSxcbiAgICB9KSk7XG4gICAgdGVzdC5kb25lKCk7XG4gIH0sXG59O1xuIl19