"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const utils_1 = require("../utils");
/**
 * A custom Deployment Configuration for a Lambda Deployment Group.
 *
 * Note: This class currently stands as namespaced container of the default configurations
 * until CloudFormation supports custom Lambda Deployment Configs. Until then it is closed
 * (private constructor) and does not extend {@link cdk.Construct}
 *
 * @resource AWS::CodeDeploy::DeploymentConfig
 */
class LambdaDeploymentConfig {
    constructor() {
        // nothing to do until CFN supports custom lambda deployment configurations
    }
    /**
     * Import a custom Deployment Configuration for a Lambda Deployment Group defined outside the CDK.
     *
     * @param _scope the parent Construct for this new Construct
     * @param _id the logical ID of this new Construct
     * @param props the properties of the referenced custom Deployment Configuration
     * @returns a Construct representing a reference to an existing custom Deployment Configuration
     */
    static import(_scope, _id, props) {
        return deploymentConfig(props.deploymentConfigName);
    }
}
exports.LambdaDeploymentConfig = LambdaDeploymentConfig;
LambdaDeploymentConfig.ALL_AT_ONCE = deploymentConfig('CodeDeployDefault.LambdaAllAtOnce');
LambdaDeploymentConfig.CANARY_10PERCENT_30MINUTES = deploymentConfig('CodeDeployDefault.LambdaCanary10Percent30Minutes');
LambdaDeploymentConfig.CANARY_10PERCENT_5MINUTES = deploymentConfig('CodeDeployDefault.LambdaCanary10Percent5Minutes');
LambdaDeploymentConfig.CANARY_10PERCENT_10MINUTES = deploymentConfig('CodeDeployDefault.LambdaCanary10Percent10Minutes');
LambdaDeploymentConfig.CANARY_10PERCENT_15MINUTES = deploymentConfig('CodeDeployDefault.LambdaCanary10Percent15Minutes');
LambdaDeploymentConfig.LINEAR_10PERCENT_EVERY_10MINUTES = deploymentConfig('CodeDeployDefault.LambdaLinear10PercentEvery10Minutes');
LambdaDeploymentConfig.LINEAR_10PERCENT_EVERY_1MINUTE = deploymentConfig('CodeDeployDefault.LambdaLinear10PercentEvery1Minute');
LambdaDeploymentConfig.LINEAR_10PERCENT_EVERY_2MINUTES = deploymentConfig('CodeDeployDefault.LambdaLinear10PercentEvery2Minutes');
LambdaDeploymentConfig.LINEAR_10PERCENT_EVERY_3MINUTES = deploymentConfig('CodeDeployDefault.LambdaLinear10PercentEvery3Minutes');
function deploymentConfig(name) {
    return {
        deploymentConfigName: name,
        deploymentConfigArn: utils_1.arnForDeploymentConfig(name)
    };
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGVwbG95bWVudC1jb25maWcuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJkZXBsb3ltZW50LWNvbmZpZy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUNBLG9DQUFrRDtBQTZCbEQ7Ozs7Ozs7O0dBUUc7QUFDSCxNQUFhLHNCQUFzQjtJQXVCakM7UUFDRSwyRUFBMkU7SUFDN0UsQ0FBQztJQWREOzs7Ozs7O09BT0c7SUFDSSxNQUFNLENBQUMsTUFBTSxDQUFDLE1BQXFCLEVBQUUsR0FBVyxFQUFFLEtBQXdDO1FBQy9GLE9BQU8sZ0JBQWdCLENBQUMsS0FBSyxDQUFDLG9CQUFvQixDQUFDLENBQUM7SUFDdEQsQ0FBQzs7QUFyQkgsd0RBMEJDO0FBekJ3QixrQ0FBVyxHQUF1QixnQkFBZ0IsQ0FBQyxtQ0FBbUMsQ0FBQyxDQUFDO0FBQ3hGLGlEQUEwQixHQUFRLGdCQUFnQixDQUFDLGtEQUFrRCxDQUFDLENBQUM7QUFDdkcsZ0RBQXlCLEdBQVMsZ0JBQWdCLENBQUMsaURBQWlELENBQUMsQ0FBQztBQUN0RyxpREFBMEIsR0FBUSxnQkFBZ0IsQ0FBQyxrREFBa0QsQ0FBQyxDQUFDO0FBQ3ZHLGlEQUEwQixHQUFRLGdCQUFnQixDQUFDLGtEQUFrRCxDQUFDLENBQUM7QUFDdkcsdURBQWdDLEdBQUcsZ0JBQWdCLENBQUMsdURBQXVELENBQUMsQ0FBQztBQUM3RyxxREFBOEIsR0FBSyxnQkFBZ0IsQ0FBQyxxREFBcUQsQ0FBQyxDQUFDO0FBQzNHLHNEQUErQixHQUFJLGdCQUFnQixDQUFDLHNEQUFzRCxDQUFDLENBQUM7QUFDNUcsc0RBQStCLEdBQUksZ0JBQWdCLENBQUMsc0RBQXNELENBQUMsQ0FBQztBQW1CckksU0FBUyxnQkFBZ0IsQ0FBQyxJQUFZO0lBQ3BDLE9BQU87UUFDTCxvQkFBb0IsRUFBRSxJQUFJO1FBQzFCLG1CQUFtQixFQUFFLDhCQUFzQixDQUFDLElBQUksQ0FBQztLQUNsRCxDQUFDO0FBQ0osQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNkayBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IGFybkZvckRlcGxveW1lbnRDb25maWcgfSBmcm9tICcuLi91dGlscyc7XG5cbi8qKlxuICogVGhlIERlcGxveW1lbnQgQ29uZmlndXJhdGlvbiBvZiBhIExhbWJkYSBEZXBsb3ltZW50IEdyb3VwLlxuICogVGhlIGRlZmF1bHQsIHByZS1kZWZpbmVkIENvbmZpZ3VyYXRpb25zIGFyZSBhdmFpbGFibGUgYXMgY29uc3RhbnRzIG9uIHRoZSB7QGxpbmsgTGFtYmRhRGVwbG95bWVudENvbmZpZ30gY2xhc3NcbiAqIChgTGFtYmRhRGVwbG95bWVudENvbmZpZy5BbGxBdE9uY2VgLCBgTGFtYmRhRGVwbG95bWVudENvbmZpZy5DYW5hcnkxMFBlcmNlbnQzME1pbnV0ZXNgLCBldGMuKS5cbiAqXG4gKiBOb3RlOiBDbG91ZEZvcm1hdGlvbiBkb2VzIG5vdCBjdXJyZW50bHkgc3VwcG9ydCBjcmVhdGluZyBjdXN0b20gbGFtYmRhIGNvbmZpZ3Mgb3V0c2lkZVxuICogb2YgdXNpbmcgYSBjdXN0b20gcmVzb3VyY2UuIFlvdSBjYW4gaW1wb3J0IGN1c3RvbSBkZXBsb3ltZW50IGNvbmZpZyBjcmVhdGVkIG91dHNpZGUgdGhlXG4gKiBDREsgb3IgdmlhIGEgY3VzdG9tIHJlc291cmNlIHdpdGgge0BsaW5rIExhbWJkYURlcGxveW1lbnRDb25maWcjaW1wb3J0fS5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBJTGFtYmRhRGVwbG95bWVudENvbmZpZyB7XG4gIHJlYWRvbmx5IGRlcGxveW1lbnRDb25maWdOYW1lOiBzdHJpbmc7XG4gIHJlYWRvbmx5IGRlcGxveW1lbnRDb25maWdBcm46IHN0cmluZztcbn1cblxuLyoqXG4gKiBQcm9wZXJ0aWVzIG9mIGEgcmVmZXJlbmNlIHRvIGEgQ29kZURlcGxveSBMYW1iZGEgRGVwbG95bWVudCBDb25maWd1cmF0aW9uLlxuICpcbiAqIEBzZWUgTGFtYmRhRGVwbG95bWVudENvbmZpZyNpbXBvcnRcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBMYW1iZGFEZXBsb3ltZW50Q29uZmlnSW1wb3J0UHJvcHMge1xuICAvKipcbiAgICogVGhlIHBoeXNpY2FsLCBodW1hbi1yZWFkYWJsZSBuYW1lIG9mIHRoZSBjdXN0b20gQ29kZURlcGxveSBMYW1iZGEgRGVwbG95bWVudCBDb25maWd1cmF0aW9uXG4gICAqIHRoYXQgd2UgYXJlIHJlZmVyZW5jaW5nLlxuICAgKi9cbiAgcmVhZG9ubHkgZGVwbG95bWVudENvbmZpZ05hbWU6IHN0cmluZztcbn1cblxuLyoqXG4gKiBBIGN1c3RvbSBEZXBsb3ltZW50IENvbmZpZ3VyYXRpb24gZm9yIGEgTGFtYmRhIERlcGxveW1lbnQgR3JvdXAuXG4gKlxuICogTm90ZTogVGhpcyBjbGFzcyBjdXJyZW50bHkgc3RhbmRzIGFzIG5hbWVzcGFjZWQgY29udGFpbmVyIG9mIHRoZSBkZWZhdWx0IGNvbmZpZ3VyYXRpb25zXG4gKiB1bnRpbCBDbG91ZEZvcm1hdGlvbiBzdXBwb3J0cyBjdXN0b20gTGFtYmRhIERlcGxveW1lbnQgQ29uZmlncy4gVW50aWwgdGhlbiBpdCBpcyBjbG9zZWRcbiAqIChwcml2YXRlIGNvbnN0cnVjdG9yKSBhbmQgZG9lcyBub3QgZXh0ZW5kIHtAbGluayBjZGsuQ29uc3RydWN0fVxuICpcbiAqIEByZXNvdXJjZSBBV1M6OkNvZGVEZXBsb3k6OkRlcGxveW1lbnRDb25maWdcbiAqL1xuZXhwb3J0IGNsYXNzIExhbWJkYURlcGxveW1lbnRDb25maWcge1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEFMTF9BVF9PTkNFICAgICAgICAgICAgICAgICAgICAgPSBkZXBsb3ltZW50Q29uZmlnKCdDb2RlRGVwbG95RGVmYXVsdC5MYW1iZGFBbGxBdE9uY2UnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBDQU5BUllfMTBQRVJDRU5UXzMwTUlOVVRFUyAgICAgID0gZGVwbG95bWVudENvbmZpZygnQ29kZURlcGxveURlZmF1bHQuTGFtYmRhQ2FuYXJ5MTBQZXJjZW50MzBNaW51dGVzJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQ0FOQVJZXzEwUEVSQ0VOVF81TUlOVVRFUyAgICAgICA9IGRlcGxveW1lbnRDb25maWcoJ0NvZGVEZXBsb3lEZWZhdWx0LkxhbWJkYUNhbmFyeTEwUGVyY2VudDVNaW51dGVzJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQ0FOQVJZXzEwUEVSQ0VOVF8xME1JTlVURVMgICAgICA9IGRlcGxveW1lbnRDb25maWcoJ0NvZGVEZXBsb3lEZWZhdWx0LkxhbWJkYUNhbmFyeTEwUGVyY2VudDEwTWludXRlcycpO1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENBTkFSWV8xMFBFUkNFTlRfMTVNSU5VVEVTICAgICAgPSBkZXBsb3ltZW50Q29uZmlnKCdDb2RlRGVwbG95RGVmYXVsdC5MYW1iZGFDYW5hcnkxMFBlcmNlbnQxNU1pbnV0ZXMnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBMSU5FQVJfMTBQRVJDRU5UX0VWRVJZXzEwTUlOVVRFUyA9IGRlcGxveW1lbnRDb25maWcoJ0NvZGVEZXBsb3lEZWZhdWx0LkxhbWJkYUxpbmVhcjEwUGVyY2VudEV2ZXJ5MTBNaW51dGVzJyk7XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgTElORUFSXzEwUEVSQ0VOVF9FVkVSWV8xTUlOVVRFICAgPSBkZXBsb3ltZW50Q29uZmlnKCdDb2RlRGVwbG95RGVmYXVsdC5MYW1iZGFMaW5lYXIxMFBlcmNlbnRFdmVyeTFNaW51dGUnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBMSU5FQVJfMTBQRVJDRU5UX0VWRVJZXzJNSU5VVEVTICA9IGRlcGxveW1lbnRDb25maWcoJ0NvZGVEZXBsb3lEZWZhdWx0LkxhbWJkYUxpbmVhcjEwUGVyY2VudEV2ZXJ5Mk1pbnV0ZXMnKTtcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBMSU5FQVJfMTBQRVJDRU5UX0VWRVJZXzNNSU5VVEVTICA9IGRlcGxveW1lbnRDb25maWcoJ0NvZGVEZXBsb3lEZWZhdWx0LkxhbWJkYUxpbmVhcjEwUGVyY2VudEV2ZXJ5M01pbnV0ZXMnKTtcblxuICAvKipcbiAgICogSW1wb3J0IGEgY3VzdG9tIERlcGxveW1lbnQgQ29uZmlndXJhdGlvbiBmb3IgYSBMYW1iZGEgRGVwbG95bWVudCBHcm91cCBkZWZpbmVkIG91dHNpZGUgdGhlIENESy5cbiAgICpcbiAgICogQHBhcmFtIF9zY29wZSB0aGUgcGFyZW50IENvbnN0cnVjdCBmb3IgdGhpcyBuZXcgQ29uc3RydWN0XG4gICAqIEBwYXJhbSBfaWQgdGhlIGxvZ2ljYWwgSUQgb2YgdGhpcyBuZXcgQ29uc3RydWN0XG4gICAqIEBwYXJhbSBwcm9wcyB0aGUgcHJvcGVydGllcyBvZiB0aGUgcmVmZXJlbmNlZCBjdXN0b20gRGVwbG95bWVudCBDb25maWd1cmF0aW9uXG4gICAqIEByZXR1cm5zIGEgQ29uc3RydWN0IHJlcHJlc2VudGluZyBhIHJlZmVyZW5jZSB0byBhbiBleGlzdGluZyBjdXN0b20gRGVwbG95bWVudCBDb25maWd1cmF0aW9uXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGltcG9ydChfc2NvcGU6IGNkay5Db25zdHJ1Y3QsIF9pZDogc3RyaW5nLCBwcm9wczogTGFtYmRhRGVwbG95bWVudENvbmZpZ0ltcG9ydFByb3BzKTogSUxhbWJkYURlcGxveW1lbnRDb25maWcge1xuICAgIHJldHVybiBkZXBsb3ltZW50Q29uZmlnKHByb3BzLmRlcGxveW1lbnRDb25maWdOYW1lKTtcbiAgfVxuXG4gIHByaXZhdGUgY29uc3RydWN0b3IoKSB7XG4gICAgLy8gbm90aGluZyB0byBkbyB1bnRpbCBDRk4gc3VwcG9ydHMgY3VzdG9tIGxhbWJkYSBkZXBsb3ltZW50IGNvbmZpZ3VyYXRpb25zXG4gIH1cbn1cblxuZnVuY3Rpb24gZGVwbG95bWVudENvbmZpZyhuYW1lOiBzdHJpbmcpOiBJTGFtYmRhRGVwbG95bWVudENvbmZpZyB7XG4gIHJldHVybiB7XG4gICAgZGVwbG95bWVudENvbmZpZ05hbWU6IG5hbWUsXG4gICAgZGVwbG95bWVudENvbmZpZ0FybjogYXJuRm9yRGVwbG95bWVudENvbmZpZyhuYW1lKVxuICB9O1xufVxuIl19