import * as lambda from '@aws-cdk/aws-lambda';
import * as sns from '@aws-cdk/aws-sns';
import { SubscriptionProps } from './subscription';
/**
 * Properties for a Lambda subscription
 */
export interface LambdaSubscriptionProps extends SubscriptionProps {
}
/**
 * Use a Lambda function as a subscription target
 */
export declare class LambdaSubscription implements sns.ITopicSubscription {
    private readonly fn;
    private readonly props;
    constructor(fn: lambda.IFunction, props?: LambdaSubscriptionProps);
    bind(topic: sns.ITopic): sns.TopicSubscriptionConfig;
}
