"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Choice = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const chain_1 = require("../chain");
const state_type_1 = require("./private/state-type");
const state_1 = require("./state");
/**
 * Define a Choice in the state machine
 *
 * A choice state can be used to make decisions based on the execution
 * state.
 */
class Choice extends state_1.State {
    constructor(scope, id, props = {}) {
        super(scope, id, props);
        this.endStates = [];
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_ChoiceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
    /**
     * If the given condition matches, continue execution with the given state
     */
    when(condition, next) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_Condition(condition);
            jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_IChainable(next);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.when);
            }
            throw error;
        }
        super.addChoice(condition, next.startState);
        return this;
    }
    /**
     * If none of the given conditions match, continue execution with the given state
     *
     * If no conditions match and no otherwise() has been given, an execution
     * error will be raised.
     */
    otherwise(def) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_IChainable(def);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.otherwise);
            }
            throw error;
        }
        super.makeDefault(def.startState);
        return this;
    }
    /**
     * Return a Chain that contains all reachable end states from this Choice
     *
     * Use this to combine all possible choice paths back.
     */
    afterwards(options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_AfterwardsOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.afterwards);
            }
            throw error;
        }
        const endStates = state_1.State.filterNextables(state_1.State.findReachableEndStates(this, { includeErrorHandlers: options.includeErrorHandlers }));
        if (options.includeOtherwise && this.defaultChoice) {
            throw new Error(`'includeOtherwise' set but Choice state ${this.stateId} already has an 'otherwise' transition`);
        }
        if (options.includeOtherwise) {
            endStates.push(new DefaultAsNext(this));
        }
        return chain_1.Chain.custom(this, endStates, this);
    }
    /**
     * Return the Amazon States Language object for this state
     */
    toStateJson() {
        return {
            Type: state_type_1.StateType.CHOICE,
            Comment: this.comment,
            ...this.renderInputOutput(),
            ...this.renderChoices(),
        };
    }
}
exports.Choice = Choice;
_a = JSII_RTTI_SYMBOL_1;
Choice[_a] = { fqn: "@aws-cdk/aws-stepfunctions.Choice", version: "1.157.0" };
/**
 * Adapter to make the .otherwise() transition settable through .next()
 */
class DefaultAsNext {
    constructor(choice) {
        this.choice = choice;
    }
    next(state) {
        this.choice.otherwise(state);
        return chain_1.Chain.sequence(this.choice, state);
    }
}
//# sourceMappingURL=data:application/json;base64,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