# generated by datamodel-codegen:
#   filename:  openapi.json
#   timestamp: 2022-12-01T16:10:55+00:00

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Any, Dict, List, Optional

from pydantic import BaseModel, Field, constr


class AccessTypes(Enum):
    Unknown = 'Unknown'
    All = 'All'
    Owner = 'Owner'
    Read = 'Read'
    ReadMetadata = 'ReadMetadata'
    Write = 'Write'
    Create = 'Create'
    Delete = 'Delete'
    Execute = 'Execute'
    Enable = 'Enable'
    Assign = 'Assign'
    Restore = 'Restore'
    Import = 'Import'
    Export = 'Export'
    Get = 'Get'
    Set = 'Set'
    Update = 'Update'
    Cancel = 'Cancel'
    Use = 'Use'
    AllowUse = 'AllowUse'
    List = 'List'
    Administrative = 'Administrative'
    Delegate = 'Delegate'
    Join = 'Join'
    Invite = 'Invite'
    Leave = 'Leave'
    Share = 'Share'


class AccountsAssociationSchema(BaseModel):
    sourceId: constr(min_length=1) = Field(
        ..., description='Source account ID **Mandatory**\n', title='Sourceid'
    )
    targetId: constr(min_length=1) = Field(
        ...,
        description='Target grouping ID to associate with  **Mandatory**.\n',
        title='Targetid',
    )


class AssetInheritanceSchema(BaseModel):
    sourceId: constr(min_length=1) = Field(
        ..., description='ID of the source asset. **Mandatory**\n', title='Sourceid'
    )
    targetId: constr(min_length=1) = Field(
        ...,
        description='The ID of the iherited asset (or assets). **Mandatory**\n',
        title='Targetid',
    )


class AssetType(Enum):
    Application = 'Application'
    Database = 'Database'
    Drive = 'Drive'
    File = 'File'
    Folder = 'Folder'
    GitRepository = 'GitRepository'
    Integration = 'Integration'
    Project = 'Project'
    Site = 'Site'
    Table = 'Table'
    Ticket = 'Ticket'
    VirtualMachine = 'VirtualMachine'
    Other = 'Other'


class AssetTypes(Enum):
    Resource = 'Resource'
    File = 'File'
    Folder = 'Folder'
    Drive = 'Drive'
    Site = 'Site'
    Application = 'Application'
    Integration = 'Integration'
    Package = 'Package'
    Project = 'Project'
    Cluster = 'Cluster'
    Dataset = 'Dataset'
    Subscription = 'Subscription'
    Table = 'Table'
    TableRecord = 'TableRecord'
    Disk = 'Disk'
    Image = 'Image'
    Instance = 'Instance'
    Snapshot = 'Snapshot'
    Service = 'Service'
    Topic = 'Topic'
    Bucket = 'Bucket'
    BillingAccount = 'BillingAccount'
    Device = 'Device'
    Calendar = 'Calendar'
    Policy = 'Policy'
    GitRepository = 'GitRepository'
    Network = 'Network'
    Vpc = 'Vpc'
    NetworkInterface = 'NetworkInterface'
    VirtualMachine = 'VirtualMachine'
    NetworkSecurityGroup = 'NetworkSecurityGroup'
    Ticket = 'Ticket'
    NetworkSubnet = 'NetworkSubnet'
    NetworkAcl = 'NetworkAcl'
    RouteTable = 'RouteTable'
    NetworkAddress = 'NetworkAddress'
    Secret = 'Secret'
    Storage = 'Storage'
    Workspace = 'Workspace'
    SharedLink = 'SharedLink'
    Collection = 'Collection'
    Database = 'Database'
    ServerlessFunction = 'ServerlessFunction'
    ServerlessApplication = 'ServerlessApplication'
    Gateway = 'Gateway'
    ImageRepository = 'ImageRepository'
    Resource_BusinessAccount = 'Resource_BusinessAccount'
    LoadBalancer = 'LoadBalancer'
    Listener = 'Listener'


class AssetsInheritance(BaseModel):
    fromId: str = Field(..., title='Fromid')
    toId: str = Field(..., title='Toid')


class AvailableConnectorId(Enum):
    restApiImport = 'restApiImport'


class ConnectorStatus(Enum):
    initializing = 'initializing'
    validating = 'validating'
    failure = 'failure'
    enabled = 'enabled'
    installable = 'installable'
    archived = 'archived'
    disabled = 'disabled'
    deleted = 'deleted'


class ExportResponse(BaseModel):
    exportId: str = Field(..., title='Exportid')
    exportUrl: str = Field(..., title='Exporturl')


class GroupingType(Enum):
    Group = 'Group'
    VirtualGroup = 'VirtualGroup'


class GroupingsAssociationSchema(BaseModel):
    sourceId: constr(min_length=1) = Field(
        ..., description='Grouping source ID **Mandatory**\n', title='Sourceid'
    )
    targetId: constr(min_length=1) = Field(
        ...,
        description='Grouping Target ID  **Mandatory**. The grouping to associate with.\n',
        title='Targetid',
    )


class IdentitiesInheritance(BaseModel):
    fromId: str = Field(..., title='Fromid')
    toId: str = Field(..., title='Toid')


class IdentityTypes(Enum):
    Identity = 'Identity'
    Person = 'Person'
    User = 'User'
    Group = 'Group'
    EntitlementProxy = 'EntitlementProxy'
    AccessKey = 'AccessKey'
    ServiceAccount = 'ServiceAccount'
    Alias = 'Alias'
    Domain = 'Domain'
    Organization = 'Organization'
    TaskPerformer = 'TaskPerformer'
    BusinessAccount = 'BusinessAccount'


class IsAliveResponse(BaseModel):
    isAlive: bool = Field(..., description='**isAlive**', title='Isalive')


class MeResponse(BaseModel):
    version: str = Field(..., description='**version**', title='Version')
    id: str = Field(..., description='**id**', title='Id')
    tenant: str = Field(..., description='**tenant**', title='Tenant')


class NewAccountsAssociationRequestSchema(BaseModel):
    sourceId: constr(min_length=1) = Field(
        ..., description='Source account ID **Mandatory**\n', title='Sourceid'
    )
    targetId: constr(min_length=1) = Field(
        ...,
        description='Target grouping ID to associate with  **Mandatory**.\n',
        title='Targetid',
    )


class NewAccountsAssociationResponseDataSchema(BaseModel):
    validSourceIds: List[str] = Field(
        ..., description='List of **valid** source account ids.', title='Validsourceids'
    )
    validTargetIds: List[str] = Field(
        ...,
        description='List of **valid** target grouping ids.',
        title='Validtargetids',
    )
    invalidSourceIds: List[str] = Field(
        ...,
        description='List of **invalid** source account ids.',
        title='Invalidsourceids',
    )
    invalidTargetIds: List[str] = Field(
        ...,
        description='List of **invalid** target grouping ids.',
        title='Invalidtargetids',
    )


class NewAccountsAssociationResponseSchema(BaseModel):
    acceptedTimestamp: Optional[datetime] = Field(
        None,
        description='**The accepted time of the request**',
        title='Acceptedtimestamp',
    )
    requestId: str = Field(..., description='**Request id**', title='Requestid')
    numberOfAcceptedEntities: int = Field(
        ...,
        description='**The number of entities that pass validation and uploaded**',
        title='Numberofacceptedentities',
    )
    data: Optional[NewAccountsAssociationResponseDataSchema] = Field(
        {}, description='Response data.', title='Data'
    )


class NewAccountsAssociationsListRequestSchema(BaseModel):
    data: List[NewAccountsAssociationRequestSchema] = Field(
        ...,
        description='New Accounts Associations',
        max_items=10000,
        min_items=1,
        title='Data',
    )


class NewAssetInheritanceRequestSchema(BaseModel):
    sourceId: constr(min_length=1) = Field(
        ..., description='ID of the source asset. **Mandatory**\n', title='Sourceid'
    )
    targetId: constr(min_length=1) = Field(
        ...,
        description='The ID of the iherited asset (or assets). **Mandatory**\n',
        title='Targetid',
    )


class NewAssetRequestSchema(BaseModel):
    uniqueId: constr(min_length=1) = Field(
        ..., description='Asset ID. **Mandatory, must be unique.**\n', title='Uniqueid'
    )
    originId: Optional[constr(min_length=1)] = Field(
        None,
        description="The asset ID in the source system.\nAs opposed to `uniqueId`, it's not mandatory and can be non-unique\n",
        title='Originid',
    )
    name: constr(min_length=1) = Field(
        ...,
        description='The name of the asset. The default is the Asset ID. **Mandatory**\n',
        title='Name',
    )
    type: Optional[AssetType] = Field(
        'Other',
        description='The asset types that are supported by Authomize **Mandatory**\n\nPermitted values:\n\n   •\t`Application` (federation) \n   •\t`Database`\n   •\t`Drive`\n   •\t`File`\n   •\t`Folder`\n   •\t`Git Repository`\n   •\t`Integration`\n   •\t`Project`\n   •\t`Site`\n   •\t`Table`\n   •\t`Ticket`\n   •\t`Virtual Machine`\n   •\t`Other`\n\nIf the asset type does not exist use `Other`.\n',
    )
    originType: Optional[str] = Field(
        None,
        description='The asset type in the source system.\nThe default is the canonical type (if not mentioned).\n',
        title='Origintype',
    )
    createdAt: Optional[datetime] = Field(
        None,
        description='The date (in ISO 8601 format) that the asset was created.\nThe default is `null`.\n',
        title='Createdat',
    )
    lastUsedAt: Optional[datetime] = Field(
        None,
        description='The date (in ISO 8601 format) of the last time that the asset was in use.\nThe default is `null`.\n',
        title='Lastusedat',
    )
    description: Optional[str] = Field(
        None,
        description='A description of the asset (up to 512 characters).\n',
        title='Description',
    )
    href: Optional[str] = Field(
        None, description='A link to the asset in the source system.\n', title='Href'
    )
    tags: Optional[List[constr(min_length=1)]] = Field(
        None, description='Tags associated with the asset.\n', title='Tags'
    )


class NewAssetsInheritanceListRequestSchema(BaseModel):
    data: List[NewAssetInheritanceRequestSchema] = Field(
        ...,
        description='New Assets Inheritance',
        max_items=10000,
        min_items=1,
        title='Data',
    )


class NewAssetsInheritanceResponseDataSchema(BaseModel):
    validSourceIds: List[str] = Field(
        ..., description='List of **valid** source assets ids.', title='Validsourceids'
    )
    validTargetIds: List[str] = Field(
        ..., description='List of **valid** target assets ids.', title='Validtargetids'
    )
    invalidSourceIds: List[str] = Field(
        ...,
        description='List of **invalid** source assets ids.',
        title='Invalidsourceids',
    )
    invalidTargetIds: List[str] = Field(
        ...,
        description='List of **invalid** target assets ids.',
        title='Invalidtargetids',
    )


class NewAssetsInheritanceResponseSchema(BaseModel):
    acceptedTimestamp: Optional[datetime] = Field(
        None,
        description='**The accepted time of the request**',
        title='Acceptedtimestamp',
    )
    requestId: str = Field(..., description='**Request id**', title='Requestid')
    numberOfAcceptedEntities: int = Field(
        ...,
        description='**The number of entities that pass validation and uploaded**',
        title='Numberofacceptedentities',
    )
    data: Optional[NewAssetsInheritanceResponseDataSchema] = Field(
        {}, description='Response data.', title='Data'
    )


class NewAssetsListRequestSchema(BaseModel):
    data: List[NewAssetRequestSchema] = Field(
        ..., description='New Assets', max_items=10000, min_items=1, title='Data'
    )


class NewAssetsResponseSchema(BaseModel):
    acceptedTimestamp: Optional[datetime] = Field(
        None,
        description='**The accepted time of the request**',
        title='Acceptedtimestamp',
    )
    requestId: str = Field(..., description='**Request id**', title='Requestid')
    numberOfAcceptedEntities: int = Field(
        ...,
        description='**The number of entities that pass validation and uploaded**',
        title='Numberofacceptedentities',
    )
    data: Optional[Any] = Field({}, description='Response data.', title='Data')


class NewGroupingRequestSchema(BaseModel):
    uniqueId: constr(min_length=1) = Field(
        ...,
        description='\nGrouping ID. **Mandatory, must be unique.**\n',
        title='Uniqueid',
    )
    originId: Optional[constr(min_length=1)] = Field(
        None,
        description="The groupping ID in the source system.\nAs opposed to `uniqueId`, it's not mandatory and can be non-unique\n",
        title='Originid',
    )
    name: constr(min_length=1) = Field(
        ...,
        description='The name of the grouping. The default is the ID field. **Mandatory**\n',
        title='Name',
    )
    originType: Optional[str] = Field(
        None,
        description='The name of the type of grouping in the source system. The default is `Group`. Example: Group/Alias/AWS Role\n',
        title='Origintype',
    )
    type: Optional[GroupingType] = Field(
        'Group',
        description='Allowed values are `Group` and `VirtualGroup`.\n\nThe default is `Group`.\n\n`VirtualGroup` are mapped to the Authomize access explorer graph and are not present in other places in the user interface nor are they counted as a group.\n',
    )
    isRole: Optional[bool] = Field(
        False,
        description='If `Role`, the grouping represents a role in the source application and the name of the role is the grouping `name`.\n\nThe default is `False`.\n',
        title='Isrole',
    )
    anyoneCanJoinOrLeave: Optional[bool] = Field(
        False,
        description="Must be either `ture` or `false`.\nWhen set to `true` users can give themselves membership in this grouping without the grouping's managers' or owners' permission. \nExamples include public groups (M365), Google Groups with specific flags, ...\nValid only when `groupingType = Group`\n",
        title='Anyonecanjoinorleave',
    )
    tags: Optional[List[constr(min_length=1)]] = Field(
        None, description='Tags on the access grouping.\n', title='Tags'
    )


class NewGroupingResponseSchema(BaseModel):
    acceptedTimestamp: Optional[datetime] = Field(
        None,
        description='**The accepted time of the request**',
        title='Acceptedtimestamp',
    )
    requestId: str = Field(..., description='**Request id**', title='Requestid')
    numberOfAcceptedEntities: int = Field(
        ...,
        description='**The number of entities that pass validation and uploaded**',
        title='Numberofacceptedentities',
    )
    data: Optional[Any] = Field({}, description='Response data.', title='Data')


class NewGroupingsAssociationRequestSchema(BaseModel):
    sourceId: constr(min_length=1) = Field(
        ..., description='Grouping source ID **Mandatory**\n', title='Sourceid'
    )
    targetId: constr(min_length=1) = Field(
        ...,
        description='Grouping Target ID  **Mandatory**. The grouping to associate with.\n',
        title='Targetid',
    )


class NewGroupingsAssociationResponseDataSchema(BaseModel):
    validSourceIds: List[str] = Field(
        ...,
        description='List of **valid** source grouping ids.',
        title='Validsourceids',
    )
    validTargetIds: List[str] = Field(
        ...,
        description='List of **valid** target grouping ids.',
        title='Validtargetids',
    )
    invalidSourceIds: List[str] = Field(
        ...,
        description='List of **invalid** source grouping ids.',
        title='Invalidsourceids',
    )
    invalidTargetIds: List[str] = Field(
        ...,
        description='List of **invalid** target grouping ids.',
        title='Invalidtargetids',
    )


class NewGroupingsAssociationResponseSchema(BaseModel):
    acceptedTimestamp: Optional[datetime] = Field(
        None,
        description='**The accepted time of the request**',
        title='Acceptedtimestamp',
    )
    requestId: str = Field(..., description='**Request id**', title='Requestid')
    numberOfAcceptedEntities: int = Field(
        ...,
        description='**The number of entities that pass validation and uploaded**',
        title='Numberofacceptedentities',
    )
    data: Optional[NewGroupingsAssociationResponseDataSchema] = Field(
        {}, description='Response data.', title='Data'
    )


class NewGroupingsAssociationsListRequestSchema(BaseModel):
    data: List[NewGroupingsAssociationRequestSchema] = Field(
        ...,
        description='New Groupings Associations',
        max_items=10000,
        min_items=1,
        title='Data',
    )


class NewGroupingsListRequestSchema(BaseModel):
    data: List[NewGroupingRequestSchema] = Field(
        ..., description='New Groupings', max_items=10000, min_items=1, title='Data'
    )


class NewIdentityResponseSchema(BaseModel):
    acceptedTimestamp: Optional[datetime] = Field(
        None,
        description='**The accepted time of the request**',
        title='Acceptedtimestamp',
    )
    requestId: str = Field(..., description='**Request id**', title='Requestid')
    numberOfAcceptedEntities: int = Field(
        ...,
        description='**The number of entities that pass validation and uploaded**',
        title='Numberofacceptedentities',
    )
    data: Optional[Any] = Field({}, description='Response data.', title='Data')


class NewPermissionsResponseDataSchema(BaseModel):
    validUserIds: List[str] = Field(
        ..., description='List of **valid** user ids.', title='Validuserids'
    )
    validGroupingIds: List[str] = Field(
        ..., description='List of **valid** grouping ids.', title='Validgroupingids'
    )
    validAssetIds: List[str] = Field(
        ..., description='List of **valid** asset ids.', title='Validassetids'
    )
    validPrivilegeIds: List[str] = Field(
        ..., description='List of **valid** privilege ids.', title='Validprivilegeids'
    )
    invalidUserIds: List[str] = Field(
        ..., description='List of **invalid** user ids.', title='Invaliduserids'
    )
    invalidGroupingIds: List[str] = Field(
        ..., description='List of **invalid** grouping ids.', title='Invalidgroupingids'
    )
    invalidAssetIds: List[str] = Field(
        ..., description='List of **invalid** asset ids.', title='Invalidassetids'
    )
    invalidPrivilegeIds: List[str] = Field(
        ...,
        description='List of **invalid** privilege ids.',
        title='Invalidprivilegeids',
    )


class NewPermissionsResponseSchema(BaseModel):
    acceptedTimestamp: Optional[datetime] = Field(
        None,
        description='**The accepted time of the request**',
        title='Acceptedtimestamp',
    )
    requestId: str = Field(..., description='**Request id**', title='Requestid')
    numberOfAcceptedEntities: int = Field(
        ...,
        description='**The number of entities that pass validation and uploaded**',
        title='Numberofacceptedentities',
    )
    data: Optional[NewPermissionsResponseDataSchema] = Field(
        {}, description='Response data.', title='Data'
    )


class NewPrivilegeGrantsRequestSchema(BaseModel):
    sourceId: constr(min_length=1) = Field(
        ..., description='ID of the source privilege. **Mandatory**\n', title='Sourceid'
    )
    targetId: constr(min_length=1) = Field(
        ...,
        description='ID of the granted privilege. **Mandatory**\n',
        title='Targetid',
    )


class NewPrivilegeGrantsResponseDataSchema(BaseModel):
    validSourceIds: List[str] = Field(
        ...,
        description='List of **valid** source privilege ids.',
        title='Validsourceids',
    )
    validTargetIds: List[str] = Field(
        ...,
        description='List of **valid** target privilege ids.',
        title='Validtargetids',
    )
    invalidSourceIds: List[str] = Field(
        ...,
        description='List of **invalid** source privilege ids.',
        title='Invalidsourceids',
    )
    invalidTargetIds: List[str] = Field(
        ...,
        description='List of **invalid** target privilege ids.',
        title='Invalidtargetids',
    )


class NewPrivilegeGrantsResponseSchema(BaseModel):
    acceptedTimestamp: Optional[datetime] = Field(
        None,
        description='**The accepted time of the request**',
        title='Acceptedtimestamp',
    )
    requestId: str = Field(..., description='**Request id**', title='Requestid')
    numberOfAcceptedEntities: int = Field(
        ...,
        description='**The number of entities that pass validation and uploaded**',
        title='Numberofacceptedentities',
    )
    data: Optional[NewPrivilegeGrantsResponseDataSchema] = Field(
        {}, description='Response data.', title='Data'
    )


class NewPrivilegesGrantsListRequestSchema(BaseModel):
    data: List[NewPrivilegeGrantsRequestSchema] = Field(
        ...,
        description='New Privileges Grants',
        max_items=10000,
        min_items=1,
        title='Data',
    )


class NewPrivilegesResponseSchema(BaseModel):
    acceptedTimestamp: Optional[datetime] = Field(
        None,
        description='**The accepted time of the request**',
        title='Acceptedtimestamp',
    )
    requestId: str = Field(..., description='**Request id**', title='Requestid')
    numberOfAcceptedEntities: int = Field(
        ...,
        description='**The number of entities that pass validation and uploaded**',
        title='Numberofacceptedentities',
    )
    data: Optional[Any] = Field({}, description='Response data.', title='Data')


class NewRestApiConnectorSchema(BaseModel):
    config: Optional[Dict[str, Any]] = Field(None, title='Config')
    serviceId: constr(min_length=1) = Field(..., title='Serviceid')


class NewUserResponseSchema(BaseModel):
    acceptedTimestamp: Optional[datetime] = Field(
        None,
        description='**The accepted time of the request**',
        title='Acceptedtimestamp',
    )
    requestId: str = Field(..., description='**Request id**', title='Requestid')
    numberOfAcceptedEntities: int = Field(
        ...,
        description='**The number of entities that pass validation and uploaded**',
        title='Numberofacceptedentities',
    )
    data: Optional[Any] = Field({}, description='Response data.', title='Data')


class Pagination(BaseModel):
    limit: Optional[int] = Field(-1, title='Limit')
    skip: Optional[int] = Field(0, title='Skip')
    total: Optional[int] = Field(-1, title='Total')
    hasMore: Optional[bool] = Field(None, title='Hasmore')


class PermissionSourceType(Enum):
    User = 'User'
    Grouping = 'Grouping'


class PrivilegeGrantSchema(BaseModel):
    sourceId: constr(min_length=1) = Field(
        ..., description='ID of the source privilege. **Mandatory**\n', title='Sourceid'
    )
    targetId: constr(min_length=1) = Field(
        ...,
        description='ID of the granted privilege. **Mandatory**\n',
        title='Targetid',
    )


class PrivilegeType(Enum):
    Administrative = 'Administrative'
    Unknown = 'Unknown'
    Read = 'Read'
    ReadMetadata = 'ReadMetadata'
    Write = 'Write'
    Create = 'Create'
    Delete = 'Delete'
    Execute = 'Execute'
    Enable = 'Enable'
    Assign = 'Assign'
    Restore = 'Restore'
    Import = 'Import'
    Export = 'Export'
    Update = 'Update'
    Cancel = 'Cancel'
    Use = 'Use'
    Delegate = 'Delegate'
    Join = 'Join'
    Invite = 'Invite'
    Share = 'Share'


class RequestSubmitResponse(BaseModel):
    acceptedTimestamp: Optional[datetime] = Field(
        None,
        description='**The accepted time of the request**',
        title='Acceptedtimestamp',
    )
    requestId: str = Field(..., description='**Request id**', title='Requestid')


class RestApiConnectorSchema(BaseModel):
    config: Optional[Dict[str, Any]] = Field(None, title='Config')
    serviceId: Optional[str] = Field('', title='Serviceid')
    id: str = Field(..., title='Id')
    createdAt: Optional[datetime] = Field(None, title='Createdat')
    lastSyncedAt: Optional[str] = Field(None, title='Lastsyncedat')
    lastError: Optional[str] = Field(None, title='Lasterror')
    modifiedAt: Optional[datetime] = Field(None, title='Modifiedat')
    status: Optional[ConnectorStatus] = 'disabled'
    serviceType: str = Field(..., title='Servicetype')
    availableConnectorId: Optional[AvailableConnectorId] = 'restApiImport'
    actorType: Optional[str] = Field(None, title='Actortype')
    actorId: Optional[str] = Field(None, title='Actorid')


class SearchAccountsAssociationsListResponseSchema(BaseModel):
    data: List[AccountsAssociationSchema] = Field(
        ..., description='Accounts Associations', title='Data'
    )


class SearchAssetsInheritanceListResponseSchema(BaseModel):
    data: List[AssetInheritanceSchema] = Field(
        ..., description='Assets Inheritance', title='Data'
    )


class SearchGroupingsAssociationsListResponseSchema(BaseModel):
    data: List[GroupingsAssociationSchema] = Field(
        ..., description='Groupings Associations', title='Data'
    )


class SearchPrivilegeGrantsListResponseSchema(BaseModel):
    data: List[PrivilegeGrantSchema] = Field(
        ..., description='Privilege Grants', title='Data'
    )


class ServiceDescription(BaseModel):
    name: str = Field(..., title='Name')
    icon: Optional[str] = Field(None, title='Icon')


class SubmitResponse(BaseModel):
    acceptedTimestamp: Optional[datetime] = Field(
        None,
        description='**The accepted time of the request**',
        title='Acceptedtimestamp',
    )


class TransactionStateType(Enum):
    Applying = 'Applying'
    Complete = 'Complete'
    Failed = 'Failed'
    Ingest = 'Ingest'
    IngestChunk = 'IngestChunk'
    PostProcess = 'PostProcess'
    Queue = 'Queue'


class UserStatus(Enum):
    Staged = 'Staged'
    Enabled = 'Enabled'
    Disabled = 'Disabled'
    Suspended = 'Suspended'
    Deleted = 'Deleted'
    Unknown = 'Unknown'


class ValidationError(BaseModel):
    loc: List[str] = Field(..., title='Location')
    msg: str = Field(..., title='Message')
    type: str = Field(..., title='Error Type')


class AccessDescription(BaseModel):
    fromIdentityId: str = Field(..., title='Fromidentityid')
    toAssetId: Optional[str] = Field(None, title='Toassetid')
    accessType: AccessTypes
    accessName: Optional[str] = Field(None, title='Accessname')


class AssetDescription(BaseModel):
    id: str = Field(..., title='Id')
    name: str = Field(..., title='Name')
    type: AssetTypes
    description: Optional[str] = Field(None, title='Description')
    logoUrl: Optional[str] = Field(None, title='Logourl')
    href: Optional[str] = Field(None, title='Href')
    createdAt: Optional[datetime] = Field(None, title='Createdat')
    isAuxiliary: Optional[bool] = Field(None, title='Isauxiliary')
    service: Optional[str] = Field(None, title='Service')
    isFederated: Optional[bool] = Field(None, title='Isfederated')


class AssetSchema(BaseModel):
    uniqueId: constr(min_length=1) = Field(
        ..., description='Asset ID. **Mandatory, must be unique.**\n', title='Uniqueid'
    )
    originId: Optional[constr(min_length=1)] = Field(
        None,
        description="The asset ID in the source system.\nAs opposed to `uniqueId`, it's not mandatory and can be non-unique\n",
        title='Originid',
    )
    name: constr(min_length=1) = Field(
        ...,
        description='The name of the asset. The default is the Asset ID. **Mandatory**\n',
        title='Name',
    )
    type: Optional[AssetType] = Field(
        'Other',
        description='The asset types that are supported by Authomize **Mandatory**\n\nPermitted values:\n\n   •\t`Application` (federation) \n   •\t`Database`\n   •\t`Drive`\n   •\t`File`\n   •\t`Folder`\n   •\t`Git Repository`\n   •\t`Integration`\n   •\t`Project`\n   •\t`Site`\n   •\t`Table`\n   •\t`Ticket`\n   •\t`Virtual Machine`\n   •\t`Other`\n\nIf the asset type does not exist use `Other`.\n',
    )
    originType: Optional[str] = Field(
        None,
        description='The asset type in the source system.\nThe default is the canonical type (if not mentioned).\n',
        title='Origintype',
    )
    createdAt: Optional[datetime] = Field(
        None,
        description='The date (in ISO 8601 format) that the asset was created.\nThe default is `null`.\n',
        title='Createdat',
    )
    lastUsedAt: Optional[datetime] = Field(
        None,
        description='The date (in ISO 8601 format) of the last time that the asset was in use.\nThe default is `null`.\n',
        title='Lastusedat',
    )
    description: Optional[str] = Field(
        None,
        description='A description of the asset (up to 512 characters).\n',
        title='Description',
    )
    href: Optional[str] = Field(
        None, description='A link to the asset in the source system.\n', title='Href'
    )
    tags: Optional[List[constr(min_length=1)]] = Field(
        None, description='Tags associated with the asset.\n', title='Tags'
    )


class BundleTransactionSchema(BaseModel):
    connectorId: str = Field(..., title='Connectorid')
    transactionCreatedAt: Optional[datetime] = Field(None, title='Transactioncreatedat')
    warnings: Optional[List[str]] = Field(None, title='Warnings')
    validations: Optional[Dict[str, Any]] = Field(None, title='Validations')
    id: str = Field(..., title='Id')
    state: TransactionStateType


class GroupingSchema(BaseModel):
    uniqueId: constr(min_length=1) = Field(
        ...,
        description='\nGrouping ID. **Mandatory, must be unique.**\n',
        title='Uniqueid',
    )
    originId: Optional[constr(min_length=1)] = Field(
        None,
        description="The groupping ID in the source system.\nAs opposed to `uniqueId`, it's not mandatory and can be non-unique\n",
        title='Originid',
    )
    name: constr(min_length=1) = Field(
        ...,
        description='The name of the grouping. The default is the ID field. **Mandatory**\n',
        title='Name',
    )
    originType: Optional[str] = Field(
        None,
        description='The name of the type of grouping in the source system. The default is `Group`. Example: Group/Alias/AWS Role\n',
        title='Origintype',
    )
    type: Optional[GroupingType] = Field(
        'Group',
        description='Allowed values are `Group` and `VirtualGroup`.\n\nThe default is `Group`.\n\n`VirtualGroup` are mapped to the Authomize access explorer graph and are not present in other places in the user interface nor are they counted as a group.\n',
    )
    isRole: Optional[bool] = Field(
        False,
        description='If `Role`, the grouping represents a role in the source application and the name of the role is the grouping `name`.\n\nThe default is `False`.\n',
        title='Isrole',
    )
    anyoneCanJoinOrLeave: Optional[bool] = Field(
        False,
        description="Must be either `ture` or `false`.\nWhen set to `true` users can give themselves membership in this grouping without the grouping's managers' or owners' permission. \nExamples include public groups (M365), Google Groups with specific flags, ...\nValid only when `groupingType = Group`\n",
        title='Anyonecanjoinorleave',
    )
    tags: Optional[List[constr(min_length=1)]] = Field(
        None, description='Tags on the access grouping.\n', title='Tags'
    )


class HTTPValidationError(BaseModel):
    detail: Optional[List[ValidationError]] = Field(None, title='Detail')


class IdentityDescription(BaseModel):
    id: str = Field(..., title='Id')
    name: Optional[str] = Field(None, title='Name')
    type: IdentityTypes
    userType: Optional[str] = Field(None, title='Usertype')
    email: Optional[str] = Field(None, title='Email')
    manager: Optional[str] = Field(None, title='Manager')
    title: Optional[str] = Field(None, title='Title')
    department: Optional[str] = Field(None, title='Department')
    description: Optional[str] = Field(None, title='Description')
    href: Optional[str] = Field(None, title='Href')
    createdAt: Optional[datetime] = Field(None, title='Createdat')
    terminationDate: Optional[datetime] = Field(None, title='Terminationdate')
    isExternal: Optional[bool] = Field(None, title='Isexternal')
    isAuxiliary: Optional[bool] = Field(None, title='Isauxiliary')
    hasTwoFactorAuthenticationEnabled: Optional[bool] = Field(
        None, title='Hastwofactorauthenticationenabled'
    )
    firstName: Optional[str] = Field(None, title='Firstname')
    lastName: Optional[str] = Field(None, title='Lastname')
    userName: Optional[str] = Field(None, title='Username')
    status: Optional[UserStatus] = None
    service: Optional[str] = Field(None, title='Service')
    lastLoginAt: Optional[datetime] = Field(None, title='Lastloginat')
    anyoneCanJoinOrLeave: Optional[bool] = Field(None, title='Anyonecanjoinorleave')
    tags: Optional[List[str]] = Field(None, title='Tags')
    city: Optional[str] = Field(None, title='City')
    country: Optional[str] = Field(None, title='Country')
    division: Optional[str] = Field(None, title='Division')
    employeeNumber: Optional[str] = Field(None, title='Employeenumber')
    personalEmail: Optional[str] = Field(None, title='Personalemail')
    hireDate: Optional[datetime] = Field(None, title='Hiredate')


class IdentitySchema(BaseModel):
    uniqueId: constr(min_length=1) = Field(
        ..., description='Identity ID **Mandatory**\n', title='Uniqueid'
    )
    originId: Optional[constr(min_length=1)] = Field(
        None,
        description="The identity ID in the source system.\nAs opposed to `uniqueId`, it's not mandatory and can be non-unique\n",
        title='Originid',
    )
    name: Optional[str] = Field(None, description='Username', title='Name')
    email: Optional[str] = Field(
        None, description="User's work email address.\n", title='Email'
    )
    personalEmail: Optional[str] = Field(
        None, description="User's personal email address.\n", title='Personalemail'
    )
    firstName: Optional[str] = Field(
        None, description="User's first name\n", title='Firstname'
    )
    lastName: Optional[str] = Field(
        None, description="The user's last name.\n", title='Lastname'
    )
    employeeNumber: Optional[str] = Field(
        None, description='Employee number', title='Employeenumber'
    )
    status: Optional[UserStatus] = Field(
        None,
        description='The user status must be one of the following: `Deleted`, `Disabled`, `Enabled`, `Staged` or `Suspended`.\n',
    )
    country: Optional[str] = Field(None, description='Country', title='Country')
    city: Optional[str] = Field(None, description='City', title='City')
    department: Optional[str] = Field(
        None,
        description="The identity's department in the organization.\n",
        title='Department',
    )
    division: Optional[str] = Field(
        None,
        description="The identity's division in their organization.\n",
        title='Division',
    )
    title: Optional[str] = Field(
        None, description="The user's job title.\n", title='Title'
    )
    managerId: Optional[str] = Field(
        None, description="The manager identity's ID.\n", title='Managerid'
    )
    hireAt: Optional[datetime] = Field(
        None,
        description="The user's first day of work (in ISO 8601 format).\n",
        title='Hireat',
    )
    terminationAt: Optional[datetime] = Field(
        None,
        description="The user's last day of work (in ISO 8601 format).\n",
        title='Terminationat',
    )
    description: Optional[str] = Field(
        None,
        description='Additional description of the identity.\n',
        title='Description',
    )
    tags: Optional[List[constr(min_length=1)]] = Field(
        None, description='One or more tags on the user account.\n', title='Tags'
    )


class ItemsBundleSchema(BaseModel):
    services: Optional[List[ServiceDescription]] = Field(None, title='Services')
    identities: Optional[List[IdentityDescription]] = Field(None, title='Identities')
    assets: Optional[List[AssetDescription]] = Field(None, title='Assets')
    inheritanceIdentities: Optional[List[IdentitiesInheritance]] = Field(
        None, title='Inheritanceidentities'
    )
    inheritanceAssets: Optional[List[AssetsInheritance]] = Field(
        None, title='Inheritanceassets'
    )
    access: Optional[List[AccessDescription]] = Field(None, title='Access')


class NewIdentityRequestSchema(BaseModel):
    uniqueId: constr(min_length=1) = Field(
        ..., description='Identity ID **Mandatory**\n', title='Uniqueid'
    )
    originId: Optional[constr(min_length=1)] = Field(
        None,
        description="The identity ID in the source system.\nAs opposed to `uniqueId`, it's not mandatory and can be non-unique\n",
        title='Originid',
    )
    name: Optional[str] = Field(None, description='Username', title='Name')
    email: Optional[str] = Field(
        None, description="User's work email address.\n", title='Email'
    )
    personalEmail: Optional[str] = Field(
        None, description="User's personal email address.\n", title='Personalemail'
    )
    firstName: Optional[str] = Field(
        None, description="User's first name\n", title='Firstname'
    )
    lastName: Optional[str] = Field(
        None, description="The user's last name.\n", title='Lastname'
    )
    employeeNumber: Optional[str] = Field(
        None, description='Employee number', title='Employeenumber'
    )
    status: Optional[UserStatus] = Field(
        None,
        description='The user status must be one of the following: `Deleted`, `Disabled`, `Enabled`, `Staged` or `Suspended`.\n',
    )
    country: Optional[str] = Field(None, description='Country', title='Country')
    city: Optional[str] = Field(None, description='City', title='City')
    department: Optional[str] = Field(
        None,
        description="The identity's department in the organization.\n",
        title='Department',
    )
    division: Optional[str] = Field(
        None,
        description="The identity's division in their organization.\n",
        title='Division',
    )
    title: Optional[str] = Field(
        None, description="The user's job title.\n", title='Title'
    )
    managerId: Optional[str] = Field(
        None, description="The manager identity's ID.\n", title='Managerid'
    )
    hireAt: Optional[datetime] = Field(
        None,
        description="The user's first day of work (in ISO 8601 format).\n",
        title='Hireat',
    )
    terminationAt: Optional[datetime] = Field(
        None,
        description="The user's last day of work (in ISO 8601 format).\n",
        title='Terminationat',
    )
    description: Optional[str] = Field(
        None,
        description='Additional description of the identity.\n',
        title='Description',
    )
    tags: Optional[List[constr(min_length=1)]] = Field(
        None, description='One or more tags on the user account.\n', title='Tags'
    )


class NewPermissionRequestSchema(BaseModel):
    sourceUniqueId: constr(min_length=1) = Field(
        ...,
        description="The unique ID of the permission's source. Must be either `userId` or `groupingId`. **Mandatory**.\n",
        title='Sourceuniqueid',
    )
    sourceType: PermissionSourceType = Field(
        ...,
        description="The type of the permission's source. **Mandatory**.\n\nSet `sourceType` to either:\n\n- User `uniqueId`.\n- Grouping `uniqueId`.",
    )
    privilegeId: constr(min_length=1) = Field(
        ...,
        description='The ID of the privilege, allows access to assets. **Mandatory**.\n',
        title='Privilegeid',
    )
    assetId: Optional[str] = Field(
        None,
        description='The ID of the asset.\n\nWhen `null`, this is a global permission on the entire application (not just locally).',
        title='Assetid',
    )
    isRole: Optional[bool] = Field(
        False,
        description='If `true`, the permissions represent the role in the source application.\nThe default is `false`.\n',
        title='Isrole',
    )


class NewPermissionsListRequestSchema(BaseModel):
    data: List[NewPermissionRequestSchema] = Field(
        ..., description='New Permissions', max_items=10000, min_items=1, title='Data'
    )


class NewPrivilegeRequestSchema(BaseModel):
    uniqueId: constr(min_length=1) = Field(
        ...,
        description='Privilege ID.\n\nIf not defined, set as originName. **Mandatory, must be unique.**\n',
        title='Uniqueid',
    )
    originId: Optional[constr(min_length=1)] = Field(
        None,
        description="The privilege ID in the source system.\nAs opposed to `uniqueId`, it's not mandatory and can be non-unique\n",
        title='Originid',
    )
    type: PrivilegeType = Field(
        ...,
        description='The "canonical" privilege types that are supported by Authomize off-the-shelf: **Mandatory**\n\nPermitted values: \n   •\t`Administrative`\n   •\t`Unknown`\n   •\t`Read`\n   •\t`ReadMetadata`\n   •\t`Write`\n   •\t`Create`\n   •\t`Delete`\n   •\t`Execute`\n   •\t`Enable`\n   •\t`Assign`\n   •\t`Restore`\n   •\t`Import`\n   •\t`Export`\n   •\t`Update`\n   •\t`Cancel`\n   •\t`Use`\n   •\t`Delegate`\n   •\t`Join`\n   •\t`Invite`\n   •\t`Share`\n\nIf the privilege type does not exist use `Unknown` or `Use`.\n',
    )
    originName: Optional[str] = Field(
        None, description='The privilege name in the source system.', title='Originname'
    )


class NewPrivilegesListRequestSchema(BaseModel):
    data: List[NewPrivilegeRequestSchema] = Field(
        ..., description='New Privileges', max_items=10000, min_items=1, title='Data'
    )


class NewUserRequestSchema(BaseModel):
    uniqueId: constr(min_length=1) = Field(
        ...,
        description="User's Account ID. **Mandatory, must be unique.**\n",
        title='Uniqueid',
    )
    originId: Optional[constr(min_length=1)] = Field(
        None,
        description="The user ID in the source system.\nAs opposed to `uniqueId`, it's not mandatory and can be non-unique\n",
        title='Originid',
    )
    name: Optional[str] = Field(None, description='Username\n', title='Name')
    email: Optional[str] = Field(
        None, description="User's email address.", title='Email'
    )
    firstName: Optional[str] = Field(
        None, description="User's first name\n", title='Firstname'
    )
    lastName: Optional[str] = Field(
        None, description="The user's last name.\n", title='Lastname'
    )
    status: Optional[UserStatus] = Field(
        None,
        description='User status must be: `Deleted`, `Disabled`, `Enabled`, `Staged`, `Suspended`, or `Unknown`.\n',
    )
    description: Optional[str] = Field(
        None, description='Additional description of the user.\n', title='Description'
    )
    isExternal: Optional[bool] = Field(
        False,
        description='Account is external to Authomize.\nMust be either `true` or `false`.\n',
        title='Isexternal',
    )
    hasMFA: Optional[bool] = Field(
        None,
        description='Has Multi-Factor Authentication enabled.\nMust be either `true` or `false`.\n',
        title='Hasmfa',
    )
    lastLoginAt: Optional[datetime] = Field(
        None,
        description='The last login date in ISO 8601 format.\n',
        title='Lastloginat',
    )
    tags: Optional[List[constr(min_length=1)]] = Field(
        None, description='One or more tags on the user account.\n', title='Tags'
    )


class NewUsersListRequestSchema(BaseModel):
    data: List[NewUserRequestSchema] = Field(
        ..., description='New Users', max_items=10000, min_items=1, title='Data'
    )


class PermissionSchema(BaseModel):
    sourceUniqueId: constr(min_length=1) = Field(
        ...,
        description="The unique ID of the permission's source. Must be either `userId` or `groupingId`. **Mandatory**.\n",
        title='Sourceuniqueid',
    )
    sourceType: PermissionSourceType = Field(
        ...,
        description="The type of the permission's source. **Mandatory**.\n\nSet `sourceType` to either:\n\n- User `uniqueId`.\n- Grouping `uniqueId`.",
    )
    privilegeId: constr(min_length=1) = Field(
        ...,
        description='The ID of the privilege, allows access to assets. **Mandatory**.\n',
        title='Privilegeid',
    )
    assetId: Optional[str] = Field(
        None,
        description='The ID of the asset.\n\nWhen `null`, this is a global permission on the entire application (not just locally).',
        title='Assetid',
    )
    isRole: Optional[bool] = Field(
        False,
        description='If `true`, the permissions represent the role in the source application.\nThe default is `false`.\n',
        title='Isrole',
    )


class PrivilegeSchema(BaseModel):
    uniqueId: constr(min_length=1) = Field(
        ...,
        description='Privilege ID.\n\nIf not defined, set as originName. **Mandatory, must be unique.**\n',
        title='Uniqueid',
    )
    originId: Optional[constr(min_length=1)] = Field(
        None,
        description="The privilege ID in the source system.\nAs opposed to `uniqueId`, it's not mandatory and can be non-unique\n",
        title='Originid',
    )
    type: PrivilegeType = Field(
        ...,
        description='The "canonical" privilege types that are supported by Authomize off-the-shelf: **Mandatory**\n\nPermitted values: \n   •\t`Administrative`\n   •\t`Unknown`\n   •\t`Read`\n   •\t`ReadMetadata`\n   •\t`Write`\n   •\t`Create`\n   •\t`Delete`\n   •\t`Execute`\n   •\t`Enable`\n   •\t`Assign`\n   •\t`Restore`\n   •\t`Import`\n   •\t`Export`\n   •\t`Update`\n   •\t`Cancel`\n   •\t`Use`\n   •\t`Delegate`\n   •\t`Join`\n   •\t`Invite`\n   •\t`Share`\n\nIf the privilege type does not exist use `Unknown` or `Use`.\n',
    )
    originName: Optional[str] = Field(
        None, description='The privilege name in the source system.', title='Originname'
    )


class RequestsBundleSchema(BaseModel):
    new_users: Optional[List[NewUserRequestSchema]] = Field(
        None, description='**Create new users.**', title='New Users'
    )
    new_groupings: Optional[List[NewGroupingRequestSchema]] = Field(
        None,
        description='A "grouping" is any object that collects multiple accounts or other groupings and can be granted permissions. Examples include groups, roles on certain platforms (e.g. AWS), profiles in certain platforms (e.g. SFDC) and more.\n',
        title='New Groupings',
    )
    new_permissions: Optional[List[NewPermissionRequestSchema]] = Field(
        None,
        description='A permission (also referred to as an “entitlement”) is a set of privileges, assigned to a specific target. \nExamples include: file permissions, file shares, GCP entitlements, the actual policies assigning access to roles in AWS, and inline policies.\n',
        title='New Permissions',
    )
    new_privileges: Optional[List[NewPrivilegeRequestSchema]] = Field(
        None,
        description='Add privileges.\n\nThis API enables you to define privileges that can be associated with assets.\n\nFor example, Read privileges on a file.\n\nHere you can define the type of privileges and associate it to assets in the Permission API.\n',
        title='New Privileges',
    )
    new_privileges_grants: Optional[List[NewPrivilegeGrantsRequestSchema]] = Field(
        None,
        description='This API enables you to establish inheritance between privileges, so that a single privilege contains a set of other privileges. For example, an Administrative privilege that contains read and write privileges.',
        title='New Privileges Grants',
    )
    new_accounts_association: Optional[
        List[NewAccountsAssociationRequestSchema]
    ] = Field(
        None,
        description='Create association between user accounts and groups.',
        title='New Accounts Association',
    )
    new_groupings_association: Optional[
        List[NewGroupingsAssociationRequestSchema]
    ] = Field(
        None,
        description='Create associations between groups and other groups.\n',
        title='New Groupings Association',
    )
    new_assets: Optional[List[NewAssetRequestSchema]] = Field(
        None, description='Add assets.\n', title='New Assets'
    )
    new_assets_inheritance: Optional[List[NewAssetInheritanceRequestSchema]] = Field(
        None,
        description='This API allows you to create a connection between different assets (for example, a folder that contains multiple files).\n',
        title='New Assets Inheritance',
    )
    new_identities: Optional[List[NewIdentityRequestSchema]] = Field(
        None,
        description='Use this end point when adding metadata to an identity.\nThe data of the identity from this API is considered "the source of truth" and overrides the identity data from other systems.\n',
        title='New Identities',
    )
    delete_app_data: Optional[bool] = Field(
        False, description='Delete app data by `{appId}`.', title='Delete App Data'
    )
    createdAt: Optional[datetime] = Field(None, title='Createdat')


class RestApiConnectorListSchema(BaseModel):
    pagination: Pagination
    data: List[RestApiConnectorSchema] = Field(..., title='Data')


class SearchAssetsListResponseSchema(BaseModel):
    data: List[AssetSchema] = Field(..., description='Assets', title='Data')


class SearchGroupingResponseSchema(BaseModel):
    data: List[GroupingSchema] = Field(..., description='Groupings', title='Data')


class SearchIdentitiesListResponseSchema(BaseModel):
    data: List[IdentitySchema] = Field(..., description='Identities', title='Data')


class SearchPermissionResponseSchema(BaseModel):
    data: List[PermissionSchema] = Field(..., description='Permissions', title='Data')


class SearchPrivilegesListResponseSchema(BaseModel):
    data: List[PrivilegeSchema] = Field(..., description='Privileges', title='Data')


class TransactionPaginatedSearchSchema(BaseModel):
    data: List[BundleTransactionSchema] = Field(..., title='Data')
    pagination: Pagination


class UserSchema(BaseModel):
    uniqueId: constr(min_length=1) = Field(
        ...,
        description="User's Account ID. **Mandatory, must be unique.**\n",
        title='Uniqueid',
    )
    originId: Optional[constr(min_length=1)] = Field(
        None,
        description="The user ID in the source system.\nAs opposed to `uniqueId`, it's not mandatory and can be non-unique\n",
        title='Originid',
    )
    name: Optional[str] = Field(None, description='Username\n', title='Name')
    email: Optional[str] = Field(
        None, description="User's email address.", title='Email'
    )
    firstName: Optional[str] = Field(
        None, description="User's first name\n", title='Firstname'
    )
    lastName: Optional[str] = Field(
        None, description="The user's last name.\n", title='Lastname'
    )
    status: Optional[UserStatus] = Field(
        None,
        description='User status must be: `Deleted`, `Disabled`, `Enabled`, `Staged`, `Suspended`, or `Unknown`.\n',
    )
    description: Optional[str] = Field(
        None, description='Additional description of the user.\n', title='Description'
    )
    isExternal: Optional[bool] = Field(
        False,
        description='Account is external to Authomize.\nMust be either `true` or `false`.\n',
        title='Isexternal',
    )
    hasMFA: Optional[bool] = Field(
        None,
        description='Has Multi-Factor Authentication enabled.\nMust be either `true` or `false`.\n',
        title='Hasmfa',
    )
    lastLoginAt: Optional[datetime] = Field(
        None,
        description='The last login date in ISO 8601 format.\n',
        title='Lastloginat',
    )
    tags: Optional[List[constr(min_length=1)]] = Field(
        None, description='One or more tags on the user account.\n', title='Tags'
    )


class AllSchemasResponseSchema(BaseModel):
    v1_bundle_schema: Optional[ItemsBundleSchema] = None
    v2_bundle_schema: Optional[RequestsBundleSchema] = None


class NewIdentitiesListRequestSchema(BaseModel):
    data: List[NewIdentityRequestSchema] = Field(
        ..., description='New Identities', max_items=10000, min_items=1, title='Data'
    )


class SearchUsersListResponseSchema(BaseModel):
    data: List[UserSchema] = Field(..., description='Users', title='Data')
