# Generated by Django 4.1.3 on 2022-12-01 09:49

import django.db.models.deletion
from django.db import (
    migrations,
    models,
)

import audoma.django.db.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="ContactData",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "phone_number",
                    audoma.django.db.fields.PhoneNumberField(
                        max_length=128, region="PL"
                    ),
                ),
                (
                    "mobile",
                    audoma.django.db.fields.PhoneNumberField(
                        max_length=128, region="PL"
                    ),
                ),
                (
                    "country",
                    audoma.django.db.fields.CharField(
                        choices=[(1, "Poland"), (2, "Germany")], max_length=100
                    ),
                ),
                ("city", audoma.django.db.fields.CharField(max_length=200)),
            ],
        ),
        migrations.CreateModel(
            name="Patient",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", audoma.django.db.fields.CharField(max_length=255)),
                ("surname", audoma.django.db.fields.CharField(max_length=255)),
                ("weight", audoma.django.db.fields.FloatField()),
                (
                    "height",
                    audoma.django.db.fields.DecimalField(
                        decimal_places=2, max_digits=6
                    ),
                ),
                (
                    "contact_data",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="healthcare_api.contactdata",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Specialization",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", audoma.django.db.fields.CharField(max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name="PatientFiles",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "patient",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="healthcare_api.patient",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="FileEntry",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created_at",
                    audoma.django.db.fields.DateTimeField(auto_now_add=True),
                ),
                ("modifed_at", audoma.django.db.fields.DateTimeField(auto_now=True)),
                ("title", audoma.django.db.fields.CharField(max_length=200)),
                ("content", audoma.django.db.fields.TextField()),
                (
                    "files",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="healthcare_api.patientfiles",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Doctor",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", audoma.django.db.fields.CharField(max_length=255)),
                ("surname", audoma.django.db.fields.CharField(max_length=255)),
                (
                    "salary_currency",
                    audoma.django.db.fields.CurrencyField(
                        choices=[
                            ("AUD", "Australian Dollar"),
                            ("GBP", "British Pound"),
                            ("CNY", "Chinese Yuan"),
                            ("EUR", "Euro"),
                            ("INR", "Indian Rupee"),
                            ("JPY", "Japanese Yen"),
                            ("NZD", "New Zealand Dollar"),
                            ("CHF", "Swiss Franc"),
                            ("USD", "US Dollar"),
                        ],
                        default="PLN",
                        max_length=3,
                    ),
                ),
                (
                    "salary",
                    audoma.django.db.fields.MoneyField(
                        decimal_places=2, default_currency="PLN", max_digits=10
                    ),
                ),
                (
                    "contact_data",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="healthcare_api.contactdata",
                    ),
                ),
                (
                    "specialization",
                    models.ManyToManyField(to="healthcare_api.specialization"),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
    ]
