export declare class RedshiftMetrics {
    static commitQueueLengthAverage(dimensions: {
        ClusterIdentifier: string;
    }): {
        namespace: string;
        metricName: string;
        dimensionsMap: {
            ClusterIdentifier: string;
        };
        statistic: string;
    };
    static concurrencyScalingActiveClustersAverage(dimensions: {
        ClusterIdentifier: string;
    }): {
        namespace: string;
        metricName: string;
        dimensionsMap: {
            ClusterIdentifier: string;
        };
        statistic: string;
    };
    static concurrencyScalingSecondsAverage(dimensions: {
        ClusterIdentifier: string;
    }): {
        namespace: string;
        metricName: string;
        dimensionsMap: {
            ClusterIdentifier: string;
        };
        statistic: string;
    };
    static cpuUtilizationAverage(dimensions: {
        ClusterIdentifier: string;
    }): MetricWithDims<{
        ClusterIdentifier: string;
    }>;
    static cpuUtilizationAverage(dimensions: {
        ClusterIdentifier: string;
        NodeID: string;
    }): MetricWithDims<{
        ClusterIdentifier: string;
        NodeID: string;
    }>;
    static databaseConnectionsAverage(dimensions: {
        ClusterIdentifier: string;
    }): {
        namespace: string;
        metricName: string;
        dimensionsMap: {
            ClusterIdentifier: string;
        };
        statistic: string;
    };
    static healthStatusSum(dimensions: {
        ClusterIdentifier: string;
    }): {
        namespace: string;
        metricName: string;
        dimensionsMap: {
            ClusterIdentifier: string;
        };
        statistic: string;
    };
    static maintenanceModeSum(dimensions: {
        ClusterIdentifier: string;
    }): {
        namespace: string;
        metricName: string;
        dimensionsMap: {
            ClusterIdentifier: string;
        };
        statistic: string;
    };
    static maxConfiguredConcurrencyScalingClustersSum(dimensions: {
        ClusterIdentifier: string;
    }): {
        namespace: string;
        metricName: string;
        dimensionsMap: {
            ClusterIdentifier: string;
        };
        statistic: string;
    };
    static networkReceiveThroughputSum(dimensions: {
        ClusterIdentifier: string;
    }): MetricWithDims<{
        ClusterIdentifier: string;
    }>;
    static networkReceiveThroughputSum(dimensions: {
        ClusterIdentifier: string;
        NodeID: string;
    }): MetricWithDims<{
        ClusterIdentifier: string;
        NodeID: string;
    }>;
    static networkTransmitThroughputSum(dimensions: {
        ClusterIdentifier: string;
    }): MetricWithDims<{
        ClusterIdentifier: string;
    }>;
    static networkTransmitThroughputSum(dimensions: {
        ClusterIdentifier: string;
        NodeID: string;
    }): MetricWithDims<{
        ClusterIdentifier: string;
        NodeID: string;
    }>;
    static numExceededSchemaQuotasAverage(dimensions: {
        ClusterIdentifier: string;
    }): {
        namespace: string;
        metricName: string;
        dimensionsMap: {
            ClusterIdentifier: string;
        };
        statistic: string;
    };
    static percentageDiskSpaceUsedAverage(dimensions: {
        ClusterIdentifier: string;
    }): {
        namespace: string;
        metricName: string;
        dimensionsMap: {
            ClusterIdentifier: string;
        };
        statistic: string;
    };
    static percentageQuotaUsedAverage(dimensions: {
        ClusterIdentifier: string;
    }): {
        namespace: string;
        metricName: string;
        dimensionsMap: {
            ClusterIdentifier: string;
        };
        statistic: string;
    };
    static queriesCompletedPerSecondSum(dimensions: {
        ClusterIdentifier: string;
    }): MetricWithDims<{
        ClusterIdentifier: string;
    }>;
    static queriesCompletedPerSecondSum(dimensions: {
        ClusterIdentifier: string;
        wlmid: string;
    }): MetricWithDims<{
        ClusterIdentifier: string;
        wlmid: string;
    }>;
    static queryDurationAverage(dimensions: {
        ClusterIdentifier: string;
    }): {
        namespace: string;
        metricName: string;
        dimensionsMap: {
            ClusterIdentifier: string;
        };
        statistic: string;
    };
    static queryRuntimeBreakdownSum(dimensions: {
        ClusterIdentifier: string;
    }): {
        namespace: string;
        metricName: string;
        dimensionsMap: {
            ClusterIdentifier: string;
        };
        statistic: string;
    };
    static readIopsSum(dimensions: {
        ClusterIdentifier: string;
    }): MetricWithDims<{
        ClusterIdentifier: string;
    }>;
    static readIopsSum(dimensions: {
        ClusterIdentifier: string;
        NodeID: string;
    }): MetricWithDims<{
        ClusterIdentifier: string;
        NodeID: string;
    }>;
    static readLatencyAverage(dimensions: {
        ClusterIdentifier: string;
    }): MetricWithDims<{
        ClusterIdentifier: string;
    }>;
    static readLatencyAverage(dimensions: {
        ClusterIdentifier: string;
        NodeID: string;
    }): MetricWithDims<{
        ClusterIdentifier: string;
        NodeID: string;
    }>;
    static readThroughputSum(dimensions: {
        ClusterIdentifier: string;
    }): MetricWithDims<{
        ClusterIdentifier: string;
    }>;
    static readThroughputSum(dimensions: {
        ClusterIdentifier: string;
        NodeID: string;
    }): MetricWithDims<{
        ClusterIdentifier: string;
        NodeID: string;
    }>;
    static storageUsedAverage(dimensions: {
        ClusterIdentifier: string;
    }): {
        namespace: string;
        metricName: string;
        dimensionsMap: {
            ClusterIdentifier: string;
        };
        statistic: string;
    };
    static totalTableCountAverage(dimensions: {
        ClusterIdentifier: string;
    }): {
        namespace: string;
        metricName: string;
        dimensionsMap: {
            ClusterIdentifier: string;
        };
        statistic: string;
    };
    static wlmQueriesCompletedPerSecondAverage(dimensions: {
        ClusterIdentifier: string;
    }): MetricWithDims<{
        ClusterIdentifier: string;
    }>;
    static wlmQueriesCompletedPerSecondAverage(dimensions: {
        ClusterIdentifier: string;
        wlmid: string;
    }): MetricWithDims<{
        ClusterIdentifier: string;
        wlmid: string;
    }>;
    static wlmQueriesCompletedPerSecondAverage(dimensions: {
        ClusterIdentifier: string;
        QueueName: string;
    }): MetricWithDims<{
        ClusterIdentifier: string;
        QueueName: string;
    }>;
    static wlmQueryDurationAverage(dimensions: {
        ClusterIdentifier: string;
    }): MetricWithDims<{
        ClusterIdentifier: string;
    }>;
    static wlmQueryDurationAverage(dimensions: {
        ClusterIdentifier: string;
        wlmid: string;
    }): MetricWithDims<{
        ClusterIdentifier: string;
        wlmid: string;
    }>;
    static wlmQueryDurationAverage(dimensions: {
        ClusterIdentifier: string;
        QueueName: string;
    }): MetricWithDims<{
        ClusterIdentifier: string;
        QueueName: string;
    }>;
    static wlmQueueLengthSum(dimensions: {
        ClusterIdentifier: string;
    }): MetricWithDims<{
        ClusterIdentifier: string;
    }>;
    static wlmQueueLengthSum(dimensions: {
        ClusterIdentifier: string;
        QueueName: string;
    }): MetricWithDims<{
        ClusterIdentifier: string;
        QueueName: string;
    }>;
    static writeIopsSum(dimensions: {
        ClusterIdentifier: string;
    }): MetricWithDims<{
        ClusterIdentifier: string;
    }>;
    static writeIopsSum(dimensions: {
        ClusterIdentifier: string;
        NodeID: string;
    }): MetricWithDims<{
        ClusterIdentifier: string;
        NodeID: string;
    }>;
    static writeLatencyAverage(dimensions: {
        ClusterIdentifier: string;
    }): MetricWithDims<{
        ClusterIdentifier: string;
    }>;
    static writeLatencyAverage(dimensions: {
        ClusterIdentifier: string;
        NodeID: string;
    }): MetricWithDims<{
        ClusterIdentifier: string;
        NodeID: string;
    }>;
    static writeThroughputSum(dimensions: {
        ClusterIdentifier: string;
    }): MetricWithDims<{
        ClusterIdentifier: string;
    }>;
    static writeThroughputSum(dimensions: {
        ClusterIdentifier: string;
        NodeID: string;
    }): MetricWithDims<{
        ClusterIdentifier: string;
        NodeID: string;
    }>;
    static wlmQueueWaitTimeAverage(dimensions: {
        ClusterIdentifier: string;
        wlmid: string;
    }): MetricWithDims<{
        ClusterIdentifier: string;
        wlmid: string;
    }>;
    static wlmQueueWaitTimeAverage(dimensions: {
        ClusterIdentifier: string;
        QueueName: string;
    }): MetricWithDims<{
        ClusterIdentifier: string;
        QueueName: string;
    }>;
    static wlmRunningQueriesAverage(dimensions: {
        ClusterIdentifier: string;
        wlmid: string;
    }): MetricWithDims<{
        ClusterIdentifier: string;
        wlmid: string;
    }>;
    static wlmRunningQueriesAverage(dimensions: {
        ClusterIdentifier: string;
        QueueName: string;
    }): MetricWithDims<{
        ClusterIdentifier: string;
        QueueName: string;
    }>;
}
declare type MetricWithDims<D> = {
    namespace: string;
    metricName: string;
    statistic: string;
    dimensionsMap: D;
};
export {};
