import { IResource, Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
/**
 * A parameter group
 */
export interface IClusterParameterGroup extends IResource {
    /**
     * The name of this parameter group
     *
     * @attribute
     */
    readonly clusterParameterGroupName: string;
}
/**
 * A new cluster or instance parameter group
 */
declare abstract class ClusterParameterGroupBase extends Resource implements IClusterParameterGroup {
    /**
     * The name of the parameter group
     */
    abstract readonly clusterParameterGroupName: string;
}
/**
 * Properties for a parameter group
 */
export interface ClusterParameterGroupProps {
    /**
     * Description for this parameter group
     *
     * @default a CDK generated description
     */
    readonly description?: string;
    /**
     * The parameters in this parameter group
     */
    readonly parameters: {
        [name: string]: string;
    };
}
/**
 * A cluster parameter group
 *
 * @resource AWS::Redshift::ClusterParameterGroup
 */
export declare class ClusterParameterGroup extends ClusterParameterGroupBase {
    /**
     * Imports a parameter group
     */
    static fromClusterParameterGroupName(scope: Construct, id: string, clusterParameterGroupName: string): IClusterParameterGroup;
    /**
     * The name of the parameter group
     */
    readonly clusterParameterGroupName: string;
    constructor(scope: Construct, id: string, props: ClusterParameterGroupProps);
}
export {};
