"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * An SQS dead letter queue destination configuration for a Lambda event source
 */
class SqsDlq {
    constructor(queue) {
        this.queue = queue;
    }
    /**
     * Returns a destination configuration for the DLQ
     */
    bind(_target, targetHandler) {
        this.queue.grantSendMessages(targetHandler);
        return {
            destination: this.queue.queueArn
        };
    }
}
exports.SqsDlq = SqsDlq;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3FzLWRscS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInNxcy1kbHEudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFHQTs7R0FFRztBQUNILE1BQWEsTUFBTTtJQUNqQixZQUE2QixLQUFpQjtRQUFqQixVQUFLLEdBQUwsS0FBSyxDQUFZO0lBQzlDLENBQUM7SUFFRDs7T0FFRztJQUNJLElBQUksQ0FBQyxPQUE0QixFQUFFLGFBQXdCO1FBQ2hFLElBQUksQ0FBQyxLQUFLLENBQUMsaUJBQWlCLENBQUMsYUFBYSxDQUFDLENBQUM7UUFFNUMsT0FBTztZQUNMLFdBQVcsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFFBQVE7U0FDakMsQ0FBQztJQUNKLENBQUM7Q0FDRjtBQWRELHdCQWNDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgRGxxRGVzdGluYXRpb25Db25maWcsIElFdmVudFNvdXJjZURscSwgSUV2ZW50U291cmNlTWFwcGluZywgSUZ1bmN0aW9uIH0gZnJvbSBcIkBhd3MtY2RrL2F3cy1sYW1iZGFcIjtcbmltcG9ydCAqIGFzIHNxcyBmcm9tICdAYXdzLWNkay9hd3Mtc3FzJztcblxuLyoqXG4gKiBBbiBTUVMgZGVhZCBsZXR0ZXIgcXVldWUgZGVzdGluYXRpb24gY29uZmlndXJhdGlvbiBmb3IgYSBMYW1iZGEgZXZlbnQgc291cmNlXG4gKi9cbmV4cG9ydCBjbGFzcyBTcXNEbHEgaW1wbGVtZW50cyBJRXZlbnRTb3VyY2VEbHEge1xuICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IHF1ZXVlOiBzcXMuSVF1ZXVlKSB7XG4gIH1cblxuICAvKipcbiAgICogUmV0dXJucyBhIGRlc3RpbmF0aW9uIGNvbmZpZ3VyYXRpb24gZm9yIHRoZSBETFFcbiAgICovXG4gIHB1YmxpYyBiaW5kKF90YXJnZXQ6IElFdmVudFNvdXJjZU1hcHBpbmcsIHRhcmdldEhhbmRsZXI6IElGdW5jdGlvbik6IERscURlc3RpbmF0aW9uQ29uZmlnIHtcbiAgICB0aGlzLnF1ZXVlLmdyYW50U2VuZE1lc3NhZ2VzKHRhcmdldEhhbmRsZXIpO1xuXG4gICAgcmV0dXJuIHtcbiAgICAgIGRlc3RpbmF0aW9uOiB0aGlzLnF1ZXVlLnF1ZXVlQXJuXG4gICAgfTtcbiAgfVxufVxuIl19