"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SubnetGroup = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const core_1 = require("@aws-cdk/core");
const neptune_generated_1 = require("./neptune.generated");
/**
 * Class for creating a RDS DB subnet group
 *
 * @resource AWS::Neptune::DBSubnetGroup
 */
class SubnetGroup extends core_1.Resource {
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_neptune_SubnetGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        const { subnetIds } = props.vpc.selectSubnets((_b = props.vpcSubnets) !== null && _b !== void 0 ? _b : { subnetType: ec2.SubnetType.PRIVATE });
        const subnetGroup = new neptune_generated_1.CfnDBSubnetGroup(this, 'Resource', {
            dbSubnetGroupDescription: props.description || 'Subnet group for Neptune',
            dbSubnetGroupName: props.subnetGroupName,
            subnetIds,
        });
        if (props.removalPolicy) {
            subnetGroup.applyRemovalPolicy(props.removalPolicy);
        }
        this.subnetGroupName = subnetGroup.ref;
    }
    /**
     * Imports an existing subnet group by name.
     */
    static fromSubnetGroupName(scope, id, subnetGroupName) {
        return new class extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.subnetGroupName = subnetGroupName;
            }
        }(scope, id);
    }
}
exports.SubnetGroup = SubnetGroup;
_a = JSII_RTTI_SYMBOL_1;
SubnetGroup[_a] = { fqn: "@aws-cdk/aws-neptune.SubnetGroup", version: "1.153.1" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3VibmV0LWdyb3VwLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsic3VibmV0LWdyb3VwLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFBLHdDQUF3QztBQUN4Qyx3Q0FBbUU7QUFFbkUsMkRBQXVEO0FBb0R2RDs7OztHQUlHO0FBQ0gsTUFBYSxXQUFZLFNBQVEsZUFBUTtJQWF2QyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQXVCOztRQUMvRCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDOzs7Ozs7Ozs7O1FBRWpCLE1BQU0sRUFBRSxTQUFTLEVBQUUsR0FBRyxLQUFLLENBQUMsR0FBRyxDQUFDLGFBQWEsT0FBQyxLQUFLLENBQUMsVUFBVSxtQ0FBSSxFQUFFLFVBQVUsRUFBRSxHQUFHLENBQUMsVUFBVSxDQUFDLE9BQU8sRUFBRSxDQUFDLENBQUM7UUFFMUcsTUFBTSxXQUFXLEdBQUcsSUFBSSxvQ0FBZ0IsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFO1lBQ3pELHdCQUF3QixFQUFFLEtBQUssQ0FBQyxXQUFXLElBQUksMEJBQTBCO1lBQ3pFLGlCQUFpQixFQUFFLEtBQUssQ0FBQyxlQUFlO1lBQ3hDLFNBQVM7U0FDVixDQUFDLENBQUM7UUFFSCxJQUFJLEtBQUssQ0FBQyxhQUFhLEVBQUU7WUFDdkIsV0FBVyxDQUFDLGtCQUFrQixDQUFDLEtBQUssQ0FBQyxhQUFhLENBQUMsQ0FBQztTQUNyRDtRQUVELElBQUksQ0FBQyxlQUFlLEdBQUcsV0FBVyxDQUFDLEdBQUcsQ0FBQztLQUN4QztJQTNCRDs7T0FFRztJQUNJLE1BQU0sQ0FBQyxtQkFBbUIsQ0FBQyxLQUFnQixFQUFFLEVBQVUsRUFBRSxlQUF1QjtRQUNyRixPQUFPLElBQUksS0FBTSxTQUFRLGVBQVE7WUFBdEI7O2dCQUNPLG9CQUFlLEdBQUcsZUFBZSxDQUFDO1lBQ3BELENBQUM7U0FBQSxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztLQUNkOztBQVRILGtDQThCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGVjMiBmcm9tICdAYXdzLWNkay9hd3MtZWMyJztcbmltcG9ydCB7IElSZXNvdXJjZSwgUmVtb3ZhbFBvbGljeSwgUmVzb3VyY2UgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgQ2ZuREJTdWJuZXRHcm91cCB9IGZyb20gJy4vbmVwdHVuZS5nZW5lcmF0ZWQnO1xuXG4vKipcbiAqIEludGVyZmFjZSBmb3IgYSBzdWJuZXQgZ3JvdXAuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSVN1Ym5ldEdyb3VwIGV4dGVuZHMgSVJlc291cmNlIHtcbiAgLyoqXG4gICAqIFRoZSBuYW1lIG9mIHRoZSBzdWJuZXQgZ3JvdXAuXG4gICAqIEBhdHRyaWJ1dGVcbiAgICovXG4gIHJlYWRvbmx5IHN1Ym5ldEdyb3VwTmFtZTogc3RyaW5nO1xufVxuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGNyZWF0aW5nIGEgU3VibmV0R3JvdXAuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgU3VibmV0R3JvdXBQcm9wcyB7XG4gIC8qKlxuICAgKiBEZXNjcmlwdGlvbiBvZiB0aGUgc3VibmV0IGdyb3VwLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIGEgbmFtZSBpcyBnZW5lcmF0ZWRcbiAgICovXG4gIHJlYWRvbmx5IGRlc2NyaXB0aW9uPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgVlBDIHRvIHBsYWNlIHRoZSBzdWJuZXQgZ3JvdXAgaW4uXG4gICAqL1xuICByZWFkb25seSB2cGM6IGVjMi5JVnBjO1xuXG4gIC8qKlxuICAgKiBUaGUgbmFtZSBvZiB0aGUgc3VibmV0IGdyb3VwLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIGEgbmFtZSBpcyBnZW5lcmF0ZWRcbiAgICovXG4gIHJlYWRvbmx5IHN1Ym5ldEdyb3VwTmFtZT86IHN0cmluZztcblxuICAvKipcbiAgICogV2hpY2ggc3VibmV0cyB3aXRoaW4gdGhlIFZQQyB0byBhc3NvY2lhdGUgd2l0aCB0aGlzIGdyb3VwLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIHByaXZhdGUgc3VibmV0c1xuICAgKi9cbiAgcmVhZG9ubHkgdnBjU3VibmV0cz86IGVjMi5TdWJuZXRTZWxlY3Rpb247XG5cbiAgLyoqXG4gICAqIFRoZSByZW1vdmFsIHBvbGljeSB0byBhcHBseSB3aGVuIHRoZSBzdWJuZXQgZ3JvdXAgYXJlIHJlbW92ZWRcbiAgICogZnJvbSB0aGUgc3RhY2sgb3IgcmVwbGFjZWQgZHVyaW5nIGFuIHVwZGF0ZS5cbiAgICpcbiAgICogQGRlZmF1bHQgUmVtb3ZhbFBvbGljeS5ERVNUUk9ZXG4gICAqL1xuICByZWFkb25seSByZW1vdmFsUG9saWN5PzogUmVtb3ZhbFBvbGljeVxufVxuXG4vKipcbiAqIENsYXNzIGZvciBjcmVhdGluZyBhIFJEUyBEQiBzdWJuZXQgZ3JvdXBcbiAqXG4gKiBAcmVzb3VyY2UgQVdTOjpOZXB0dW5lOjpEQlN1Ym5ldEdyb3VwXG4gKi9cbmV4cG9ydCBjbGFzcyBTdWJuZXRHcm91cCBleHRlbmRzIFJlc291cmNlIGltcGxlbWVudHMgSVN1Ym5ldEdyb3VwIHtcblxuICAvKipcbiAgICogSW1wb3J0cyBhbiBleGlzdGluZyBzdWJuZXQgZ3JvdXAgYnkgbmFtZS5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgZnJvbVN1Ym5ldEdyb3VwTmFtZShzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBzdWJuZXRHcm91cE5hbWU6IHN0cmluZyk6IElTdWJuZXRHcm91cCB7XG4gICAgcmV0dXJuIG5ldyBjbGFzcyBleHRlbmRzIFJlc291cmNlIGltcGxlbWVudHMgSVN1Ym5ldEdyb3VwIHtcbiAgICAgIHB1YmxpYyByZWFkb25seSBzdWJuZXRHcm91cE5hbWUgPSBzdWJuZXRHcm91cE5hbWU7XG4gICAgfShzY29wZSwgaWQpO1xuICB9XG5cbiAgcHVibGljIHJlYWRvbmx5IHN1Ym5ldEdyb3VwTmFtZTogc3RyaW5nO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBTdWJuZXRHcm91cFByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIGNvbnN0IHsgc3VibmV0SWRzIH0gPSBwcm9wcy52cGMuc2VsZWN0U3VibmV0cyhwcm9wcy52cGNTdWJuZXRzID8/IHsgc3VibmV0VHlwZTogZWMyLlN1Ym5ldFR5cGUuUFJJVkFURSB9KTtcblxuICAgIGNvbnN0IHN1Ym5ldEdyb3VwID0gbmV3IENmbkRCU3VibmV0R3JvdXAodGhpcywgJ1Jlc291cmNlJywge1xuICAgICAgZGJTdWJuZXRHcm91cERlc2NyaXB0aW9uOiBwcm9wcy5kZXNjcmlwdGlvbiB8fCAnU3VibmV0IGdyb3VwIGZvciBOZXB0dW5lJyxcbiAgICAgIGRiU3VibmV0R3JvdXBOYW1lOiBwcm9wcy5zdWJuZXRHcm91cE5hbWUsXG4gICAgICBzdWJuZXRJZHMsXG4gICAgfSk7XG5cbiAgICBpZiAocHJvcHMucmVtb3ZhbFBvbGljeSkge1xuICAgICAgc3VibmV0R3JvdXAuYXBwbHlSZW1vdmFsUG9saWN5KHByb3BzLnJlbW92YWxQb2xpY3kpO1xuICAgIH1cblxuICAgIHRoaXMuc3VibmV0R3JvdXBOYW1lID0gc3VibmV0R3JvdXAucmVmO1xuICB9XG59XG4iXX0=