"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const codepipeline = require("../lib");
class FakeBuildAction {
    constructor(props) {
        this.actionProperties = {
            ...props,
            category: codepipeline.ActionCategory.BUILD,
            provider: 'Fake',
            artifactBounds: { minInputs: 1, maxInputs: 3, minOutputs: 0, maxOutputs: 1 },
            inputs: [props.input, ...props.extraInputs || []],
            outputs: props.output ? [props.output] : undefined,
        };
        this.customConfigKey = props.customConfigKey;
    }
    bind(_scope, _stage, _options) {
        return {
            configuration: {
                CustomConfigKey: this.customConfigKey,
            },
        };
    }
    onStateChange(_name, _target, _options) {
        throw new Error('onStateChange() is not available on FakeBuildAction');
    }
}
exports.FakeBuildAction = FakeBuildAction;
//# sourceMappingURL=data:application/json;base64,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