"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Chain = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const parallel_1 = require("./states/parallel");
/**
 * A collection of states to chain onto.
 *
 * A Chain has a start and zero or more chainable ends. If there are
 * zero ends, calling next() on the Chain will fail.
 *
 * @stability stable
 */
class Chain {
    constructor(startState, endStates, lastAdded) {
        this.lastAdded = lastAdded;
        this.id = lastAdded.id;
        this.startState = startState;
        this.endStates = endStates;
    }
    /**
     * Begin a new Chain from one chainable.
     *
     * @stability stable
     */
    static start(state) {
        return new Chain(state.startState, state.endStates, state);
    }
    /**
     * Make a Chain with the start from one chain and the ends from another.
     *
     * @stability stable
     */
    static sequence(start, next) {
        return new Chain(start.startState, next.endStates, next);
    }
    /**
     * Make a Chain with specific start and end states, and a last-added Chainable.
     *
     * @stability stable
     */
    static custom(startState, endStates, lastAdded) {
        return new Chain(startState, endStates, lastAdded);
    }
    /**
     * Continue normal execution with the given state.
     *
     * @stability stable
     */
    next(next) {
        if (this.endStates.length === 0) {
            throw new Error(`Cannot add to chain: last state in chain (${this.lastAdded.id}) does not allow it`);
        }
        for (const endState of this.endStates) {
            endState.next(next);
        }
        return new Chain(this.startState, next.endStates, next);
    }
    /**
     * Return a single state that encompasses all states in the chain.
     *
     * This can be used to add error handling to a sequence of states.
     *
     * Be aware that this changes the result of the inner state machine
     * to be an array with the result of the state machine in it. Adjust
     * your paths accordingly. For example, change 'outputPath' to
     * '$[0]'.
     *
     * @stability stable
     */
    toSingleState(id, props = {}) {
        return new parallel_1.Parallel(this.startState, id, props).branch(this);
    }
}
exports.Chain = Chain;
_a = JSII_RTTI_SYMBOL_1;
Chain[_a] = { fqn: "@aws-cdk/aws-stepfunctions.Chain", version: "1.101.0" };
//# sourceMappingURL=data:application/json;base64,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