"""Writes the version.c file containing version information.

Usage:  call from makefile like this:
  python recordversion.py '$(VERSION)' 'edition' '$(CXX)' '$(CXXFLAGS)' > version.cpp
where edition specifies serial or parallel editions.
"""
from __future__ import print_function

from time import *
from sys import argv
import os

contents = '''
// version.cpp
//
// This file is AUTOMATICALLY GENERATED BY recordversion.py.  DO NOT EDIT!
//

#include "AsapNamespace.h"
#include <string>
using std::string;

namespace ASAPSPACE {

string GetVersion()
{
  return ("ASAP version %s %s, compiled " \
          __DATE__ " " __TIME__ \
          " on %s using '%s'");
}

string GetShortVersion()
{
  return "%s";
}

} // end namespace
'''

if __name__ == '__main__':
    assert(len(argv) == 5)
    version = argv[1]
    edition = argv[2]
    if argv[4] != "":
        compiler = argv[3] + " " + argv[4]
    else:
        compiler = argv[3]
    #when = strftime("%Y-%m-%d %H:%M", localtime(time()))
    try:
        host = os.uname()[1]
    except:
        host = 'unknown'


    print(contents % (version, edition, host, compiler, version))
