"""Experimental parameters for EMT2013."""

from ase.units import Bohr

EMT2013_experimental_parameters = {
    'Cu': {'E0': -3.51, 'S0': 2.67*Bohr, 'V0': 2.476, 'eta2': 1.652/Bohr,  'kappa': 2.740/Bohr,  
           'lambda': 1.906/Bohr,  'n0': 0.00910/(Bohr**3)}
    }

sihb_PtY_parameters = {
    'Calculator': "EMT2013_V1",
    'Pt': {'E0': -5.82286,
           'S0': 1.55073,
           'V0': 2.69717,
           'eta2': 2.41957,
           'kappa': 3.86730,
           'lambda': 4.02350,
           'n0': 0.05412},

    'Y': {'E0': -4.22967,
          'S0': 2.12796,
          'V0': 5.93342,
          'eta2': 1.65912,
          'kappa': 2.78458,
          'lambda': 2.14360,
          'n0': 0.02626882869955157},  # Absurdly many digits to maintain result after a bug fix.
}


##############################################
###  Parameters for late transition metals ###
##############################################

EMT2013_lateTM_candidate_parameters = {
    "Calculator": "EMT2013_V1", 
    "Ag": {
        "E0": -2.8597944810000002, 
        "S0": 1.6652367210000001, 
        "V0": 2.043094462, 
        "eta2": 1.941023392, 
        "kappa": 2.950885015963761, 
        "lambda": 3.3746855660000001, 
        "n0": 0.041210564999999998
    }, 
    "Au": {
        "E0": -3.6685582339999998, 
        "S0": 1.6576558189999999, 
        "V0": 2.6915435250000002, 
        "eta2": 1.710358587, 
        "kappa": 2.6109397331063775, 
        "lambda": 3.5644026179999999, 
        "n0": 0.043026409000000002
    }, 
    "Cu": {
        "E0": -3.3863577629999999, 
        "S0": 1.4856088510000001, 
        "V0": 2.6630014439999998, 
        "eta2": 2.1583966239999999, 
        "kappa": 3.4025214484186836, 
        "lambda": 3.3964669779999999, 
        "n0": 0.046590541999999999
    }, 
    "Ni": {
        "E0": -4.2982347729999999, 
        "S0": 1.459697698, 
        "V0": 3.9660987780000001, 
        "eta2": 2.2079827449999998, 
        "kappa": 3.5224480973709422, 
        "lambda": 3.4268259149999998, 
        "n0": 0.053181618
    }, 
    "Pd": {
        "E0": -3.644448395, 
        "S0": 1.615541892, 
        "V0": 3.2273507430000001, 
        "eta2": 1.764045992, 
        "kappa": 2.6853589894692784, 
        "lambda": 3.4694360909999999, 
        "n0": 0.046421498999999998
    }, 
    "Pt": {
        "E0": -5.4690194910000001, 
        "S0": 1.6319105890000001, 
        "V0": 4.5014003269999998, 
        "eta2": 1.582931968, 
        "kappa": 2.4178183013755556, 
        "lambda": 3.2395920949999999, 
        "n0": 0.054604415000000003
    }
}


# This parameter set will be replaced.
EMT2013_candidate_parameters = {
    "Calculator": "EMT2013_V1", 
    "Ag": {
        "E0": -2.863273548, 
        "S0": 1.665043657, 
        "V0": 2.0138805789999998, 
        "eta2": 1.938527428, 
        "kappa": 2.9430026322249065, 
        "lambda": 3.3696227200000002, 
        "n0": 0.041446044000000001
    }, 
    "Au": {
        "E0": -3.663406969, 
        "S0": 1.6583155329999999, 
        "V0": 2.646640551, 
        "eta2": 1.7198444049999999, 
        "kappa": 2.6116084982089012, 
        "lambda": 3.5763287080000001, 
        "n0": 0.041758546000000001
    }, 
    "Cu": {
        "E0": -3.389044883, 
        "S0": 1.4855297649999999, 
        "V0": 2.556278636, 
        "eta2": 2.1564993509999999, 
        "kappa": 3.382104635049842, 
        "lambda": 3.3905616040000002, 
        "n0": 0.044225079
    }, 
    "Ni": {
        "E0": -4.2999908380000003, 
        "S0": 1.4589703510000001, 
        "V0": 3.9195016310000002, 
        "eta2": 2.1952763740000001, 
        "kappa": 3.5027033903447204, 
        "lambda": 3.4216078090000002, 
        "n0": 0.053026687000000003
    }, 
    "Pd": {
        "E0": -3.6441551489999999, 
        "S0": 1.6155418500000001, 
        "V0": 3.2046973169999999, 
        "eta2": 1.7637545670000001, 
        "kappa": 2.6829749361353135, 
        "lambda": 3.4694253220000002, 
        "n0": 0.046150087999999999
    }, 
    "Pt": {
        "E0": -5.4690194910000001, 
        "S0": 1.6319105890000001, 
        "V0": 4.5014003269999998, 
        "eta2": 1.582931968, 
        "kappa": 2.4178183013755556, 
        "lambda": 3.2395920949999999, 
        "n0": 0.054604415000000003
    }
}



##############################################
###  Parameters for late transition metals ###
##############################################

EMT2013_earlyTM_candidate_parameters = {
    "Ca": {
        "E0": -1.787026877, 
        "S0": 2.2942558050000001, 
        "V0": 1.95814928, 
        "eta2": 1.6080150499999999, 
        "kappa": 2.5945460826930442, 
        "lambda": 2.204666515, 
        "n0": 0.016805029999999999
    }, 
    "Calculator": "EMT2013_V1", 
    "Hf": {
        "E0": -5.0592332420000004, 
        "S0": 2.1028228859999998, 
        "V0": 6.1242729149999997, 
        "eta2": 1.211360443, 
        "kappa": 1.9088172348611752, 
        "lambda": 2.095265435, 
        "n0": 0.046141505999999999
    }, 
    "Mg": {
        "E0": -1.499657639, 
        "S0": 1.7824922999999999, 
        "V0": 0.58777852200000003, 
        "eta2": 2.7075786100000001, 
        "kappa": 4.0457560178683609, 
        "lambda": 3.220997954, 
        "n0": 0.017904192999999999
    }, 
    "Sc": {
        "E0": -3.095047176, 
        "S0": 2.1430342910000002, 
        "V0": 3.7262664660000002, 
        "eta2": 1.226977226, 
        "kappa": 1.9400162247506514, 
        "lambda": 2.0895910930000001, 
        "n0": 0.034203933999999998
    }, 
    "Sr": {
        "E0": -1.6822683979999999, 
        "S0": 2.4908064909999998, 
        "V0": 1.731357561, 
        "eta2": 1.5106682499999999, 
        "kappa": 2.4273213231610118, 
        "lambda": 2.0005707030000002, 
        "n0": 0.017364899
    }, 
    "Ti": {
        "E0": -3.7206412250000001, 
        "S0": 1.9372078909999999, 
        "V0": 4.9840735140000003, 
        "eta2": 1.2777850399999999, 
        "kappa": 2.0360293467612434, 
        "lambda": 2.272698326, 
        "n0": 0.030907523999999999
    }, 
    "Y": {
        "E0": -3.5828373469999999, 
        "S0": 2.3896535380000001, 
        "V0": 3.5861373589999999, 
        "eta2": 1.06041662, 
        "kappa": 1.6471000571381127, 
        "lambda": 1.774752756, 
        "n0": 0.043436031
    }, 
    "Zr": {
        "E0": -4.9899754789999999, 
        "S0": 2.130995746, 
        "V0": 5.1354201960000001, 
        "eta2": 1.0994242409999999, 
        "kappa": 1.726983018405895, 
        "lambda": 1.8965789909999999, 
        "n0": 0.045165826999999999
    }
}



########################################
###  Parameters for Platinum alloys  ###
########################################


# deprecated
EMT2013_Pt_alloy_parameters_070715 = {
    "Calculator": "EMT2013_V1", 
    "Ca": {
        "E0": -1.7838833350000001, 
        "S0": 2.2950274980000001, 
        "V0": 2.0953453529999999, 
        "eta2": 1.620872748, 
        "kappa": 2.6251816047613739, 
        "lambda": 2.2314416659999998, 
        "n0": 0.015431743
    }, 
    "Mg": {
        "E0": -1.5089530040000001, 
        "S0": 1.7748252200000001, 
        "V0": 1.4752788320000001, 
        "eta2": 2.937834091, 
        "kappa": 4.9428989909658707, 
        "lambda": 3.2504684309999998, 
        "n0": 0.0067028620000000004
    }, 
    "Pt": {
        "E0": -5.4690194910000001, 
        "S0": 1.6319105890000001, 
        "V0": 4.5014003269999998, 
        "eta2": 1.582931968, 
        "kappa": 2.4178183013755556, 
        "lambda": 3.2395920949999999, 
        "n0": 0.054604415000000003
    }, 
    "Sc": {
        "E0": -3.0779471100000002, 
        "S0": 2.1731533810000001, 
        "V0": 2.5745236770000002, 
        "eta2": 1.2382424679999999, 
        "kappa": 1.8099412872660992, 
        "lambda": 2.066166409, 
        "n0": 0.022738418999999999
    }, 
    "Sr": {
        "E0": -1.670405731, 
        "S0": 2.4918754729999999, 
        "V0": 1.982958306, 
        "eta2": 1.516570357, 
        "kappa": 2.4614661413306957, 
        "lambda": 2.0463723169999999, 
        "n0": 0.013800264
    }, 
    "Y": {
        "E0": -3.5825547100000001, 
        "S0": 2.3896672140000002, 
        "V0": 2.6562434599999998, 
        "eta2": 1.092261548, 
        "kappa": 1.6002368871918242, 
        "lambda": 1.776140748, 
        "n0": 0.021228087
    }
}

# deprecated
EMT2013_Pt_alloy_parameters_250715 = {
    "Calculator": "EMT2013_V1", 
    "Ca": {
        "E0": -1.7783844769999999, 
        "S0": 2.3207873669999999, 
        "V0": 1.7487792019999999, 
        "eta2": 1.643423525, 
        "kappa": 2.579660357942219, 
        "lambda": 2.1458927110000001, 
        "n0": 0.012849246
    }, 
    "Mg": {
        "E0": -1.3206012890000001, 
        "S0": 1.94528832, 
        "V0": 0.71022394799999999, 
        "eta2": 2.0100934119999998, 
        "kappa": 2.1985967836859812, 
        "lambda": 2.981916214, 
        "n0": 0.010593259000000001
    }, 
    "Pt": {
        "E0": -5.4690194910000001, 
        "S0": 1.6319105890000001, 
        "V0": 4.5014003269999998, 
        "eta2": 1.582931968, 
        "kappa": 2.4178183013755556, 
        "lambda": 3.2395920949999999, 
        "n0": 0.054604415000000003
    }, 
    "Sc": {
        "E0": -3.2699727200000002, 
        "S0": 2.1428815569999999, 
        "V0": 0.91602799000000001, 
        "eta2": 1.6397542629999999, 
        "kappa": 1.4131987720478962, 
        "lambda": 2.0954509799999999, 
        "n0": 0.011776643999999999
    }, 
    "Sr": {
        "E0": -1.684364797, 
        "S0": 2.5009992560000001, 
        "V0": 1.6174232079999999, 
        "eta2": 1.6344501250000001, 
        "kappa": 2.6102810758615762, 
        "lambda": 1.8502186359999999, 
        "n0": 0.010840564
    }, 
    "Y": {
        "E0": -3.4039091039999998, 
        "S0": 2.386223786, 
        "V0": 2.4297276760000002, 
        "eta2": 1.20883626, 
        "kappa": 1.6838355706696309, 
        "lambda": 1.9239417560000001, 
        "n0": 0.018047588999999999
    }
}

# This is the latest and greatest!
EMT2013_Pt_alloy_parameters_290715 = {
    "Calculator": "EMT2013_V1", 
    "Ca": {
        "E0": -1.722255665, 
        "S0": 2.4102840720000001, 
        "V0": 1.578270879, 
        "eta2": 1.5411216080000001, 
        "kappa": 2.3287000897481689, 
        "lambda": 2.0355405549999999, 
        "n0": 0.011461703
    }, 
    "Mg": {
        "E0": -1.2819211829999999, 
        "S0": 1.968297046, 
        "V0": 0.79161697200000003, 
        "eta2": 1.881789406, 
        "kappa": 2.1141030921011161, 
        "lambda": 2.9973195669999999, 
        "n0": 0.011237461000000001
    }, 
    "Pt": {
        "E0": -5.4690194910000001, 
        "S0": 1.6319105890000001, 
        "V0": 4.5014003269999998, 
        "eta2": 1.582931968, 
        "kappa": 2.4178183013755556, 
        "lambda": 3.2395920949999999, 
        "n0": 0.054604415000000003
    }, 
    "Sc": {
        "E0": -3.3607341339999999, 
        "S0": 2.0724971540000001, 
        "V0": 1.3502549399999999, 
        "eta2": 1.6455995830000001, 
        "kappa": 1.8322172058316732, 
        "lambda": 2.3356346289999999, 
        "n0": 0.014453822
    }, 
    "Sr": {
        "E0": -1.617785249, 
        "S0": 2.565848243, 
        "V0": 1.5642888699999999, 
        "eta2": 1.598526653, 
        "kappa": 2.4651738231484601, 
        "lambda": 1.861871305, 
        "n0": 0.0094338619999999995
    }, 
    "Y": {
        "E0": -3.6608584959999999, 
        "S0": 2.3379675830000002, 
        "V0": 1.2626295430000001, 
        "eta2": 1.553873047, 
        "kappa": 1.5262230178041527, 
        "lambda": 2.0056127510000001, 
        "n0": 0.010736723
    }
}

EMT2013_Pt_alloy_parameters = EMT2013_Pt_alloy_parameters_290715
