#!/usr/bin/env python3
from __future__ import annotations

import logging

from module_qc_tools.utils.hardware_control_base import hardware_control_base

log = logging.getLogger(__name__)


class multimeter(hardware_control_base):
    def __init__(self, config, name="multimeter", *args, **kwargs):
        self.dcv_cmd = []
        super().__init__(config, name, *args, **kwargs)
        if any(["emulator" in dcv_cmd for dcv_cmd in self.dcv_cmd]):
            log.info(f"[{name}] running multimeter emulator!!")

    def measure_dcv(self, channel=0):

        return self.send_command_and_read(
            self.dcv_cmd[channel],
            purpose=f"read voltage channel {channel}",
            unit="V",
        )
