# module-qc-tools v1.0.0

A general python tool for running ITkPixV1.1 module QC tests

## Table of contents

1. [Requirements](#requirements)
2. [Installation](#installation)
3. [Usage](#usage)
4. [Configuration and external commands](#configuration-and-external-commands)
5. [Measurements](#measurements)
   1. [ADC calibration](#adc-calibration)
   2. [SLDOVI](#sldovi)
   3. [VCal calibration](#vcal-calibration)
   4. [Analog readback](#analog-readback)
   5. [Injection capacitance](#injection-capacitance)
6. [Schema check](#schema-check)
7. [For developer](#for-developer)

## Requirements

This tool requires users to have >= python3.7 with the following packages
installed:

- `numpy`
- `tabulate`

Check the local python version with `python -V`. If the local python version is
lower than Python 3.7, set up a virtual python environment following the
instructions [here](https://itk.docs.cern.ch/general/Virtual_Environments/).

In addition, users shall install `YARR` and prepare external scripts for remote
control of power supply, multimeter and NTC readout. The external scripts shall
follow a fixed format, which is detailed in the later section.

## Installation

This package may be accessed by cloning from gitlab or by installing it via pip.

### via clone

First clone the project:

```
git clone https://gitlab.cern.ch/atlas-itk/pixel/module/module-qc-tools.git
```

Upon a successful checkout, `cd` to the new `module-qc-tools` directory and run
the following to install the necessary software:

```verbatim
$ python -m venv venv
$ source venv/bin/activate
$ python -m pip install --upgrade pip
$ python -m pip install -e .
```

### via pip

```
python -m venv venv
source venv/bin/activate
python -m pip install -U pip
python -m pip install module-qc-tools --index-url=https://token:$GITLAB_API_TOKEN@gitlab.cern.ch/api/v4/projects/139533/packages/pypi/simple --extra-index-url="https://pypi.org/simple"
```

## Usage

After installation, one just needs to enter the virtual environment in each new
session to use the scripts:

```verbatim
source venv/bin/activate
```

The first step in using this package is to set up the
[Configuration and external commands](#configuration-and-external-commands)
input json file. This json file is then passed as input to the scripts used to
run the [Measurements](#measurements).

## Configuration and external commands

All the configuration/settings are defined in a single json file. Examples are
provided in `$(module-qc-tools --prefix)/configs/':

```
example_merged_vmux_L0.json --> Layer 0
example_merged_vmux_L1.json --> Layer 1
example_merged_vmux_L2.json --> Layer 2
```

Please choose the correct layer so that the measurements are performed properly.
This is especially important for the SLDO test.

<details> <summary> $(module-qc-tools --prefix)/configs/example_merged_vmux_L2.json </summary>

```json
{
        "yarr": {
                "run_dir": "../Yarr",
                "controller": "configs/controller/specCfg-rd53b-16x1.json",
                "scanConsole_exe": "./bin/scanConsole",
                "write_register_exe": "./bin/write-register",
                "read_adc_exe": "./bin/read-adc"
        },
        "power_supply": {
                "run_dir": "../labRemote",
                "on_cmd": "./build/bin/powersupply -e ./src/configs/input-hw.json -n PS -c 1 power-on",
                "off_cmd": "./build/bin/powersupply -e ./src/configs/input-hw.json -n PS -c 1 power-off",
                "set_cmd": "./build/bin/powersupply -e ./src/configs/input-hw.json -n PS -c 1 set-current {i} {v}",
                "getI_cmd": "./build/bin/powersupply -e ./src/configs/input-hw.json -n PS -c 1 meas-current",
                "getV_cmd": "./build/bin/powersupply -e ./src/configs/input-hw.json -n PS -c 1 meas-voltage"
        },
        "multimeter": {
                "run_dir": "../labRemote",
                "dcv_cmd": [
                        "./build/bin/meter -e ./src/configs/input-hw-min_marija.json -n myVmuxMeter -c 0 meas-voltage"
                ]
        },
        "ntc": {
                "run_dir": "../labremote_devel/scripts",
                "cmd": "python measureT.py"
        },
        "tasks": {
                "SLDO": {...}
		"VCAL_CALIBRATION": {...}
		"ANALOG_READBACK": {...}
		"ADC_CALIBRATION": {...}
		"INJECTION_CAPACITANCE": {...}
        }
}
```

</details>

The major blocks (e.g. `yarr`, `power_supply`, `multimeter`, `ntc`) correspond
to how the scripts will communicate with the module via YARR and how they will
communicate with the lab equipment. Each of these blocks are explained in the
following sections. The `task` block specifies the settings of each scan
performed by the scripts, and will be explained in the
[Measurements](#measurements) section.

### yarr

The `yarr` block specifies the path to the `YARR` repository as well as the
corresponding YARR configuration files.

- `run_dir`: path (relative or absolute) to the directory where `YARR` commands
  should be run
- `controller`: path (relative to `run_dir` or absolute) to the controller file
- `scanConsole_exe`": path (relative to `run_dir` or absolute) to the
  `scanConsole` executable
- `write_register_exe`": path (relative to `run_dir` or absolute) to the
  `write_register` executable
- `read_adc_exe`": path (relative to `run_dir` or absolute) to the `read_adc`
  executable

### power_supply

The `power_supply` block specifies the path and the commands for handling the
power supply

- `run_dir`: path (relative or absolute) to the directory where `power_supply`
  commands should be run
- `on_cmd`: command to turn on the power supply with specified voltage and
  current. Use the syntax `{v}` and `{i}` to represent the voltage and current
  that are to be given as input arguments
- `off_cmd`: command to turn off the power supply
- `set_cmd`: command to set voltage and current for power supply. Use the syntax
  `{v}` and `{i}` to represent the voltage and current that are to be given as
  input arguments
- `getI_cmd`: command to measure current of the power supply. This command shall
  return a std output which represents the value of the current (float in the
  unit of [A]). For example, when I = 5.2A, `getI_cmd` returns std output =
  `5.2`.
- `getV_cmd`: command to measure voltage of the power supply. This command shall
  return a std output which represents the value of the voltage (float in the
  unit of [V]). For example, when V = 1.8A, `getV_cmd` returns std output =
  `1.8`.

### multimeter

The `multimeter` block specifies the path and the commands for handling the
multimeter

- `run_dir`: path (relative or absolute) to the directory where `multimeter`
  commands should be run
- `dcv_cmd`: list of commands to measure voltage from the multimeter. Each
  command corresponds to a single multimeter channel (only the used channels
  need to be listed). Each command returns a std output which represents the
  value of measured voltage (float in the unit of [V]). For example, when V =
  0.352V, `dcv_cmd` returns std output = `0.352`.

### ntc

The `ntc` block specifies the path and the commands for handling the NTC

- `run_dir`: path (relative or absolute) to the directory where `ntc` commands
  should be run
- `cmd`: command to measure temperature from the module NTC. The command returns
  a std output which represents the value of measured temperature (float in the
  unit of [C]). For example: when T = 36.2C, `cmd` returns std output = `36.2`.

## Measurements

An overview of the steps in the module QC procedure is documented in the
[Electrical specification and QC procedures for ITkPixV1.1 modules](https://gitlab.cern.ch/atlas-itk/pixel/module/itkpix-electrical-qc/)
document and in
[this spreadsheet](https://docs.google.com/spreadsheets/d/1qGzrCl4iD9362RwKlstZASbhphV_qTXPeBC-VSttfgE/edit#gid=989740987).
Each measurement is performed with one script. All scripts assume that the
modules to be tested are already powered on.

### ADC calibration

`measurement-ADC-CALIBRATION`

This script will run the ADC calibration (`task = ADC_CALIBRATION`) as specified
in the input configuration json file (i.e.
`$(module-qc-tools --prefix)/configs/example_merged_vmux_L2.json`).

<details> <summary> Configuration settings </summary>

- `v_max`: the voltage to be set to the power supply (i.e. the max voltage since
  the power supply should operate in constant current)
- `i_config`: the current at which the module should be configured
- `MonitorV`: list of Vmux channels to be measured
- `InjVcalRange`: the range of the calibration injection circuit(1: a large
  range and 0: a small range i.e. half the large range but a finer step)
- `Range`: the DACs scan range ["start", "stop", "step"]
- `share_vmux`: whether to merge the Vmux channels or not
- `v_mux_channels`: multimeter channel to measure the Vmux for each chip
  (correspond to each element in the dcv_cmd in the multimeter block)

</details>

<details> <summary> Help message </summary>

```
$ measurement-ADC-CALIBRATION --help
usage: measurement-ADC-CALIBRATION [-h] [-c CONFIG] [-i [INPUT_FILE [INPUT_FILE ...]]] [-o OUTPUT_DIR] [--verbose] [-m MODULE_CONNECTIVITY] [--permodule]

optional arguments:
  -h, --help            show this help message and exit
  -c CONFIG, --config CONFIG
                        Config file
  -i [INPUT_FILE [INPUT_FILE ...]], --input-file [INPUT_FILE [INPUT_FILE ...]]
                        input file if exists
  -o OUTPUT_DIR, --output-dir OUTPUT_DIR
                        output directory
  -m MODULE_CONNECTIVITY, --module-connectivity MODULE_CONNECTIVITY
                        path to the module connectivity. Used also to identify the module SN, and to set the default output directory
  --verbose             verbose mode
  --permodule           Store results in one file per module (default: one file per chip)
```

</details>

<details> <summary> Example </summary>

```
measurement-ADC-CALIBRATION -c $(module-qc-tools --prefix)/configs/example_merged_vmux_L2.json -m ~/module_data/20UPGR91301046/20UPGR91301046_L2_warm.json
```

</details>

<details> <summary> Example command to run on the toy emulator </summary>

```
measurement-ADC-CALIBRATION -c $(module-qc-tools --prefix)/configs/emulator_merged_vmux_L2.json -o emulator/outputs/
```

</details>

### SLDOVI

`measurement-SLDO`

This script will run the VI scans (`task = SLDO`) as specified in the input
configuration json file (i.e.
`$(module-qc-tools --prefix)/configs/example_merged_vmux_L2.json`).

<details> <summary> Configuration settings </summary>

- `v_max`: the voltage to be set to the power supply (i.e. the max voltage since
  the power supply should operate in constant current)
- `i_config`: the current at which the module should be configured
- `i_min`: the minimum current of the VI scan
- `i_max`: the maximum current of the VI scan
- `n_points`: how many points should be measured (equally spread between the max
  of the min currents)
- `extra_i`: extra current points to be measured
- `v_mux`: list of Vmux channels to be measured
- `i_mux`: list of Imux channels to be measured
- `share_vmux`: whether to merge the Vmux channels or not
- `v_mux_channels`: multimeter channel to measure the Vmux for each chip
  (correspond to each element in the dcv_cmd in the multimeter block)

</details>

<details> <summary> Help message </summary>

```
$ measurement-SLDO --help
usage: measurement-SLDO [-h] [-c CONFIG] [-i [INPUT_FILE [INPUT_FILE ...]]] [-o OUTPUT_DIR] [-m MODULE_CONNECTIVITY] [--permodule]
                        [--verbose]

optional arguments:
  -h, --help            show this help message and exit
  -c CONFIG, --config CONFIG
                        Config file
  -i [INPUT_FILE [INPUT_FILE ...]], --input-file [INPUT_FILE [INPUT_FILE ...]]
                        input file if exists
  -o OUTPUT_DIR, --output-dir OUTPUT_DIR
                        output directory
  -m MODULE_CONNECTIVITY, --module-connectivity MODULE_CONNECTIVITY
                        path to the module connectivity. Used also to identify the module SN, and to
                        set the default output directory
  --permodule           Store results in one file per module (default: one file per chip)
  --verbose             verbose mode
```

</details>

<details> <summary> Example </summary>

```
measurement-SLDO -c $(module-qc-tools --prefix)/configs/example_merged_vmux_L2.json -m ~/module_data/20UPGR91301046/20UPGR91301046_L2_warm.json
```

</details>

<details> <summary> Example command to run on the toy emulator </summary>

```
measurement-SLDO -c $(module-qc-tools --prefix)/configs/emulator_merged_vmux_L2.json -o emulator/outputs
```

</details>

### VCal calibration

`measurement-VCAL-CALIBRATION`

This script will run the VCal calibration (`task = VCAL_CALIBRATION`) as
specified in the input configuration json file (i.e.
`$(module-qc-tools --prefix)/configs/example_merged_vmux_L2.json`).

<details> <summary> Configuration settings </summary>

- `v_max`: the voltage to be set to the power supply (i.e. the max voltage since
  the power supply should operate in constant current)
- `i_config`: the current at which the module should be configured
- `InjVcalRange`: the range of the calibration injection circuit(1: a large
  range and 0: a small range i.e. half the large range but a finer step)
- `MonitorV`: two DACs VMUX assignments Vcal_med(8) and Vcal_high(7)
- `MonitorV_GND`: the GNDA VMUX assignment 30
- `Large_Range`: the large DACs scan range ["start", "stop", "step"]
- `Small_Range`: the small DACs scan range ["start", "stop", "step"]
- `share_vmux`: whether to merge the Vmux channels or not
- `v_mux_channels`: multimeter channel to measure the Vmux for each chip
  (correspond to each element in the dcv_cmd in the multimeter block)

</details>

<details> <summary> Help message </summary>

```
$ measurement-VCAL-CALIBRATION --help
usage: measurement-VCAL-CALIBRATION [-h] [-c CONFIG] [-o OUTPUT_DIR] [-m MODULE_CONNECTIVITY] [--verbose] [--permodule]

optional arguments:
  -h, --help            show this help message and exit
  -c CONFIG, --config CONFIG
                        Config file
  -o OUTPUT_DIR, --output-dir OUTPUT_DIR
                        output directory
  -m MODULE_CONNECTIVITY, --module-connectivity MODULE_CONNECTIVITY
                        path to the module connectivity. Used also to identify the module SN, and to
                        set the default output directory
  --verbose             verbose mode
  --permodule           Store results in one file per module (default: one file per chip)
```

</details>

<details> <summary> Example </summary>

```
measurement-VCAL-CALIBRATION -c $(module-qc-tools
--prefix)/configs/example_merged_vmux_L2.json -m
~/module_data/20UPGR91301046/20UPGR91301046_L2_warm.json

```

</details>

<details> <summary> Example command to run on the toy emulator </summary>

```
measurement-VCAL-CALIBRATION -c $(module-qc-tools
--prefix)/configs/emulator_merged_vmux_L2.json -o emulator/outputs/

```

</details>

### Analog readback

`measurement-ANALOG-READBACK`

This script will measure all internal voltages available through VMUX and IMUX,
measure the chip temperature, and measure VDDA/VDDD vs Trim. channels. The scan
settings are defined in the `task = ANALOG_READBACK` block of the input
configuration file (i.e.
`$(module-qc-tools --prefix)/configs/example_merged_vmux_L2.json`). The NTC
needs to be set in order to run this script, so that the temperature can be
read.

<details> <summary> Configuration settings </summary>

- `v_max`: the voltage to be set to the power supply (i.e. the max voltage since
  the power supply should operate in constant current)
- `i_config`: the current at which the module should be configured
- `v_mux`: list of Vmux channels to be measured
- `i_mux`: list of Imux channels to be measured
- `v_mux_ntc`: list of Vmux channels to be measured for ntc temperature
- `i_mux_ntc`: list of Imux channels to be measured for ntc temperature
- `v_mux_tempsens`: list of Vmux channels to be measured for 3 temperature
  sensors
- `MonSensSldoDigSelBias`: Bias 0 and 1 for MOS sensor near digital SLDO
- `MonSensSldoAnaSelBias`: Bias 0 and 1 for MOS sensor near analog SLDO
- `MonSensAcbSelBias`: Bias 0 and 1 for MOS sensor near center
- `MonSensSldoDigDem`: Dem 0-15 for MOS sensor near digital SLDO
- `MonSensSldoAnaDem`: Dem 0-15 for MOS sensor near analog SLDO
- `MonSensAcbDem`: Dem 0-15 for MOS sensor near center
- `share_vmux`: whether to merge the Vmux channels or not
- `v_mux_channels`: multimeter channel to measure the Vmux for each chip
  (correspond to each element in the dcv_cmd in the multimeter block)

</details>

<details> <summary> Help message </summary>

```
usage: measurement-ANALOG-READBACK [-h] [-c CONFIG] [-i [INPUT_FILE [INPUT_FILE ...]]] [-o OUTPUT_DIR]
                                   [-m MODULE_CONNECTIVITY] [--verbose] [--permodule]

optional arguments:
  -h, --help            show this help message and exit
  -c CONFIG, --config CONFIG
                        Config file
  -i [INPUT_FILE [INPUT_FILE ...]], --input-file [INPUT_FILE [INPUT_FILE ...]]
                        input file if exists
  -o OUTPUT_DIR, --output-dir OUTPUT_DIR
                        output directory
  -m MODULE_CONNECTIVITY, --module-connectivity MODULE_CONNECTIVITY
                        path to the module connectivity. Used also
                        to identify the module SN, and to set the default output directory
  --verbose             verbose mode
  --permodule           Store results in one file per module (default: one file per chip)
```

</details>

<details> <summary> Example </summary>

```
measurement-ANALOG-READBACK -c $(module-qc-tools
--prefix)/configs/example_merged_vmux_L2.json -m
~/module_data/20UPGR91301046/20UPGR91301046_L2_warm.json

```

</details>

<details> <summary> Example command to run on the toy emulator </summary>

```
measurement-ANALOG-READBACK -c $(module-qc-tools
--prefix)/configs/emulator_merged_vmux_L2.json -o emulator/outputs

```

</details>

### Injection capacitance

`measurement-INJECTION-CAPACITANCE`

This script will run the injection capacitance measurement
(`task = INJECTION_CAPACITANCE`) as specified in the input configuration json
file (i.e. `$(module-qc-tools --prefix)/configs/example_merged_vmux_L2.json`).

<details> <summary> Configuration settings </summary>

- `v_max`: the voltage to be set to the power supply (i.e. the max voltage since
  the power supply should operate in constant current)
- `i_config`: the current at which the module should be configured
- `n_meas`: number of measurements to perform
- `v_mux`: list of Vmux channels to be measured
- `i_mux`: list of Imux channels to be measured
- `share_vmux`: whether to merge the Vmux channels or not
- `v_mux_channels`: multimeter channel to measure the Vmux for each chip
  (correspond to each element in the dcv_cmd in the multimeter block)

</details>

<details> <summary> Help message </summary>

```
usage: measurement-INJECTION-CAPACITANCE [-h] [-c CONFIG] [-i [INPUT_FILE [INPUT_FILE ...]]]
                                         [-o OUTPUT_DIR] [-m MODULE_CONNECTIVITY] [--verbose]
                                         [--permodule]

optional arguments:
  -h, --help            show this help message and exit
  -c CONFIG, --config CONFIG
                        Config file
  -i [INPUT_FILE [INPUT_FILE ...]], --input-file [INPUT_FILE [INPUT_FILE ...]]
                        input file if exists
  -o OUTPUT_DIR, --output-dir OUTPUT_DIR
                        output directory
  -m MODULE_CONNECTIVITY, --module-connectivity MODULE_CONNECTIVITY
                        path to the module connectivity. Used also
                        to identify the module SN, and to set the default output directory
  --verbose             verbose mode
  --permodule           Store results in one file per module (default: one file per chip)
```

</details>

<details> <summary> Example </summary>

```
measurement-INJECTION-CAPACITANCE -c $(module-qc-tools
--prefix)/configs/example_merged_vmux_L2.json -m
~/module_data/20UPGR91301046/20UPGR91301046_L2_warm.json

```

</details>

<details> <summary> Example command to run on the toy emulator </summary>

```
measurement-INJECTION-CAPACITANCE -c $(module-qc-tools
--prefix)/configs/emulator_merged_vmux_L2.json -o emulator/outputs/

```

</details>

## Output data

The output of the measurements follows the structure below:

```
|** Measurements |** <test_type> |** VCAL_CALIB |** <timestamp> |\_\_
<chip_name/module_serial_number>.json

```

The test-type of each measuremnt is the corresponding test-code used in the
Production Data Base. The naming iof each measuremnet script is chosen to be the
same as the test-type. The timestamp is chosen to be the start time of the
measurement.

## Schema check

The schema for the output json files is checked based on the schema files
specified in the folder `schema`. To run the common schema check for all test
outputs, do:

```
jsonschema --instance [path to output json files] $(module-qc-tools
--prefix)/schema/common.json

```

To run the further schema check for a specific test output, do:

```
jsonschema --instance [path to output json files] $(module-qc-tools
--prefix)/schema/[qc_task].json
```

<details> <summary> Example (with the emulator output files) </summary>

```
jsonschema --instance emulator/outputs/SLDO_reference/<timestamp>/chip1.json
$(module-qc-tools --prefix)/schema/common.json jsonschema --instance
emulator/outputs/SLDO_reference/<timestamp>/chip1.json $(module-qc-tools
--prefix)/schema/SLDO.json
```

</details>

## For Developer

### versioning

In case you need to tag the version of the code, you need to have either `hatch`
or `pipx` installed.

1. Activate python environment, e.g. `source venv/bin/activate`.
2. Run `python -m pip install hatch` or `python -m pip install pipx`.

You can bump the version via:

```
pipx run hatch run tag x.y.z

# or

hatch run tag x.y.z
```

where `x.y.z` is the new version to use. This should be run from the default
branch (`main` / `master`) as this will create a commit and tag, and push for
you. So make sure you have the ability to push directly to the default branch.

### pre-commit

Install pre-commit to avoid CI failure. Once pre-commit is installed, a git hook
script will be run to identify simple issues before submission to code review.

Instruction for installing pre-commit in a python environment:

1. Activate python environment, e.g. `source venv/bin/activate`.
2. Run `python3 -m pip install pre-commit`.
3. Run `pre-commit install` to install the hooks in `.pre-commit-config.yaml`.

After installing pre-commit, `.pre-commit-config.yaml` will be run every time
`git commit` is done. Redo `git add` and `git commit`, if the pre-commit script
changes any files.
