# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['arkfunds']

package_data = \
{'': ['*']}

install_requires = \
['pandas>=1.3.0,<2.0.0', 'requests>=2.26.0,<3.0.0']

setup_kwargs = {
    'name': 'arkfunds',
    'version': '0.2.2',
    'description': 'Python library for monitoring Ark Invest funds data.',
    'long_description': '# arkfunds-python\n\nA Python library for monitoring [Ark Invest funds](https://ark-funds.com/) data.\n\n## Installation\nInstall the latest release from [PyPI](https://pypi.org/project/arkfunds/):\n\n```bash\npip install arkfunds\n```\n\n## Quickstart\n```python\nfrom arkfunds import ETF, Stock\n\n# ARK ETFs\netf = ETF("ARKK")\n\netf.profile()\netf.holdings()\netf.trades()\netf.news()\n\n# Stocks\nsymbols = ["tsla", "coin", "tdoc"]\nstock = Stock(symbols)\n\nstock.profile()\nstock.fund_ownership()\nstock.trades()\n\nstock.price()\nstock.price_history()\n```\n\n## Usage: ARK ETFs\n```python\nfrom arkfunds import ETF\narkk = ETF(\'<ark fund symbols>\')\n```\n\n### ETF Profile\n```python\nimport json\nfrom arkfunds import ETF\nsymbols = ["ARKF", "ARKK", "ARKX"]\netfs = ETF(symbols)\n\ndf = etfs.profile()\nprint(df)\n\n# Output:\n#   symbol                                name                                        description          fund_type inception_date      cusip          isin                            website\n# 0   ARKF              Fintech Innovation ETF  ARKF is an actively managed Exchange Traded Fu...  Active Equity ETF     2019-02-04  00214Q708  US00214Q7088  https://ark-funds.com/fintech-etf\n# 1   ARKK                  ARK Innovation ETF  ARKK is an actively managed ETF that seeks lon...  Active Equity ETF     2014-10-31  00214Q104  US00214Q1040         https://ark-funds.com/arkk\n# 2   ARKX  Space Exploration & Innovation ETF  ARKX is an actively-managed exchange-traded fu...  Active Equity ETF     2021-03-30  00214Q807  US00214Q8078         https://ark-funds.com/arkx\n```\n\n### ETF Holdings\n```python\nfrom arkfunds import ETF\narkk = ETF(\'ARKK\')\n\ndf = arkk.holdings()\nprint(df.head(5))\n\n# Output:\n#    fund        date                company ticker      cusip   shares  market_value  weight  weight_rank\n# 0  ARKK  2021-07-29              TESLA INC   TSLA  88160R101  3551176  2.297540e+09   10.14            1\n# 1  ARKK  2021-07-29               ROKU INC   ROKU  77543R102  3094614  1.449362e+09    6.39            2\n# 2  ARKK  2021-07-29     TELADOC HEALTH INC   TDOC  87918A105  8785584  1.333740e+09    5.88            3\n# 3  ARKK  2021-07-29         SQUARE INC - A     SQ  852234103  4565037  1.180564e+09    5.21            4\n# 4  ARKK  2021-07-29  SHOPIFY INC - CLASS A   SHOP  82509L107   707932  1.088799e+09    4.80            5\n```\n\n### ETF Trades\n```python\nfrom arkfunds import ETF\narkk = ETF(\'ARKK\')\n\ndf = arkk.trades()\nprint(df)\n\n# Output:\n#     fund        date direction ticker                      company      cusip  shares  etf_percent\n# 0   ARKK  2021-07-28       Buy   TDOC           TELADOC HEALTH INC  87918A105  311612       0.2043\n# 1   ARKK  2021-07-28       Buy   SPOT        SPOTIFY TECHNOLOGY SA  L8681T102  201549       0.1966\n# 2   ARKK  2021-07-28      Sell   BEKE              KE HOLDINGS INC  482497104   41500       0.0052\n# 3   ARKK  2021-07-28      Sell   TWST        TWIST BIOSCIENCE CORP  90184D100   89660       0.0464\n# 4   ARKK  2021-07-28      Sell   SKLZ                   SKILLZ INC  83067L109  921897       0.0592\n# 5   ARKK  2021-07-28      Sell   ROKU                     ROKU INC  77543R102   47200       0.0987\n# 6   ARKK  2021-07-28      Sell   PSTG             PURE STORAGE INC  74624M102      85       0.0000\n# 7   ARKK  2021-07-28      Sell  NTDOY              NINTENDO CO LTD  654445303   25100       0.0076\n# 8   ARKK  2021-07-28      Sell   IOVA  IOVANCE BIOTHERAPEUTICS INC  462260100  413807       0.0427\n# 9   ARKK  2021-07-28      Sell   DOCU                 DOCUSIGN INC  256163106   65768       0.0893\n# 10  ARKK  2021-07-28      Sell    TXG             10X GENOMICS INC  88025U109   89643       0.0752\n```\n\n### ETF News\n```python\nfrom arkfunds import ETF\narkk = ETF(\'ARKK\')\n\ndf = arkk.news()\nprint(df.head(5))\n\n# Output: \n#      id                   datetime related  ...                                            summary                                                url                                              image\n# 0  2101  2021-07-23T08:42:00+00:00    ARKK  ...  One of Cathie Wood\'s ARK Invest funds bought o...  https://247wallst.com/investing/2021/07/23/cat...  https://247wallst.com/wp-content/uploads/2020/...\n# 1  2102  2021-07-23T06:39:00+00:00    ARKK  ...                                                     https://www.gurufocus.com/news/1483143/cra-fin...                                                   \n# 2  2095  2021-07-22T13:42:00+00:00    ARKK  ...  Ark Invest founder and CEO Cathie Wood achieve...  https://www.benzinga.com/news/21/07/22110608/e...  https://cdn.benzinga.com/files/imagecache/og_i...\n# 3  2103  2021-07-22T11:10:00+00:00    ARKK  ...  When it comes to innovation and making your wo...  https://investorplace.com/2021/07/7-best-etfs-...  https://investorplace.com/wp-content/uploads/2...\n# 4  2090  2021-07-22T10:51:00+00:00    ARKK  ...  The coronavirus pandemic is fast becoming one ...  https://www.marketwatch.com/story/biden-says-c...           https://images.mktw.net/im-373488/social\n#\n# [5 rows x 8 columns]                                                 \n```\n\n## Usage: Stocks\n```python\nfrom arkfunds import Stock\nstock = Stock(\'<symbols>\')\n```\n\n### Stock Profile\n```python\nimport json\nfrom arkfunds import Stock\ntsla = Stock(\'TSLA\')\n\ndf = tsla.profile()\nprint(df)\nprint(df.columns.to_list())\n\n# Output:\n#   ticker         name        country            industry             sector  fullTimeEmployees  ...               website     market  exchange currency     marketCap  sharesOutstanding\n# 0   TSLA  Tesla, Inc.  United States  Auto Manufacturers  Consumer Cyclical              70757  ...  http://www.tesla.com  us_market  NasdaqGS      USD  6.232552e+11          963329984\n# \n# [1 rows x 13 columns]\n#\n# [\'ticker\', \'name\', \'country\', \'industry\', \'sector\', \'fullTimeEmployees\', \'summary\', \'website\', \'market\', \'exchange\', \'currency\', \'marketCap\', \'sharesOutstanding\']\n```\n\n### Stock Fund Ownership\n```python\nfrom arkfunds import Stock\ntsla = Stock(\'TSLA\')\n\ndf = tsla.fund_ownership()\nprint(df)\n\n# Output:\n#   ticker        date  fund  weight  weight_rank   shares  market_value\n# 0   TSLA  2021-07-29  ARKK   10.14            1  3551176  2.297540e+09\n# 1   TSLA  2021-07-29  ARKQ   11.33            1   478166  3.093638e+08\n# 2   TSLA  2021-07-29  ARKW    9.87            1   898972  5.816169e+08\n```\n\n### Stock Trades\n```python\nfrom arkfunds import Stock\ntsla = Stock(\'TSLA\')\n\ndf = tsla.trades()\nprint(df)\n\n# Output:\n#           date  fund direction ticker    company      cusip  shares  etf_percent\n# 0   2021-07-07  ARKK       Buy   TSLA  TESLA INC  88160R101  110731       0.2941\n# 1   2021-06-04  ARKK       Buy   TSLA  TESLA INC  88160R101    4977       0.0144\n# 2   2021-06-04  ARKQ       Buy   TSLA  TESLA INC  88160R101    3068       0.0612\n# 3   2021-06-04  ARKW       Buy   TSLA  TESLA INC  88160R101    4718       0.0521\n# 4   2021-05-19  ARKK       Buy   TSLA  TESLA INC  88160R101   43065       0.1220\n# ..         ...   ...       ...    ...        ...        ...     ...          ...\n# 66  2020-09-24  ARKQ       Buy   TSLA  TESLA INC  88160R101    2639       0.1582\n# 67  2020-09-24  ARKW       Buy   TSLA  TESLA INC  88160R101   19794       0.3054\n# 68  2020-09-23  ARKK       Buy   TSLA  TESLA INC  88160R101  142166       0.6770\n# 69  2020-09-23  ARKW       Buy   TSLA  TESLA INC  88160R101   22190       0.3682\n# 70  2020-09-18  ARKK      Sell   TSLA  TESLA INC  88160R101   85200       0.4400\n# \n# [71 rows x 8 columns]\n```\n\n### Stock Prices\n```python\nfrom arkfunds import Stock\nsymbols = ["tsla", "coin", "tdoc"]\nstock = Stock(symbols)\n\ndf = stock.price()\nprint(df)\n# Output:\n#   ticker currency   price    change   changep          last_trade exchange\n# 0   TSLA      USD  646.98  2.199951  0.341194 2021-07-28 20:00:03      NMS\n# 1   COIN      USD  241.75  6.669998  2.837331 2021-07-28 20:00:02      NMS\n# 2   TDOC      USD  151.81  0.800003  0.529768 2021-07-28 20:00:02      NYQ\n\ndf = stock.price_history(days_back=7, frequency="d")\nprint(df)\n\n# Output: \n#    Ticker       Date        Open        High         Low       Close   Adj Close    Volume\n# 0    TSLA 2021-07-22  656.440002  662.169983  644.599976  649.260010  649.260010  15105700\n# 1    TSLA 2021-07-23  646.359985  648.799988  637.299988  643.380005  643.380005  14581300\n# 2    TSLA 2021-07-26  650.969971  668.200012  647.109985  657.619995  657.619995  25044100\n# 3    TSLA 2021-07-27  663.400024  666.500000  627.239990  644.780029  644.780029  32756900\n# 4    TSLA 2021-07-28  647.000000  654.969971  639.400024  646.979980  646.979980  15970200\n# 5    COIN 2021-07-22  232.000000  232.320007  224.500000  226.080002  226.080002   2551700\n# 6    COIN 2021-07-23  226.220001  227.350006  222.729996  224.919998  224.919998   1565900\n# 7    COIN 2021-07-26  240.080002  249.800003  237.880005  245.449997  245.449997   7592500\n# 8    COIN 2021-07-27  243.000000  243.210007  229.119995  235.080002  235.080002   5615000\n# 9    COIN 2021-07-28  240.300003  242.869995  238.029999  241.750000  241.750000   2057800\n# 10   TDOC 2021-07-22  154.449997  155.369995  151.600006  152.869995  152.869995   1302300\n# 11   TDOC 2021-07-23  151.949997  152.602997  147.860001  151.589996  151.589996   1629800\n# 12   TDOC 2021-07-26  150.910004  150.919998  148.570007  149.750000  149.750000   2136300\n# 13   TDOC 2021-07-27  149.929993  152.169998  145.619995  151.009995  151.009995   2714300\n# 14   TDOC 2021-07-28  134.779999  152.289993  133.250000  151.809998  151.809998  11577300\n```\n\n## License\n\nThis project is licensed under the **MIT license**. Feel free to edit and distribute this template as you like.\n\nSee [LICENSE](LICENSE) for more information.\n',
    'author': 'Fredrik Haarstad',
    'author_email': 'codemonkey@zomg.no',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/frefrik/arkfunds-python',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
