# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['aleksis',
 'aleksis.apps.paweljong',
 'aleksis.apps.paweljong.migrations',
 'aleksis.apps.paweljong.templatetags']

package_data = \
{'': ['*'],
 'aleksis.apps.paweljong': ['locale/*',
                            'locale/de_DE/LC_MESSAGES/*',
                            'static/css/*',
                            'templates/paweljong/*',
                            'templates/paweljong/event/*',
                            'templates/paweljong/event_registration/*',
                            'templates/paweljong/info_mailing/*',
                            'templates/paweljong/print/*',
                            'templates/paweljong/registration_state/chip.html',
                            'templates/paweljong/registration_state/chip.html',
                            'templates/paweljong/registration_state/chip.html',
                            'templates/paweljong/registration_state/chip.html',
                            'templates/paweljong/registration_state/create.html',
                            'templates/paweljong/registration_state/create.html',
                            'templates/paweljong/registration_state/create.html',
                            'templates/paweljong/registration_state/create.html',
                            'templates/paweljong/registration_state/edit.html',
                            'templates/paweljong/registration_state/edit.html',
                            'templates/paweljong/registration_state/edit.html',
                            'templates/paweljong/registration_state/edit.html',
                            'templates/paweljong/registration_state/list.html',
                            'templates/paweljong/registration_state/list.html',
                            'templates/paweljong/registration_state/list.html',
                            'templates/paweljong/registration_state/list.html',
                            'templates/paweljong/term/*',
                            'templates/paweljong/voucher/*',
                            'templates/templated_email/*']}

install_requires = \
['aleksis-app-postbuero==1.0+20220218233830.a212f707',
 'aleksis-app-tezor>=1.0,<2.0',
 'aleksis-core>=2.8.1,<3.0.0',
 'django-formtools>=2.3,<3.0',
 'django-iban-field>=0.8,<0.9',
 'django-starfield>=1.0,<2.0']

entry_points = \
{'aleksis.app': ['paweljong = aleksis.apps.paweljong.apps:DefaultConfig']}

setup_kwargs = {
    'name': 'aleksis-app-paweljong',
    'version': '1.4',
    'description': 'AlekSIS (School Information System)\u200a—\u200aApp Paweljong (Camp/Event management)',
    'long_description': 'AlekSIS (School Information System)\u200a—\u200aApp Paweljong (Camp/Event management)\n==================================================================================================\n\nAlekSIS\n-------\n\nThis is an application for use with the `AlekSIS®`_ platform.\n\nFeatures\n--------\n\nThe author of this app did not describe it yet.\n\nLicence\n-------\n\n::\n\n  Copyright © 2018, 2021, 2022 Dominik George <dominik.george@teckids.org>\n  Copyright © 2019, 2022 Tom Teichler <tom.teichler@teckids.org>\n\n  Licenced under the EUPL, version 1.2 or later\n\nPlease see the LICENCE.rst file accompanying this distribution for the\nfull licence text or on the `European Union Public Licence`_ website\nhttps://joinup.ec.europa.eu/collection/eupl/guidelines-users-and-developers\n(including all other official language versions).\n\nTrademark\n---------\n\nAlekSIS® is a registered trademark of the AlekSIS open source project, represented\nby Teckids e.V. Please refer to the `trademark policy`_ for hints on using the trademark\nAlekSIS®.\n\n.. _AlekSIS®: https://edugit.org/AlekSIS/AlekSIS\n.. _European Union Public Licence: https://eupl.eu/\n.. _trademark policy: https://aleksis.org/pages/about\n',
    'author': 'Tom Teichler',
    'author_email': 'tom.teichler@teckids.org',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://hacknfun.camp',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
