# Generated by Django 3.2.9 on 2021-11-30 15:23

import django.contrib.sites.managers
from django.db import migrations, models
import django.db.models.deletion
import django_iban.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('core', '0035_preference_model_unique'),
        ('sites', '0002_alter_domain_unique'),
    ]

    operations = [
        migrations.CreateModel(
            name='Event',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extended_data', models.JSONField(default=dict, editable=False)),
                ('display_name', models.CharField(max_length=255, verbose_name='Display name')),
                ('description', models.CharField(max_length=500, verbose_name='Description')),
                ('published', models.BooleanField(default=False, verbose_name='Publish')),
                ('place', models.CharField(max_length=50, verbose_name='Place')),
                ('date_event', models.DateField(verbose_name='Date of event')),
                ('date_registration', models.DateField(verbose_name='Registration deadline')),
                ('date_retraction', models.DateField(verbose_name='Retraction deadline')),
                ('cost', models.IntegerField(verbose_name='Cost in €')),
                ('max_participants', models.PositiveSmallIntegerField(verbose_name='Maximum participants')),
            ],
            options={
                'abstract': False,
            },
            managers=[
                ('objects', django.contrib.sites.managers.CurrentSiteManager()),
            ],
        ),
        migrations.CreateModel(
            name='Voucher',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extended_data', models.JSONField(default=dict, editable=False)),
                ('code', models.CharField(blank=True, default='', max_length=8)),
                ('discount', models.IntegerField(default=100)),
                ('used', models.BooleanField(default=False)),
                ('deleted', models.BooleanField(default=False)),
                ('event', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='vouchers', to='paweljong.event', verbose_name='Event')),
                ('person', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='vouchers', to='core.person', verbose_name='Person')),
                ('site', models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='sites.site')),
                ('used_person_uid', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='used_vouchers', to='core.person', verbose_name='Used by')),
            ],
            options={
                'verbose_name': 'Vouchers',
                'verbose_name_plural': 'Vouchers',
            },
            managers=[
                ('objects', django.contrib.sites.managers.CurrentSiteManager()),
            ],
        ),
        migrations.CreateModel(
            name='FeedbackAspect',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extended_data', models.JSONField(default=dict, editable=False)),
                ('aspect', models.CharField(max_length=100)),
                ('site', models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='sites.site')),
            ],
            options={
                'abstract': False,
            },
            managers=[
                ('objects', django.contrib.sites.managers.CurrentSiteManager()),
            ],
        ),
        migrations.CreateModel(
            name='EventRegistration',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extended_data', models.JSONField(default=dict, editable=False)),
                ('date_registered', models.DateTimeField(auto_now_add=True, verbose_name='Registration date')),
                ('comment', models.TextField(blank=True, default='', verbose_name='Comment / remarks')),
                ('channel', models.CharField(blank=True, default='', max_length=255, verbose_name='Channel')),
                ('donation', models.PositiveIntegerField(blank=True, null=True, verbose_name='Donation')),
                ('accept_sepa', models.BooleanField(verbose_name='SEPA direct debit')),
                ('iban', django_iban.fields.IBANField(enforce_database_constraint=True, max_length=34, null=True, verbose_name='IBAN (for SEPA direct debit)')),
                ('accept_terms', models.BooleanField(verbose_name='Delcaration of consent by parents')),
                ('accept_data', models.BooleanField(verbose_name='Declaration of consent data protection')),
                ('accept_general_terms', models.BooleanField(verbose_name='Declatation of consent terms and condition')),
                ('event', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='paweljong.event', verbose_name='Event')),
                ('person', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.person', verbose_name='Person')),
                ('site', models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='sites.site')),
                ('voucher', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='paweljong.voucher', verbose_name='Voucher')),
            ],
            options={
                'verbose_name': 'Registration',
                'verbose_name_plural': 'Registrations',
            },
            managers=[
                ('objects', django.contrib.sites.managers.CurrentSiteManager()),
            ],
        ),
        migrations.CreateModel(
            name='EventFeedback',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('extended_data', models.JSONField(default=dict, editable=False)),
                ('comment_private', models.TextField(blank=True, verbose_name='Private comment')),
                ('comment_public', models.TextField(blank=True, verbose_name='Public comment')),
                ('comment_public_info', models.CharField(choices=[('first', 'Only first name'), ('first_age', 'First name and age'), ('first_last_age', 'First name, last name and age')], max_length=255, verbose_name='Information in the comment')),
                ('photos', models.ImageField(blank=True, upload_to='feedback/', verbose_name='Photos')),
                ('photos_licence', models.CharField(choices=[('CC-BY-4.0+', 'Creative Commons with attribution, 4.0 or later'), ('CC-BY-SA-4.0+', 'Creative Commons with attribution and distribution onlyunder the same conditions, 4.0 or later')], max_length=255, verbose_name='Photo licence')),
                ('event', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='feedback', to='paweljong.event', verbose_name='Event')),
                ('person', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='feedback', to='core.person', verbose_name='Person')),
                ('site', models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='sites.site')),
            ],
            options={
                'verbose_name': 'Event feedback',
                'verbose_name_plural': 'Event feedbacks',
            },
            managers=[
                ('objects', django.contrib.sites.managers.CurrentSiteManager()),
            ],
        ),
        migrations.AddField(
            model_name='event',
            name='feedback_aspects',
            field=models.ManyToManyField(related_name='event', to='paweljong.FeedbackAspect', verbose_name='Feedback aspects'),
        ),
        migrations.AddField(
            model_name='event',
            name='linked_group',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='linked_event', to='core.group', verbose_name='Group'),
        ),
        migrations.AddField(
            model_name='event',
            name='site',
            field=models.ForeignKey(default=1, editable=False, on_delete=django.db.models.deletion.CASCADE, to='sites.site'),
        ),
    ]
