import { Resource, IResource } from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { IotSql } from './iot-sql';
/**
 * (experimental) Represents an AWS IoT Rule.
 *
 * @experimental
 */
export interface ITopicRule extends IResource {
    /**
     * (experimental) The value of the topic rule Amazon Resource Name (ARN), such as arn:aws:iot:us-east-2:123456789012:rule/rule_name.
     *
     * @experimental
     * @attribute true
     */
    readonly topicRuleArn: string;
    /**
     * (experimental) The name topic rule.
     *
     * @experimental
     * @attribute true
     */
    readonly topicRuleName: string;
}
/**
 * (experimental) Properties for defining an AWS IoT Rule.
 *
 * @experimental
 */
export interface TopicRuleProps {
    /**
     * (experimental) The name of the rule.
     *
     * @default None
     * @experimental
     */
    readonly topicRuleName?: string;
    /**
     * (experimental) A simplified SQL syntax to filter messages received on an MQTT topic and push the data elsewhere.
     *
     * @see https://docs.aws.amazon.com/iot/latest/developerguide/iot-sql-reference.html
     * @experimental
     */
    readonly sql: IotSql;
}
/**
 * (experimental) Defines an AWS IoT Rule in this stack.
 *
 * @experimental
 */
export declare class TopicRule extends Resource implements ITopicRule {
    /**
     * (experimental) Import an existing AWS IoT Rule provided an ARN.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param topicRuleArn AWS IoT Rule ARN (i.e. arn:aws:iot:<region>:<account-id>:rule/MyRule).
     * @experimental
     */
    static fromTopicRuleArn(scope: Construct, id: string, topicRuleArn: string): ITopicRule;
    /**
     * (experimental) Arn of this rule.
     *
     * @experimental
     * @attribute true
     */
    readonly topicRuleArn: string;
    /**
     * (experimental) Name of this rule.
     *
     * @experimental
     * @attribute true
     */
    readonly topicRuleName: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: TopicRuleProps);
}
