"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IotSql = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * (experimental) Defines AWS IoT SQL.
 *
 * @experimental
 */
class IotSql {
    /**
     * (experimental) Uses the original SQL version built on 2015-10-08.
     *
     * @param sql The actual SQL-like syntax query.
     * @returns Instance of IotSql
     * @experimental
     */
    static fromStringAsVer20151008(sql) {
        return new IotSqlImpl('2015-10-08', sql);
    }
    /**
     * (experimental) Uses the SQL version built on 2016-03-23.
     *
     * @param sql The actual SQL-like syntax query.
     * @returns Instance of IotSql
     * @experimental
     */
    static fromStringAsVer20160323(sql) {
        return new IotSqlImpl('2016-03-23', sql);
    }
    /**
     * (experimental) Uses the most recent beta SQL version.
     *
     * If you use this version, it might
     * introduce breaking changes to your rules.
     *
     * @param sql The actual SQL-like syntax query.
     * @returns Instance of IotSql
     * @experimental
     */
    static fromStringAsVerNewestUnstable(sql) {
        return new IotSqlImpl('beta', sql);
    }
}
exports.IotSql = IotSql;
_a = JSII_RTTI_SYMBOL_1;
IotSql[_a] = { fqn: "@aws-cdk/aws-iot-alpha.IotSql", version: "2.0.0-alpha.1" };
class IotSqlImpl extends IotSql {
    constructor(version, sql) {
        super();
        this.version = version;
        this.sql = sql;
        if (sql === '') {
            throw new Error('IoT SQL string cannot be empty');
        }
    }
    bind(_scope) {
        return {
            awsIotSqlVersion: this.version,
            sql: this.sql,
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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