import { Construct } from 'constructs';
/**
 * (experimental) The type returned from the `bind()` method in {@link IotSql}.
 *
 * @experimental
 */
export interface IotSqlConfig {
    /**
     * (experimental) The version of the SQL rules engine to use when evaluating the rule.
     *
     * @experimental
     */
    readonly awsIotSqlVersion: string;
    /**
     * (experimental) The SQL statement used to query the topic.
     *
     * @experimental
     */
    readonly sql: string;
}
/**
 * (experimental) Defines AWS IoT SQL.
 *
 * @experimental
 */
export declare abstract class IotSql {
    /**
     * (experimental) Uses the original SQL version built on 2015-10-08.
     *
     * @param sql The actual SQL-like syntax query.
     * @returns Instance of IotSql
     * @experimental
     */
    static fromStringAsVer20151008(sql: string): IotSql;
    /**
     * (experimental) Uses the SQL version built on 2016-03-23.
     *
     * @param sql The actual SQL-like syntax query.
     * @returns Instance of IotSql
     * @experimental
     */
    static fromStringAsVer20160323(sql: string): IotSql;
    /**
     * (experimental) Uses the most recent beta SQL version.
     *
     * If you use this version, it might
     * introduce breaking changes to your rules.
     *
     * @param sql The actual SQL-like syntax query.
     * @returns Instance of IotSql
     * @experimental
     */
    static fromStringAsVerNewestUnstable(sql: string): IotSql;
    /**
     * (experimental) Returns the IoT SQL configuration.
     *
     * @experimental
     */
    abstract bind(scope: Construct): IotSqlConfig;
}
