"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AttributeGroup = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const validation_1 = require("./private/validation");
const aws_servicecatalogappregistry_1 = require("aws-cdk-lib/aws-servicecatalogappregistry");
class AttributeGroupBase extends cdk.Resource {
}
/**
 * (experimental) A Service Catalog AppRegistry Attribute Group.
 *
 * @experimental
 */
class AttributeGroup extends AttributeGroupBase {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_servicecatalogappregistry_alpha_AttributeGroupProps(props);
        this.validateAttributeGroupProps(props);
        const attributeGroup = new aws_servicecatalogappregistry_1.CfnAttributeGroup(this, 'Resource', {
            name: props.attributeGroupName,
            description: props.description,
            attributes: props.attributes,
        });
        this.attributeGroupArn = attributeGroup.attrArn;
        this.attributeGroupId = attributeGroup.attrId;
    }
    /**
     * (experimental) Imports an attribute group construct that represents an external attribute group.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param attributeGroupArn the Amazon Resource Name of the existing AppRegistry attribute group.
     * @experimental
     */
    static fromAttributeGroupArn(scope, id, attributeGroupArn) {
        const arn = cdk.Stack.of(scope).splitArn(attributeGroupArn, cdk.ArnFormat.SLASH_RESOURCE_SLASH_RESOURCE_NAME);
        const attributeGroupId = arn.resourceName;
        if (!attributeGroupId) {
            throw new Error('Missing required Attribute Group ID from Attribute Group ARN: ' + attributeGroupArn);
        }
        class Import extends AttributeGroupBase {
            constructor() {
                super(...arguments);
                this.attributeGroupArn = attributeGroupArn;
                this.attributeGroupId = attributeGroupId;
            }
        }
        return new Import(scope, id, {
            environmentFromArn: attributeGroupArn,
        });
    }
    validateAttributeGroupProps(props) {
        validation_1.InputValidator.validateLength(this.node.path, 'attribute group name', 1, 256, props.attributeGroupName);
        validation_1.InputValidator.validateRegex(this.node.path, 'attribute group name', /^[a-zA-Z0-9-_]+$/, props.attributeGroupName);
        validation_1.InputValidator.validateLength(this.node.path, 'attribute group description', 0, 1024, props.description);
    }
}
exports.AttributeGroup = AttributeGroup;
_a = JSII_RTTI_SYMBOL_1;
AttributeGroup[_a] = { fqn: "@aws-cdk/aws-servicecatalogappregistry-alpha.AttributeGroup", version: "2.3.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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