"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Application = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const crypto = require("crypto");
const cdk = require("aws-cdk-lib");
const validation_1 = require("./private/validation");
const aws_servicecatalogappregistry_1 = require("aws-cdk-lib/aws-servicecatalogappregistry");
class ApplicationBase extends cdk.Resource {
    constructor() {
        super(...arguments);
        this.associatedAttributeGroups = new Set();
        this.associatedResources = new Set();
    }
    /**
     * (experimental) Associate an attribute group with application If the attribute group is already associated, it will ignore duplicate request.
     *
     * @experimental
     */
    associateAttributeGroup(attributeGroup) {
        if (!this.associatedAttributeGroups.has(attributeGroup.node.addr)) {
            const hashId = this.generateUniqueHash(attributeGroup.node.addr);
            new aws_servicecatalogappregistry_1.CfnAttributeGroupAssociation(this, `AttributeGroupAssociation${hashId}`, {
                application: this.applicationId,
                attributeGroup: attributeGroup.attributeGroupId,
            });
            this.associatedAttributeGroups.add(attributeGroup.node.addr);
        }
    }
    /**
     * (experimental) Associate a stack with the application If the resource is already associated, it will ignore duplicate request.
     *
     * A stack can only be associated with one application.
     *
     * @experimental
     */
    associateStack(stack) {
        if (!this.associatedResources.has(stack.node.addr)) {
            const hashId = this.generateUniqueHash(stack.node.addr);
            new aws_servicecatalogappregistry_1.CfnResourceAssociation(this, `ResourceAssociation${hashId}`, {
                application: this.applicationId,
                resource: stack.stackId,
                resourceType: 'CFN_STACK',
            });
            this.associatedResources.add(stack.node.addr);
        }
    }
}
/**
 * (experimental) A Service Catalog AppRegistry Application.
 *
 * @experimental
 */
class Application extends ApplicationBase {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_servicecatalogappregistry_alpha_ApplicationProps(props);
        this.validateApplicationProps(props);
        const application = new aws_servicecatalogappregistry_1.CfnApplication(this, 'Resource', {
            name: props.applicationName,
            description: props.description,
        });
        this.applicationArn = application.attrArn;
        this.applicationId = application.attrId;
        this.nodeAddress = cdk.Names.nodeUniqueId(application.node);
    }
    /**
     * (experimental) Imports an Application construct that represents an external application.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param applicationArn the Amazon Resource Name of the existing AppRegistry Application.
     * @experimental
     */
    static fromApplicationArn(scope, id, applicationArn) {
        const arn = cdk.Stack.of(scope).splitArn(applicationArn, cdk.ArnFormat.SLASH_RESOURCE_SLASH_RESOURCE_NAME);
        const applicationId = arn.resourceName;
        if (!applicationId) {
            throw new Error('Missing required Application ID from Application ARN: ' + applicationArn);
        }
        class Import extends ApplicationBase {
            constructor() {
                super(...arguments);
                this.applicationArn = applicationArn;
                this.applicationId = applicationId;
            }
            generateUniqueHash(resourceAddress) {
                return hashValues(this.applicationArn, resourceAddress);
            }
        }
        return new Import(scope, id, {
            environmentFromArn: applicationArn,
        });
    }
    /**
     * (experimental) Create a unique id.
     *
     * @experimental
     */
    generateUniqueHash(resourceAddress) {
        return hashValues(this.nodeAddress, resourceAddress);
    }
    validateApplicationProps(props) {
        validation_1.InputValidator.validateLength(this.node.path, 'application name', 1, 256, props.applicationName);
        validation_1.InputValidator.validateRegex(this.node.path, 'application name', /^[a-zA-Z0-9-_]+$/, props.applicationName);
        validation_1.InputValidator.validateLength(this.node.path, 'application description', 0, 1024, props.description);
    }
}
exports.Application = Application;
_a = JSII_RTTI_SYMBOL_1;
Application[_a] = { fqn: "@aws-cdk/aws-servicecatalogappregistry-alpha.Application", version: "2.3.0-alpha.0" };
/**
 * Generates a unique hash identfifer using SHA256 encryption algorithm
 */
function hashValues(...values) {
    const sha256 = crypto.createHash('sha256');
    values.forEach(val => sha256.update(val));
    return sha256.digest('hex').slice(0, 12);
}
//# sourceMappingURL=data:application/json;base64,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