import { IdentityPool, IdentityPoolProps } from "@aws-cdk/aws-cognito-identitypool-alpha";
import { UserPool, UserPoolClient } from "aws-cdk-lib/aws-cognito";
import { Construct } from "constructs";
/**
 * Properties which configures the Identity Pool.
 */
export interface UserIdentityProps {
    /**
     * User provided Cognito UserPool.
     *
     * @default - a userpool will be created.
     */
    readonly userPool?: UserPool;
    /**
     * Configuration for the Identity Pool.
     */
    readonly identityPoolOptions?: IdentityPoolProps;
}
/**
 * Creates an Identity Pool with sane defaults configured.
 */
export declare class UserIdentity extends Construct {
    readonly userPool?: UserPool;
    readonly userPoolClient?: UserPoolClient;
    readonly identityPool: IdentityPool;
    constructor(scope: Construct, id: string, props?: UserIdentityProps);
}
//# sourceMappingURL=user-identity.d.ts.map