# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['wiki_fetch']

package_data = \
{'': ['*']}

install_requires = \
['bs4>=0.0.1,<0.0.2']

entry_points = \
{'console_scripts': ['wiki-fetch = wiki_fetch.__main__:run']}

setup_kwargs = {
    'name': 'wiki-fetch',
    'version': '0.0.0',
    'description': 'Parser for Wikipedia.org',
    'long_description': '# wiki-fetch\n\n<p>\n  <a href="https://github.com/d3z-the-dev/wiki-fetch/releases/">\n    <img alt="PyPI" src="https://img.shields.io/pypi/v/wiki-fetch" />\n  </a>\n  <a href="https://github.com/d3z-the-dev/wiki-fetch/releases/">\n    <img alt="PyPI Downloads" src="https://img.shields.io/pypi/dm/wiki-fetch" />\n  </a>\n  <a href="https://github.com/d3z-the-dev/wiki-fetch/releases/">\n    <img alt="Python Version" src="https://img.shields.io/pypi/pyversions/wiki-fetch" />\n  </a>\n  <a href="https://github.com/d3z-the-dev/wiki-fetch/releases/">\n    <img alt="License" src="https://img.shields.io/pypi/l/wiki-fetch" />\n  </a>\n  <a href="https://github.com/d3z-the-dev/wiki-fetch/releases/">\n    <img alt="Issues" src="https://img.shields.io/bitbucket/issues/d3z-the-dev/wiki-fetch" />\n  </a>\n</p>\n\n## Installation\n\n- PyPI\n\n```bash\npip install wiki-fetch\n```\n\n- Source\n\n```bash\ngit clone git@github.com:d3z-the-dev/wiki-fetch.git\ncd wiki-fetch && poetry build\npip install ./dist/*.whl\n```\n\n## Usage\n\n### CLI\n\n| Option           | Flag | Long      | Default | Example                                   |\n| ---------------- | ---- | --------- | ------- | ----------------------------------------- |\n| Wiki\'s page link | `-u` | `--url`   | None    | <https://en.wikipedia.org/wiki/The_Doors> |\n| Search query     | `-q` | `--query` | None    | The Doors (band)                          |\n| Page language    | `-l` | `--lang`  | English | English                                   |\n| Part of the page | `-p` | `--part`  | all     | infobox                                   |\n| Parts by order   | `-i` | `--item`  | all     | first                                     |\n\n```bash\nwiki-fetch -q \'The Doors (band)\' -p infobox -i first\n```\n\n<details>\n<summary>output</summary>\n\n```text\nInfobox:\n    The Doors:\n        The Doors:\n            Image 1: https://upload.wikimedia.org/wikipedia/commons/thumb/6/69/The_Doors_1968.JPG/250px-The_Doors_1968.JPG\n            Image title: The Doors in 1966: Morrison (left), Densmore (centre), Krieger (right) and Manzarek (seated)\n        Background information:\n            Origin: Los Angeles, California, U.S.\n            Genres:\n                Psychedelic Rock\n                Blues Rock\n                Acid Rock\n            Years active:\n                1965-1973\n                1978\n            Labels: Elektra, Rhino\n            Spinoffs:\n                The Psychedelic Rangers\n                Butts Band\n                Nite City\n                Manzarek-Krieger\n            Spinoff of: Rick & the Ravens\n            Past members:\n                Jim Morrison\n                Ray Manzarek\n                Robby Krieger\n                John Densmore\n            Website: thedoors.com\n```\n\n\n</details>\n\n### Python\n\n| Argument | Values                                                         | Description                         |\n| -------- | -------------------------------------------------------------- | ----------------------------------- |\n| url      | `str`                                                          | Any Wiki\'s page URL                 |\n| query    | `str`                                                          | Any query string                    |\n| lang     | `English`                                                      | Currently only English is available |\n| part     | `infobox`, `paragraph`, `table`, `list`, `thumb`, `toc`, `all` | Specify page part                   |\n| item     | `first`, `last`, `all`                                         | Specify the order of the part       |\n\n```python\nfrom wiki_fetch.driver import Wiki\n\noutput = Wiki().search(query=\'The Doors (band)\', part=\'infobox\', item=\'first\')\nprint(output.json)\n```\n\n<details>\n<summary>output</summary>\n\n```json\n{\n    "Infobox": {\n        "The Doors": {\n            "The Doors": {\n                "Image 1": "https://upload.wikimedia.org/wikipedia/commons/thumb/6/69/The_Doors_1968.JPG/250px-The_Doors_1968.JPG",\n                "Image title": "The Doors in 1966: Morrison (left), Densmore (centre), Krieger (right) and Manzarek (seated)"\n            },\n            "Background information": {\n                "Origin": "Los Angeles, California, U.S.",\n                "Genres": [\n                    "Psychedelic Rock",\n                    "Blues Rock",\n                    "Acid Rock"\n                ],\n                "Years active": [\n                    "1965-1973",\n                    "1978"\n                ],\n                "Labels": "Elektra, Rhino",\n                "Spinoffs": [\n                    "The Psychedelic Rangers",\n                    "Butts Band",\n                    "Nite City",\n                    "Manzarek-Krieger"\n                ],\n                "Spinoff of": "Rick & the Ravens",\n                "Past members": [\n                    "Jim Morrison",\n                    "Ray Manzarek",\n                    "Robby Krieger",\n                    "John Densmore"\n                ],\n                "Website": "thedoors.com"\n            }\n        }\n    }\n}\n```\n</details>\n',
    'author': 'd3z',
    'author_email': 'd3z.the.dev@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/d3z-the-dev/wiki-fetch',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
