"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StreamEventSource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Use an stream as an event source for AWS Lambda.
 *
 * @stability stable
 */
class StreamEventSource {
    /**
     * @stability stable
     */
    constructor(props) {
        this.props = props;
    }
    /**
     * @stability stable
     */
    enrichMappingOptions(options) {
        return {
            ...options,
            batchSize: this.props.batchSize || 100,
            bisectBatchOnError: this.props.bisectBatchOnError,
            startingPosition: this.props.startingPosition,
            maxBatchingWindow: this.props.maxBatchingWindow,
            maxRecordAge: this.props.maxRecordAge,
            retryAttempts: this.props.retryAttempts,
            parallelizationFactor: this.props.parallelizationFactor,
            onFailure: this.props.onFailure,
            enabled: this.props.enabled,
        };
    }
}
exports.StreamEventSource = StreamEventSource;
_a = JSII_RTTI_SYMBOL_1;
StreamEventSource[_a] = { fqn: "@aws-cdk/aws-lambda-event-sources.StreamEventSource", version: "1.90.1" };
//# sourceMappingURL=data:application/json;base64,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