import * as iam from '@aws-cdk/aws-iam';
import * as cdk from '@aws-cdk/core';
/**
 * (experimental) Describes a Github OpenID Connect Identity Provider for AWS IAM.
 *
 * @experimental
 */
export interface IGithubActionsIdentityProvider extends iam.IOpenIdConnectProvider {
}
/**
 * (experimental) Github Actions as OpenID Connect Identity Provider for AWS IAM. There can be only one (per AWS Account).
 *
 * Use `fromAccount` to retrieve a reference to existing Github OIDC provider.
 *
 * @see https://docs.github.com/en/actions/deployment/security-hardening-your-deployments/configuring-openid-connect-in-amazon-web-services
 * @experimental
 */
export declare class GithubActionsIdentityProvider extends iam.OpenIdConnectProvider implements IGithubActionsIdentityProvider {
    /**
     * @experimental
     */
    static readonly issuer: string;
    /**
     * @experimental
     */
    static readonly thumbprints: string[];
    /**
     * (experimental) Retrieve a reference to existing Github OIDC provider in your AWS account.
     *
     * An AWS account can only have single Github OIDC provider configured into it,
     * so internally the reference is made by constructing the ARN from AWS
     * Account ID & Github issuer URL.
     *
     * @param scope CDK Stack or Construct to which the provider is assigned to.
     * @param id CDK Construct ID given to the construct.
     * @returns a CDK Construct representing the Github OIDC provider
     * @experimental
     * @example
     *
     * GithubActionsIdentityProvider.fromAccount(scope, "GithubProvider");
     */
    static fromAccount(scope: cdk.Construct, id: string): IGithubActionsIdentityProvider;
    /**
     * (experimental) Define a new Github OpenID Connect Identity PRovider for AWS IAM.
     *
     * There can be only one (per AWS Account).
     *
     * @param scope CDK Stack or Construct to which the provider is assigned to.
     * @param id CDK Construct ID given to the construct.
     * @experimental
     * @example
     *
     * new GithubActionsIdentityProvider(scope, "GithubProvider");
     */
    constructor(scope: cdk.Construct, id: string);
}
